/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.FBUtilities;

public abstract class AbstractReadCommandBuilder {
    protected final ColumnFamilyStore cfs;
    protected int nowInSeconds;
    private int cqlLimit = -1;
    private int pagingLimit = -1;
    protected boolean reversed = false;
    protected Set<ColumnIdentifier> columns;
    protected final RowFilter filter = RowFilter.create();
    private ClusteringBound lowerClusteringBound;
    private ClusteringBound upperClusteringBound;
    private NavigableSet<Clustering> clusterings;

    AbstractReadCommandBuilder(ColumnFamilyStore cfs) {
        this.cfs = cfs;
        this.nowInSeconds = FBUtilities.nowInSeconds();
    }

    public AbstractReadCommandBuilder withNowInSeconds(int nowInSec) {
        this.nowInSeconds = nowInSec;
        return this;
    }

    public AbstractReadCommandBuilder fromIncl(Object ... values) {
        assert (this.lowerClusteringBound == null && this.clusterings == null);
        this.lowerClusteringBound = ClusteringBound.create(this.cfs.metadata().comparator, true, true, values);
        return this;
    }

    public AbstractReadCommandBuilder fromExcl(Object ... values) {
        assert (this.lowerClusteringBound == null && this.clusterings == null);
        this.lowerClusteringBound = ClusteringBound.create(this.cfs.metadata().comparator, true, false, values);
        return this;
    }

    public AbstractReadCommandBuilder toIncl(Object ... values) {
        assert (this.upperClusteringBound == null && this.clusterings == null);
        this.upperClusteringBound = ClusteringBound.create(this.cfs.metadata().comparator, false, true, values);
        return this;
    }

    public AbstractReadCommandBuilder toExcl(Object ... values) {
        assert (this.upperClusteringBound == null && this.clusterings == null);
        this.upperClusteringBound = ClusteringBound.create(this.cfs.metadata().comparator, false, false, values);
        return this;
    }

    public AbstractReadCommandBuilder includeRow(Object ... values) {
        assert (this.lowerClusteringBound == null && this.upperClusteringBound == null);
        if (this.clusterings == null) {
            this.clusterings = new TreeSet<Clusterable>(this.cfs.metadata().comparator);
        }
        this.clusterings.add(this.cfs.metadata().comparator.make(values));
        return this;
    }

    public AbstractReadCommandBuilder reverse() {
        this.reversed = true;
        return this;
    }

    public AbstractReadCommandBuilder withLimit(int newLimit) {
        this.cqlLimit = newLimit;
        return this;
    }

    public AbstractReadCommandBuilder withPagingLimit(int newLimit) {
        this.pagingLimit = newLimit;
        return this;
    }

    public AbstractReadCommandBuilder columns(String ... columns) {
        if (this.columns == null) {
            this.columns = Sets.newHashSetWithExpectedSize((int)columns.length);
        }
        for (String column : columns) {
            this.columns.add(ColumnIdentifier.getInterned(column, true));
        }
        return this;
    }

    private ByteBuffer bb(Object value, AbstractType<?> type) {
        return value instanceof ByteBuffer ? (ByteBuffer)value : type.decompose(value);
    }

    private AbstractType<?> forValues(AbstractType<?> collectionType) {
        assert (collectionType instanceof CollectionType);
        CollectionType ct = (CollectionType)collectionType;
        switch (ct.kind) {
            case LIST: 
            case MAP: {
                return ct.valueComparator();
            }
            case SET: {
                return ct.nameComparator();
            }
        }
        throw new AssertionError();
    }

    private AbstractType<?> forKeys(AbstractType<?> collectionType) {
        assert (collectionType instanceof CollectionType);
        CollectionType ct = (CollectionType)collectionType;
        switch (ct.kind) {
            case LIST: 
            case MAP: {
                return ct.nameComparator();
            }
        }
        throw new AssertionError();
    }

    public AbstractReadCommandBuilder filterOn(String column, Operator op, Object value) {
        ColumnMetadata def = this.cfs.metadata().getColumn(ColumnIdentifier.getInterned(column, true));
        assert (def != null);
        AbstractType<?> type = def.type;
        if (op == Operator.CONTAINS) {
            type = this.forValues(type);
        } else if (op == Operator.CONTAINS_KEY) {
            type = this.forKeys(type);
        }
        this.filter.add(def, op, this.bb(value, type));
        return this;
    }

    protected ColumnFilter makeColumnFilter() {
        if (this.columns == null || this.columns.isEmpty()) {
            return ColumnFilter.all(this.cfs.metadata());
        }
        ColumnFilter.Builder filter = ColumnFilter.selectionBuilder();
        for (ColumnIdentifier column : this.columns) {
            filter.add(this.cfs.metadata().getColumn(column));
        }
        return filter.build();
    }

    protected ClusteringIndexFilter makeFilter() {
        if (this.cfs.metadata().isStaticCompactTable()) {
            return new ClusteringIndexNamesFilter(new TreeSet<Clusterable>(this.cfs.metadata().comparator), this.reversed);
        }
        if (this.clusterings != null) {
            return new ClusteringIndexNamesFilter(this.clusterings, this.reversed);
        }
        Slice slice = Slice.make(this.lowerClusteringBound == null ? ClusteringBound.BOTTOM : this.lowerClusteringBound, this.upperClusteringBound == null ? ClusteringBound.TOP : this.upperClusteringBound);
        return new ClusteringIndexSliceFilter(Slices.with(this.cfs.metadata().comparator, slice), this.reversed);
    }

    protected DataLimits makeLimits() {
        DataLimits limits;
        DataLimits dataLimits = limits = this.cqlLimit < 0 ? DataLimits.NONE : DataLimits.cqlLimits(this.cqlLimit);
        if (this.pagingLimit >= 0) {
            limits = limits.forPaging(this.pagingLimit);
        }
        return limits;
    }

    public abstract ReadCommand build();

    public static class PartitionRangeBuilder
    extends AbstractReadCommandBuilder {
        private DecoratedKey startKey;
        private boolean startInclusive;
        private DecoratedKey endKey;
        private boolean endInclusive;

        public PartitionRangeBuilder(ColumnFamilyStore cfs) {
            super(cfs);
        }

        public PartitionRangeBuilder fromKeyIncl(Object ... values) {
            assert (this.startKey == null);
            this.startInclusive = true;
            this.startKey = PartitionRangeBuilder.makeKey(this.cfs.metadata(), values);
            return this;
        }

        public PartitionRangeBuilder fromKeyExcl(Object ... values) {
            assert (this.startKey == null);
            this.startInclusive = false;
            this.startKey = PartitionRangeBuilder.makeKey(this.cfs.metadata(), values);
            return this;
        }

        public PartitionRangeBuilder toKeyIncl(Object ... values) {
            assert (this.endKey == null);
            this.endInclusive = true;
            this.endKey = PartitionRangeBuilder.makeKey(this.cfs.metadata(), values);
            return this;
        }

        public PartitionRangeBuilder toKeyExcl(Object ... values) {
            assert (this.endKey == null);
            this.endInclusive = false;
            this.endKey = PartitionRangeBuilder.makeKey(this.cfs.metadata(), values);
            return this;
        }

        @Override
        public ReadCommand build() {
            PartitionPosition end;
            PartitionPosition start = this.startKey;
            if (start == null) {
                start = this.cfs.getPartitioner().getMinimumToken().maxKeyBound();
                this.startInclusive = false;
            }
            if ((end = this.endKey) == null) {
                end = this.cfs.getPartitioner().getMinimumToken().maxKeyBound();
                this.endInclusive = true;
            }
            AbstractBounds bounds = this.startInclusive && this.endInclusive ? new Bounds<DecoratedKey>((DecoratedKey)start, (DecoratedKey)end) : (this.startInclusive && !this.endInclusive ? new IncludingExcludingBounds<DecoratedKey>((DecoratedKey)start, (DecoratedKey)end) : (!this.startInclusive && this.endInclusive ? new Range<DecoratedKey>((DecoratedKey)start, (DecoratedKey)end) : new ExcludingBounds<DecoratedKey>((DecoratedKey)start, (DecoratedKey)end)));
            return PartitionRangeReadCommand.create(this.cfs.metadata(), this.nowInSeconds, this.makeColumnFilter(), this.filter, this.makeLimits(), new DataRange(bounds, this.makeFilter()));
        }

        static DecoratedKey makeKey(TableMetadata metadata, Object ... partitionKey) {
            if (partitionKey.length == 1 && partitionKey[0] instanceof DecoratedKey) {
                return (DecoratedKey)partitionKey[0];
            }
            ByteBuffer key = metadata.partitionKeyAsClusteringComparator().make(partitionKey).serializeAsPartitionKey();
            return metadata.partitioner.decorateKey(key);
        }
    }

    public static class SinglePartitionSliceBuilder
    extends AbstractReadCommandBuilder {
        private final DecoratedKey partitionKey;
        private Slices.Builder sliceBuilder;

        public SinglePartitionSliceBuilder(ColumnFamilyStore cfs, DecoratedKey key) {
            super(cfs);
            this.partitionKey = key;
            this.sliceBuilder = new Slices.Builder(cfs.getComparator());
        }

        public SinglePartitionSliceBuilder addSlice(Slice slice) {
            this.sliceBuilder.add(slice);
            return this;
        }

        @Override
        protected ClusteringIndexFilter makeFilter() {
            return new ClusteringIndexSliceFilter(this.sliceBuilder.build(), this.reversed);
        }

        @Override
        public ReadCommand build() {
            return SinglePartitionReadCommand.create(this.cfs.metadata(), this.nowInSeconds, this.makeColumnFilter(), this.filter, this.makeLimits(), this.partitionKey, this.makeFilter());
        }
    }

    public static class SinglePartitionBuilder
    extends AbstractReadCommandBuilder {
        private final DecoratedKey partitionKey;

        public SinglePartitionBuilder(ColumnFamilyStore cfs, DecoratedKey key) {
            super(cfs);
            this.partitionKey = key;
        }

        @Override
        public ReadCommand build() {
            return SinglePartitionReadCommand.create(this.cfs.metadata(), this.nowInSeconds, this.makeColumnFilter(), this.filter, this.makeLimits(), this.partitionKey, this.makeFilter());
        }
    }
}

