/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.KeyspaceAttributes;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class CreateKeyspaceStatement
extends AlterSchemaStatement {
    private final KeyspaceAttributes attrs;
    private final boolean ifNotExists;

    public CreateKeyspaceStatement(String keyspaceName, KeyspaceAttributes attrs, boolean ifNotExists) {
        super(keyspaceName);
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        this.attrs.validate();
        if (!this.attrs.hasOption(KeyspaceParams.Option.REPLICATION)) {
            throw CreateKeyspaceStatement.ire("Missing mandatory option '%s'", new Object[]{KeyspaceParams.Option.REPLICATION});
        }
        if (schema.containsKeyspace(this.keyspaceName)) {
            if (this.ifNotExists) {
                return schema;
            }
            throw new AlreadyExistsException(this.keyspaceName);
        }
        KeyspaceMetadata keyspace = KeyspaceMetadata.create(this.keyspaceName, this.attrs.asNewKeyspaceParams());
        if (keyspace.params.replication.klass.equals(LocalStrategy.class)) {
            throw CreateKeyspaceStatement.ire("Unable to use given strategy class: LocalStrategy is reserved for internal use.", new Object[0]);
        }
        keyspace.params.validate(this.keyspaceName);
        return schema.withAddedOrUpdated(keyspace);
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, this.keyspaceName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureAllKeyspacesPermission(Permission.CREATE);
    }

    @Override
    Set<IResource> createdResources(Keyspaces.KeyspacesDiff diff) {
        return ImmutableSet.of((Object)DataResource.keyspace(this.keyspaceName), (Object)FunctionResource.keyspace(this.keyspaceName));
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_KEYSPACE, this.keyspaceName);
    }

    public String toString() {
        return String.format("%s (%s)", this.getClass().getSimpleName(), this.keyspaceName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        public final String keyspaceName;
        private final KeyspaceAttributes attrs;
        private final boolean ifNotExists;

        public Raw(String keyspaceName, KeyspaceAttributes attrs, boolean ifNotExists) {
            this.keyspaceName = keyspaceName;
            this.attrs = attrs;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateKeyspaceStatement prepare(ClientState state) {
            return new CreateKeyspaceStatement(this.keyspaceName, this.attrs, this.ifNotExists);
        }
    }
}

