/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.ProtocolVersion;

public final class CreateAggregateStatement
extends AlterSchemaStatement {
    private final String aggregateName;
    private final List<CQL3Type.Raw> rawArgumentTypes;
    private final CQL3Type.Raw rawStateType;
    private final FunctionName stateFunctionName;
    private final FunctionName finalFunctionName;
    private final Term.Raw rawInitialValue;
    private final boolean orReplace;
    private final boolean ifNotExists;

    public CreateAggregateStatement(String keyspaceName, String aggregateName, List<CQL3Type.Raw> rawArgumentTypes, CQL3Type.Raw rawStateType, FunctionName stateFunctionName, FunctionName finalFunctionName, Term.Raw rawInitialValue, boolean orReplace, boolean ifNotExists) {
        super(keyspaceName);
        this.aggregateName = aggregateName;
        this.rawArgumentTypes = rawArgumentTypes;
        this.rawStateType = rawStateType;
        this.stateFunctionName = stateFunctionName;
        this.finalFunctionName = finalFunctionName;
        this.rawInitialValue = rawInitialValue;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        if (this.ifNotExists && this.orReplace) {
            throw CreateAggregateStatement.ire("Cannot use both 'OR REPLACE' and 'IF NOT EXISTS' directives", new Object[0]);
        }
        this.rawArgumentTypes.stream().filter(CQL3Type.Raw::isFrozen).findFirst().ifPresent(t -> {
            throw CreateAggregateStatement.ire("Argument '%s' cannot be frozen; remove frozen<> modifier from '%s'", t, t);
        });
        if (this.rawStateType.isFrozen()) {
            throw CreateAggregateStatement.ire("State type '%s' cannot be frozen; remove frozen<> modifier from '%s'", this.rawStateType, this.rawStateType);
        }
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw CreateAggregateStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        List<AbstractType<?>> argumentTypes = this.rawArgumentTypes.stream().map(t -> t.prepare(this.keyspaceName, keyspace.types).getType()).collect(Collectors.toList());
        AbstractType<?> stateType = this.rawStateType.prepare(this.keyspaceName, keyspace.types).getType();
        ArrayList stateFunctionArguments = Lists.newArrayList((Iterable)Iterables.concat(Collections.singleton(stateType), argumentTypes));
        Function stateFunction = keyspace.functions.find(this.stateFunctionName, stateFunctionArguments).orElseThrow(() -> CreateAggregateStatement.ire("State function %s doesn't exist", this.stateFunctionString()));
        if (stateFunction.isAggregate()) {
            throw CreateAggregateStatement.ire("State function %s isn't a scalar function", this.stateFunctionString());
        }
        if (!stateFunction.returnType().equals(stateType)) {
            throw CreateAggregateStatement.ire("State function %s return type must be the same as the first argument type - check STYPE, argument and return types", this.stateFunctionString());
        }
        Function finalFunction = null;
        AbstractType<?> returnType = stateFunction.returnType();
        if (null != this.finalFunctionName) {
            finalFunction = keyspace.functions.find(this.finalFunctionName, Collections.singletonList(stateType)).orElse(null);
            if (null == finalFunction) {
                throw CreateAggregateStatement.ire("Final function %s doesn't exist", this.finalFunctionString());
            }
            if (finalFunction.isAggregate()) {
                throw CreateAggregateStatement.ire("Final function %s isn't a scalar function", this.finalFunctionString());
            }
            returnType = finalFunction.returnType();
        }
        ByteBuffer initialValue = null;
        if (null != this.rawInitialValue) {
            initialValue = Terms.asBytes(this.keyspaceName, this.rawInitialValue.toString(), stateType);
            if (null != initialValue) {
                try {
                    stateType.validate(initialValue);
                }
                catch (MarshalException e) {
                    throw CreateAggregateStatement.ire("Invalid value for INITCOND of type %s", stateType.asCQL3Type());
                }
            }
            String initialValueString = stateType.asCQL3Type().toCQLLiteral(initialValue, ProtocolVersion.CURRENT);
            assert (Objects.equal((Object)initialValue, (Object)Terms.asBytes(this.keyspaceName, initialValueString, stateType)));
            if (Constants.NULL_LITERAL != this.rawInitialValue && UDHelper.isNullOrEmpty(stateType, initialValue)) {
                throw CreateAggregateStatement.ire("INITCOND must not be empty for all types except TEXT, ASCII, BLOB", new Object[0]);
            }
        }
        if (!((UDFunction)stateFunction).isCalledOnNullInput() && null == initialValue) {
            throw CreateAggregateStatement.ire("Cannot create aggregate '%s' without INITCOND because state function %s does not accept 'null' arguments", this.aggregateName, this.stateFunctionName);
        }
        UDAggregate aggregate = new UDAggregate(new FunctionName(this.keyspaceName, this.aggregateName), argumentTypes, returnType, (ScalarFunction)stateFunction, (ScalarFunction)finalFunction, initialValue);
        Function existingAggregate = keyspace.functions.find(aggregate.name(), argumentTypes).orElse(null);
        if (null != existingAggregate) {
            if (!existingAggregate.isAggregate()) {
                throw CreateAggregateStatement.ire("Aggregate '%s' cannot replace a function", this.aggregateName);
            }
            if (this.ifNotExists) {
                return schema;
            }
            if (!this.orReplace) {
                throw CreateAggregateStatement.ire("Aggregate '%s' already exists", this.aggregateName);
            }
            if (!returnType.isCompatibleWith(existingAggregate.returnType())) {
                throw CreateAggregateStatement.ire("Cannot replace aggregate '%s', the new return type %s isn't compatible with the return type %s of existing function", this.aggregateName, returnType.asCQL3Type(), existingAggregate.returnType().asCQL3Type());
            }
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.functions.withAddedOrUpdated(aggregate)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        assert (diff.altered.size() == 1);
        Functions.FunctionsDiff<UDAggregate> udasDiff = ((KeyspaceMetadata.KeyspaceDiff)diff.altered.get((int)0)).udas;
        assert (((Functions)udasDiff.created).size() + udasDiff.altered.size() == 1);
        boolean created = !((Functions)udasDiff.created).isEmpty();
        return new Event.SchemaChange(created ? Event.SchemaChange.Change.CREATED : Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.AGGREGATE, this.keyspaceName, this.aggregateName, this.rawArgumentTypes.stream().map(Object::toString).collect(Collectors.toList()));
    }

    @Override
    public void authorize(ClientState client) {
        FunctionName name = new FunctionName(this.keyspaceName, this.aggregateName);
        if (Schema.instance.findFunction(name, Lists.transform(this.rawArgumentTypes, t -> t.prepare(this.keyspaceName).getType())).isPresent() && this.orReplace) {
            client.ensurePermission(Permission.ALTER, FunctionResource.functionFromCql(this.keyspaceName, this.aggregateName, this.rawArgumentTypes));
        } else {
            client.ensurePermission(Permission.CREATE, FunctionResource.keyspace(this.keyspaceName));
        }
        FunctionResource stateFunction = FunctionResource.functionFromCql(this.stateFunctionName, Lists.newArrayList((Iterable)Iterables.concat(Collections.singleton(this.rawStateType), this.rawArgumentTypes)));
        client.ensurePermission(Permission.EXECUTE, stateFunction);
        if (null != this.finalFunctionName) {
            client.ensurePermission(Permission.EXECUTE, FunctionResource.functionFromCql(this.finalFunctionName, Collections.singletonList(this.rawStateType)));
        }
    }

    @Override
    Set<IResource> createdResources(Keyspaces.KeyspacesDiff diff) {
        assert (diff.altered.size() == 1);
        Functions.FunctionsDiff<UDAggregate> udasDiff = ((KeyspaceMetadata.KeyspaceDiff)diff.altered.get((int)0)).udas;
        assert (((Functions)udasDiff.created).size() + udasDiff.altered.size() == 1);
        return ((Functions)udasDiff.created).isEmpty() ? ImmutableSet.of() : ImmutableSet.of((Object)FunctionResource.functionFromCql(this.keyspaceName, this.aggregateName, this.rawArgumentTypes));
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_AGGREGATE, this.keyspaceName, this.aggregateName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.aggregateName);
    }

    private String stateFunctionString() {
        return String.format("%s(%s)", this.stateFunctionName, String.join((CharSequence)", ", Iterables.transform((Iterable)Iterables.concat(Collections.singleton(this.rawStateType), this.rawArgumentTypes), Object::toString)));
    }

    private String finalFunctionString() {
        return String.format("%s(%s)", this.finalFunctionName, this.rawStateType);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final FunctionName aggregateName;
        private final List<CQL3Type.Raw> rawArgumentTypes;
        private final CQL3Type.Raw rawStateType;
        private final String stateFunctionName;
        private final String finalFunctionName;
        private final Term.Raw rawInitialValue;
        private final boolean orReplace;
        private final boolean ifNotExists;

        public Raw(FunctionName aggregateName, List<CQL3Type.Raw> rawArgumentTypes, CQL3Type.Raw rawStateType, String stateFunctionName, String finalFunctionName, Term.Raw rawInitialValue, boolean orReplace, boolean ifNotExists) {
            this.aggregateName = aggregateName;
            this.rawArgumentTypes = rawArgumentTypes;
            this.rawStateType = rawStateType;
            this.stateFunctionName = stateFunctionName;
            this.finalFunctionName = finalFunctionName;
            this.rawInitialValue = rawInitialValue;
            this.orReplace = orReplace;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateAggregateStatement prepare(ClientState state) {
            String keyspaceName = this.aggregateName.hasKeyspace() ? this.aggregateName.keyspace : state.getKeyspace();
            return new CreateAggregateStatement(keyspaceName, this.aggregateName.name, this.rawArgumentTypes, this.rawStateType, new FunctionName(keyspaceName, this.stateFunctionName), null != this.finalFunctionName ? new FunctionName(keyspaceName, this.finalFunctionName) : null, this.rawInitialValue, this.orReplace, this.ifNotExists);
        }
    }
}

