/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;

public final class CounterCacheKey
extends CacheKey {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new CounterCacheKey(TableMetadata.builder("ks", "tab").addPartitionKeyColumn("pk", (AbstractType)UTF8Type.instance).build(), ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBuffer.allocate(1)));
    private final byte[] partitionKey;
    private final byte[] cellName;

    private CounterCacheKey(TableMetadata tableMetadata, byte[] partitionKey, byte[] cellName) {
        super(tableMetadata);
        this.partitionKey = partitionKey;
        this.cellName = cellName;
    }

    private CounterCacheKey(TableMetadata tableMetadata, ByteBuffer partitionKey, ByteBuffer cellName) {
        this(tableMetadata, ByteBufferUtil.getArray(partitionKey), ByteBufferUtil.getArray(cellName));
    }

    public static CounterCacheKey create(TableMetadata tableMetadata, ByteBuffer partitionKey, Clustering clustering, ColumnMetadata c, CellPath path) {
        return new CounterCacheKey(tableMetadata, partitionKey, CounterCacheKey.makeCellName(clustering, c, path));
    }

    private static ByteBuffer makeCellName(Clustering clustering, ColumnMetadata c, CellPath path) {
        int i;
        int cs = clustering.size();
        ByteBuffer[] values = new ByteBuffer[cs + 1 + (path == null ? 0 : path.size())];
        for (i = 0; i < cs; ++i) {
            values[i] = clustering.get(i);
        }
        values[cs] = c.name.bytes;
        if (path != null) {
            for (i = 0; i < path.size(); ++i) {
                values[cs + 1 + i] = path.get(i);
            }
        }
        return CompositeType.build(values);
    }

    public ByteBuffer partitionKey() {
        return ByteBuffer.wrap(this.partitionKey);
    }

    /*
     * Exception decompiling
     */
    public ByteBuffer readCounterValue(ColumnFamilyStore cfs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write(DataOutputPlus out) throws IOException {
        ByteBufferUtil.writeWithLength(this.partitionKey, (DataOutput)out);
        ByteBufferUtil.writeWithLength(this.cellName, (DataOutput)out);
    }

    public static CounterCacheKey read(TableMetadata tableMetadata, DataInputPlus in) throws IOException {
        return new CounterCacheKey(tableMetadata, ByteBufferUtil.readBytesWithLength(in), ByteBufferUtil.readBytesWithLength(in));
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.partitionKey) + ObjectSizes.sizeOfArray(this.cellName);
    }

    public String toString() {
        TableMetadataRef tableRef = Schema.instance.getTableMetadataRef(this.tableId);
        return String.format("CounterCacheKey(%s, %s, %s, %s)", tableRef, this.indexName, ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.partitionKey)), ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.cellName)));
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.tableId, this.indexName, this.partitionKey, this.cellName});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CounterCacheKey)) {
            return false;
        }
        CounterCacheKey cck = (CounterCacheKey)o;
        return this.tableId.equals(cck.tableId) && Objects.equals(this.indexName, cck.indexName) && Arrays.equals(this.partitionKey, cck.partitionKey) && Arrays.equals(this.cellName, cck.cellName);
    }
}

