/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashingUtils {
    public static final HashFunction CURRENT_HASH_FUNCTION = Hashing.md5();

    public static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("the requested digest algorithm (" + algorithm + ") is not available", nsae);
        }
    }

    public static void updateBytes(Hasher hasher, ByteBuffer input) {
        if (!input.hasRemaining()) {
            return;
        }
        if (input.hasArray()) {
            byte[] b = input.array();
            int ofs = input.arrayOffset();
            int pos = input.position();
            int lim = input.limit();
            hasher.putBytes(b, ofs + pos, lim - pos);
            input.position(lim);
        } else {
            int chunk;
            int len;
            int n = Math.min(len, 4096);
            byte[] tempArray = new byte[n];
            for (len = input.remaining(); len > 0; len -= chunk) {
                chunk = Math.min(len, tempArray.length);
                input.get(tempArray, 0, chunk);
                hasher.putBytes(tempArray, 0, chunk);
            }
        }
    }

    public static void updateWithShort(Hasher hasher, int val) {
        hasher.putByte((byte)(val >> 8 & 0xFF));
        hasher.putByte((byte)(val & 0xFF));
    }

    public static void updateWithByte(Hasher hasher, int val) {
        hasher.putByte((byte)(val & 0xFF));
    }

    public static void updateWithInt(Hasher hasher, int val) {
        hasher.putByte((byte)(val >>> 24 & 0xFF));
        hasher.putByte((byte)(val >>> 16 & 0xFF));
        hasher.putByte((byte)(val >>> 8 & 0xFF));
        hasher.putByte((byte)(val >>> 0 & 0xFF));
    }

    public static void updateWithLong(Hasher hasher, long val) {
        hasher.putByte((byte)(val >>> 56 & 0xFFL));
        hasher.putByte((byte)(val >>> 48 & 0xFFL));
        hasher.putByte((byte)(val >>> 40 & 0xFFL));
        hasher.putByte((byte)(val >>> 32 & 0xFFL));
        hasher.putByte((byte)(val >>> 24 & 0xFFL));
        hasher.putByte((byte)(val >>> 16 & 0xFFL));
        hasher.putByte((byte)(val >>> 8 & 0xFFL));
        hasher.putByte((byte)(val >>> 0 & 0xFFL));
    }

    public static void updateWithBoolean(Hasher hasher, boolean val) {
        HashingUtils.updateWithByte(hasher, val ? 0 : 1);
    }
}

