/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.MD5Digest;

public abstract class ResultMessage
extends Message.Response {
    public static final Message.Codec<ResultMessage> codec = new Message.Codec<ResultMessage>(){

        @Override
        public ResultMessage decode(ByteBuf body, ProtocolVersion version) {
            Kind kind = Kind.fromId(body.readInt());
            return (ResultMessage)kind.subcodec.decode(body, version);
        }

        @Override
        public void encode(ResultMessage msg, ByteBuf dest, ProtocolVersion version) {
            dest.writeInt(msg.kind.id);
            msg.kind.subcodec.encode(msg, dest, version);
        }

        @Override
        public int encodedSize(ResultMessage msg, ProtocolVersion version) {
            return 4 + msg.kind.subcodec.encodedSize(msg, version);
        }
    };
    public final Kind kind;

    protected ResultMessage(Kind kind) {
        super(Message.Type.RESULT);
        this.kind = kind;
    }

    public static class SchemaChange
    extends ResultMessage {
        public final Event.SchemaChange change;
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ByteBuf body, ProtocolVersion version) {
                return new SchemaChange(Event.SchemaChange.deserializeEvent(body, version));
            }

            @Override
            public void encode(ResultMessage msg, ByteBuf dest, ProtocolVersion version) {
                assert (msg instanceof SchemaChange);
                SchemaChange scm = (SchemaChange)msg;
                scm.change.serializeEvent(dest, version);
            }

            @Override
            public int encodedSize(ResultMessage msg, ProtocolVersion version) {
                assert (msg instanceof SchemaChange);
                SchemaChange scm = (SchemaChange)msg;
                return scm.change.eventSerializedSize(version);
            }
        };

        public SchemaChange(Event.SchemaChange change) {
            super(Kind.SCHEMA_CHANGE);
            this.change = change;
        }

        public String toString() {
            return "RESULT schema change " + this.change;
        }
    }

    public static class Prepared
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ByteBuf body, ProtocolVersion version) {
                MD5Digest id = MD5Digest.wrap(CBUtil.readBytes(body));
                MD5Digest resultMetadataId = null;
                if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                    resultMetadataId = MD5Digest.wrap(CBUtil.readBytes(body));
                }
                ResultSet.PreparedMetadata metadata = ResultSet.PreparedMetadata.codec.decode(body, version);
                ResultSet.ResultMetadata resultMetadata = ResultSet.ResultMetadata.EMPTY;
                if (version.isGreaterThan(ProtocolVersion.V1)) {
                    resultMetadata = ResultSet.ResultMetadata.codec.decode(body, version);
                }
                return new Prepared(id, resultMetadataId, metadata, resultMetadata);
            }

            @Override
            public void encode(ResultMessage msg, ByteBuf dest, ProtocolVersion version) {
                assert (msg instanceof Prepared);
                Prepared prepared = (Prepared)msg;
                assert (prepared.statementId != null);
                CBUtil.writeBytes(prepared.statementId.bytes, dest);
                if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                    CBUtil.writeBytes(prepared.resultMetadataId.bytes, dest);
                }
                ResultSet.PreparedMetadata.codec.encode(prepared.metadata, dest, version);
                if (version.isGreaterThan(ProtocolVersion.V1)) {
                    ResultSet.ResultMetadata.codec.encode(prepared.resultMetadata, dest, version);
                }
            }

            @Override
            public int encodedSize(ResultMessage msg, ProtocolVersion version) {
                assert (msg instanceof Prepared);
                Prepared prepared = (Prepared)msg;
                assert (prepared.statementId != null);
                int size = 0;
                size += CBUtil.sizeOfBytes(prepared.statementId.bytes);
                if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                    size += CBUtil.sizeOfBytes(prepared.resultMetadataId.bytes);
                }
                size += ResultSet.PreparedMetadata.codec.encodedSize(prepared.metadata, version);
                if (version.isGreaterThan(ProtocolVersion.V1)) {
                    size += ResultSet.ResultMetadata.codec.encodedSize(prepared.resultMetadata, version);
                }
                return size;
            }
        };
        public final MD5Digest statementId;
        public final MD5Digest resultMetadataId;
        public final ResultSet.PreparedMetadata metadata;
        public final ResultSet.ResultMetadata resultMetadata;

        public Prepared(MD5Digest statementId, MD5Digest resultMetadataId, ResultSet.PreparedMetadata metadata, ResultSet.ResultMetadata resultMetadata) {
            super(Kind.PREPARED);
            this.statementId = statementId;
            this.resultMetadataId = resultMetadataId;
            this.metadata = metadata;
            this.resultMetadata = resultMetadata;
        }

        @VisibleForTesting
        public Prepared withResultMetadata(ResultSet.ResultMetadata resultMetadata) {
            return new Prepared(this.statementId, resultMetadata.getResultMetadataId(), this.metadata, resultMetadata);
        }

        public String toString() {
            return "RESULT PREPARED " + this.statementId + " " + this.metadata + " (resultMetadata=" + this.resultMetadata + ")";
        }
    }

    public static class Rows
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ByteBuf body, ProtocolVersion version) {
                return new Rows(ResultSet.codec.decode(body, version));
            }

            @Override
            public void encode(ResultMessage msg, ByteBuf dest, ProtocolVersion version) {
                assert (msg instanceof Rows);
                Rows rowMsg = (Rows)msg;
                ResultSet.codec.encode(rowMsg.result, dest, version);
            }

            @Override
            public int encodedSize(ResultMessage msg, ProtocolVersion version) {
                assert (msg instanceof Rows);
                Rows rowMsg = (Rows)msg;
                return ResultSet.codec.encodedSize(rowMsg.result, version);
            }
        };
        public final ResultSet result;

        public Rows(ResultSet result) {
            super(Kind.ROWS);
            this.result = result;
        }

        public String toString() {
            return "ROWS " + this.result;
        }
    }

    public static class SetKeyspace
    extends ResultMessage {
        public final String keyspace;
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ByteBuf body, ProtocolVersion version) {
                String keyspace = CBUtil.readString(body);
                return new SetKeyspace(keyspace);
            }

            @Override
            public void encode(ResultMessage msg, ByteBuf dest, ProtocolVersion version) {
                assert (msg instanceof SetKeyspace);
                CBUtil.writeString(((SetKeyspace)msg).keyspace, dest);
            }

            @Override
            public int encodedSize(ResultMessage msg, ProtocolVersion version) {
                assert (msg instanceof SetKeyspace);
                return CBUtil.sizeOfString(((SetKeyspace)msg).keyspace);
            }
        };

        public SetKeyspace(String keyspace) {
            super(Kind.SET_KEYSPACE);
            this.keyspace = keyspace;
        }

        public String toString() {
            return "RESULT set keyspace " + this.keyspace;
        }
    }

    public static class Void
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ByteBuf body, ProtocolVersion version) {
                return new Void();
            }

            @Override
            public void encode(ResultMessage msg, ByteBuf dest, ProtocolVersion version) {
                assert (msg instanceof Void);
            }

            @Override
            public int encodedSize(ResultMessage msg, ProtocolVersion version) {
                return 0;
            }
        };

        public Void() {
            super(Kind.VOID);
        }

        public String toString() {
            return "EMPTY RESULT";
        }
    }

    public static enum Kind {
        VOID(1, Void.subcodec),
        ROWS(2, Rows.subcodec),
        SET_KEYSPACE(3, SetKeyspace.subcodec),
        PREPARED(4, Prepared.subcodec),
        SCHEMA_CHANGE(5, SchemaChange.subcodec);

        public final int id;
        public final Message.Codec<ResultMessage> subcodec;
        private static final Kind[] ids;

        private Kind(int id, Message.Codec<ResultMessage> subcodec) {
            this.id = id;
            this.subcodec = subcodec;
        }

        public static Kind fromId(int id) {
            Kind k = ids[id];
            if (k == null) {
                throw new ProtocolException(String.format("Unknown kind id %d in RESULT message", id));
            }
            return k;
        }

        static {
            int maxId = -1;
            for (Kind k : Kind.values()) {
                maxId = Math.max(maxId, k.id);
            }
            ids = new Kind[maxId + 1];
            for (Kind k : Kind.values()) {
                if (ids[k.id] != null) {
                    throw new IllegalStateException("Duplicate kind id");
                }
                Kind.ids[k.id] = k;
            }
        }
    }
}

