/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.ArrayListMultimap;
import io.airlift.airline.Command;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.HostStatWithPort;
import org.apache.cassandra.tools.nodetool.SetHostStatWithPort;

@Command(name="describecluster", description="Print the name, snitch, partitioner and schema version of a cluster")
public class DescribeCluster
extends NodeTool.NodeToolCmd {
    private boolean resolveIp = false;
    private String keyspace = null;
    private Collection<String> joiningNodes;
    private Collection<String> leavingNodes;
    private Collection<String> movingNodes;
    private Collection<String> liveNodes;
    private Collection<String> unreachableNodes;

    @Override
    public void execute(NodeProbe probe) {
        System.out.println("Cluster Information:");
        System.out.println("\tName: " + probe.getClusterName());
        String snitch = probe.getEndpointSnitchInfoProxy().getSnitchName();
        boolean dynamicSnitchEnabled = false;
        if (snitch.equals(DynamicEndpointSnitch.class.getName())) {
            snitch = probe.getDynamicEndpointSnitchInfoProxy().getSubsnitchClassName();
            dynamicSnitchEnabled = true;
        }
        System.out.println("\tSnitch: " + snitch);
        System.out.println("\tDynamicEndPointSnitch: " + (dynamicSnitchEnabled ? "enabled" : "disabled"));
        System.out.println("\tPartitioner: " + probe.getPartitioner());
        System.out.println("\tSchema versions:");
        Map<String, List<String>> schemaVersions = this.printPort ? probe.getSpProxy().getSchemaVersionsWithPort() : probe.getSpProxy().getSchemaVersions();
        for (String version : schemaVersions.keySet()) {
            System.out.println(String.format("\t\t%s: %s%n", version, schemaVersions.get(version)));
        }
        boolean withPort = true;
        this.joiningNodes = probe.getJoiningNodes(withPort);
        this.leavingNodes = probe.getLeavingNodes(withPort);
        this.movingNodes = probe.getMovingNodes(withPort);
        this.liveNodes = probe.getLiveNodes(withPort);
        this.unreachableNodes = probe.getUnreachableNodes(withPort);
        List<String> keyspaces = probe.getKeyspaces();
        System.out.println("Stats for all nodes:");
        System.out.println("\tLive: " + this.liveNodes.size());
        System.out.println("\tJoining: " + this.joiningNodes.size());
        System.out.println("\tMoving: " + this.movingNodes.size());
        System.out.println("\tLeaving: " + this.leavingNodes.size());
        System.out.println("\tUnreachable: " + this.unreachableNodes.size());
        Map<String, String> tokensToEndpoints = probe.getTokenToEndpointMap(withPort);
        Map<String, Float> ownerships = null;
        try {
            ownerships = probe.effectiveOwnershipWithPort(this.keyspace);
        }
        catch (IllegalStateException ex) {
            ownerships = probe.getOwnershipWithPort();
            System.out.println("Error: " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            System.out.println("%nError: " + ex.getMessage());
            System.exit(1);
        }
        SortedMap<String, SetHostStatWithPort> dcs = NodeTool.getOwnershipByDcWithPort(probe, this.resolveIp, tokensToEndpoints, ownerships);
        System.out.println("\nData Centers: ");
        for (Map.Entry<String, SetHostStatWithPort> dc : dcs.entrySet()) {
            System.out.print("\t" + dc.getKey());
            ArrayListMultimap hostToTokens = ArrayListMultimap.create();
            for (HostStatWithPort stat : dc.getValue()) {
                hostToTokens.put((Object)stat.endpoint, (Object)stat);
            }
            int totalNodes = 0;
            int downNodes = 0;
            for (InetAddressAndPort endpoint : hostToTokens.keySet()) {
                ++totalNodes;
                if (!this.unreachableNodes.contains(endpoint.toString())) continue;
                ++downNodes;
            }
            System.out.print(" #Nodes: " + totalNodes);
            System.out.println(" #Down: " + downNodes);
        }
        System.out.println("\nDatabase versions:");
        Map<String, List<String>> databaseVersions = probe.getGossProxy().getReleaseVersionsWithPort();
        for (String version : databaseVersions.keySet()) {
            System.out.println(String.format("\t%s: %s%n", version, databaseVersions.get(version)));
        }
        System.out.println("Keyspaces:");
        for (String keyspaceName : keyspaces) {
            String replicationInfo = probe.getKeyspaceReplicationInfo(keyspaceName);
            if (replicationInfo == null) {
                System.out.println("something went wrong for keyspace: " + keyspaceName);
            }
            System.out.println("\t" + keyspaceName + " -> Replication class: " + replicationInfo);
        }
    }
}

