/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.compress;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.net.AsyncStreamingInputPlus;
import org.apache.cassandra.streaming.async.StreamCompressionSerializer;

public class StreamCompressionInputStream
extends RebufferingInputStream
implements AutoCloseable {
    private final DataInputPlus dataInputPlus;
    private final LZ4FastDecompressor decompressor;
    private final int protocolVersion;
    private final StreamCompressionSerializer deserializer;
    private ByteBuf currentBuf = Unpooled.EMPTY_BUFFER;

    public StreamCompressionInputStream(DataInputPlus dataInputPlus, int protocolVersion) {
        super(Unpooled.EMPTY_BUFFER.nioBuffer());
        this.dataInputPlus = dataInputPlus;
        this.protocolVersion = protocolVersion;
        this.decompressor = LZ4Factory.fastestInstance().fastDecompressor();
        PooledByteBufAllocator allocator = dataInputPlus instanceof AsyncStreamingInputPlus ? ((AsyncStreamingInputPlus)dataInputPlus).getAllocator() : PooledByteBufAllocator.DEFAULT;
        this.deserializer = new StreamCompressionSerializer((ByteBufAllocator)allocator);
    }

    @Override
    public void reBuffer() throws IOException {
        this.currentBuf.release();
        this.currentBuf = this.deserializer.deserialize(this.decompressor, this.dataInputPlus, this.protocolVersion);
        this.buffer = this.currentBuf.nioBuffer(0, this.currentBuf.readableBytes());
    }

    @Override
    public void close() {
        this.currentBuf.release();
    }
}

