/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.utils.concurrent.Accumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseResolver<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>> {
    protected static final Logger logger = LoggerFactory.getLogger(ResponseResolver.class);
    protected final ReadCommand command;
    protected final ReplicaPlan.Shared<E, P> replicaPlan;
    protected final Accumulator<Message<ReadResponse>> responses;
    protected final long queryStartNanoTime;

    public ResponseResolver(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, long queryStartNanoTime) {
        this.command = command;
        this.replicaPlan = replicaPlan;
        this.responses = new Accumulator(((AbstractReplicaCollection)((ReplicaPlan.ForRead)replicaPlan.get()).candidates()).size());
        this.queryStartNanoTime = queryStartNanoTime;
    }

    protected P replicaPlan() {
        return (P)((ReplicaPlan.ForRead)this.replicaPlan.get());
    }

    public abstract boolean isDataPresent();

    public void preprocess(Message<ReadResponse> message) {
        if (((ReplicaPlan.ForRead)this.replicaPlan()).getReplicaFor(message.from()).isTransient() && ((ReadResponse)message.payload).isDigestResponse()) {
            throw new IllegalArgumentException("Digest response received from transient replica");
        }
        try {
            this.responses.add(message);
        }
        catch (IllegalStateException e) {
            logger.error("Encountered error while trying to preprocess the message {}, in command {}, replica plan: {}", new Object[]{message, this.command, this.replicaPlan});
            throw e;
        }
    }

    public Accumulator<Message<ReadResponse>> getMessages() {
        return this.responses;
    }
}

