/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.streaming.ComponentManifest;
import org.apache.cassandra.db.streaming.CompressionInfo;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CassandraStreamHeader {
    public final Version version;
    public final SSTableFormat.Type format;
    public final long estimatedKeys;
    public final List<SSTableReader.PartitionPositionBounds> sections;
    private final CompressionMetadata compressionMetadata;
    public volatile CompressionInfo compressionInfo;
    public final int sstableLevel;
    public final SerializationHeader.Component serializationHeader;
    public final boolean isEntireSSTable;
    public final DecoratedKey firstKey;
    public final TableId tableId;
    public final ComponentManifest componentManifest;
    private final transient long size;
    public static final IVersionedSerializer<CassandraStreamHeader> serializer = new CassandraStreamHeaderSerializer();

    private CassandraStreamHeader(Builder builder) {
        this.version = builder.version;
        this.format = builder.format;
        this.estimatedKeys = builder.estimatedKeys;
        this.sections = builder.sections;
        this.compressionMetadata = builder.compressionMetadata;
        this.compressionInfo = builder.compressionInfo;
        this.sstableLevel = builder.sstableLevel;
        this.serializationHeader = builder.serializationHeader;
        this.tableId = builder.tableId;
        this.isEntireSSTable = builder.isEntireSSTable;
        this.componentManifest = builder.componentManifest;
        this.firstKey = builder.firstKey;
        this.size = this.calculateSize();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isCompressed() {
        return this.compressionInfo != null;
    }

    public long size() {
        return this.size;
    }

    private long calculateSize() {
        if (this.isEntireSSTable) {
            return this.componentManifest.totalSize();
        }
        long transferSize = 0L;
        if (this.compressionInfo != null) {
            for (CompressionMetadata.Chunk chunk : this.compressionInfo.chunks) {
                transferSize += (long)(chunk.length + 4);
            }
        } else {
            for (SSTableReader.PartitionPositionBounds section : this.sections) {
                transferSize += section.upperPosition - section.lowerPosition;
            }
        }
        return transferSize;
    }

    public synchronized void calculateCompressionInfo() {
        if (this.compressionMetadata != null && this.compressionInfo == null) {
            this.compressionInfo = CompressionInfo.fromCompressionMetadata(this.compressionMetadata, this.sections);
        }
    }

    public String toString() {
        return "CassandraStreamHeader{version=" + this.version + ", format=" + (Object)((Object)this.format) + ", estimatedKeys=" + this.estimatedKeys + ", sections=" + this.sections + ", sstableLevel=" + this.sstableLevel + ", header=" + this.serializationHeader + ", isEntireSSTable=" + this.isEntireSSTable + ", firstKey=" + this.firstKey + ", tableId=" + this.tableId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraStreamHeader that = (CassandraStreamHeader)o;
        return this.estimatedKeys == that.estimatedKeys && this.sstableLevel == that.sstableLevel && this.isEntireSSTable == that.isEntireSSTable && Objects.equals(this.version, that.version) && this.format == that.format && Objects.equals(this.sections, that.sections) && Objects.equals(this.compressionInfo, that.compressionInfo) && Objects.equals(this.serializationHeader, that.serializationHeader) && Objects.equals(this.componentManifest, that.componentManifest) && Objects.equals(this.firstKey, that.firstKey) && Objects.equals(this.tableId, that.tableId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.format, this.estimatedKeys, this.sections, this.compressionInfo, this.sstableLevel, this.serializationHeader, this.componentManifest, this.isEntireSSTable, this.firstKey, this.tableId});
    }

    public static final class Builder {
        private Version version;
        private SSTableFormat.Type format;
        private long estimatedKeys;
        private List<SSTableReader.PartitionPositionBounds> sections;
        private CompressionMetadata compressionMetadata;
        private CompressionInfo compressionInfo;
        private int sstableLevel;
        private SerializationHeader.Component serializationHeader;
        private ComponentManifest componentManifest;
        private boolean isEntireSSTable;
        private DecoratedKey firstKey;
        private TableId tableId;

        public Builder withSSTableFormat(SSTableFormat.Type format) {
            this.format = format;
            return this;
        }

        public Builder withSSTableVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder withSSTableLevel(int sstableLevel) {
            this.sstableLevel = sstableLevel;
            return this;
        }

        public Builder withEstimatedKeys(long estimatedKeys) {
            this.estimatedKeys = estimatedKeys;
            return this;
        }

        public Builder withSections(List<SSTableReader.PartitionPositionBounds> sections) {
            this.sections = sections;
            return this;
        }

        public Builder withCompressionMetadata(CompressionMetadata compressionMetadata) {
            this.compressionMetadata = compressionMetadata;
            return this;
        }

        public Builder withCompressionInfo(CompressionInfo compressionInfo) {
            this.compressionInfo = compressionInfo;
            return this;
        }

        public Builder withSerializationHeader(SerializationHeader.Component header) {
            this.serializationHeader = header;
            return this;
        }

        public Builder withTableId(TableId tableId) {
            this.tableId = tableId;
            return this;
        }

        public Builder isEntireSSTable(boolean isEntireSSTable) {
            this.isEntireSSTable = isEntireSSTable;
            return this;
        }

        public Builder withComponentManifest(ComponentManifest componentManifest) {
            this.componentManifest = componentManifest;
            return this;
        }

        public Builder withFirstKey(DecoratedKey firstKey) {
            this.firstKey = firstKey;
            return this;
        }

        public CassandraStreamHeader build() {
            Preconditions.checkNotNull((Object)this.version);
            Preconditions.checkNotNull((Object)((Object)this.format));
            Preconditions.checkNotNull(this.sections);
            Preconditions.checkNotNull((Object)this.serializationHeader);
            Preconditions.checkNotNull((Object)this.tableId);
            if (this.isEntireSSTable) {
                Preconditions.checkNotNull((Object)this.componentManifest);
                Preconditions.checkNotNull((Object)this.firstKey);
            }
            return new CassandraStreamHeader(this);
        }
    }

    public static class CassandraStreamHeaderSerializer
    implements IVersionedSerializer<CassandraStreamHeader> {
        @Override
        public void serialize(CassandraStreamHeader header, DataOutputPlus out, int version) throws IOException {
            out.writeUTF(header.version.toString());
            out.writeUTF(header.format.name);
            out.writeLong(header.estimatedKeys);
            out.writeInt(header.sections.size());
            for (SSTableReader.PartitionPositionBounds section : header.sections) {
                out.writeLong(section.lowerPosition);
                out.writeLong(section.upperPosition);
            }
            header.calculateCompressionInfo();
            CompressionInfo.serializer.serialize(header.compressionInfo, out, version);
            out.writeInt(header.sstableLevel);
            SerializationHeader.serializer.serialize(header.version, header.serializationHeader, out);
            header.tableId.serialize(out);
            out.writeBoolean(header.isEntireSSTable);
            if (header.isEntireSSTable) {
                ComponentManifest.serializer.serialize(header.componentManifest, out, version);
                ByteBufferUtil.writeWithVIntLength(header.firstKey.getKey(), out);
            }
        }

        @Override
        public CassandraStreamHeader deserialize(DataInputPlus in, int version) throws IOException {
            return this.deserialize(in, version, tableId -> {
                ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(tableId);
                if (cfs != null) {
                    return cfs.getPartitioner();
                }
                return null;
            });
        }

        @VisibleForTesting
        public CassandraStreamHeader deserialize(DataInputPlus in, int version, Function<TableId, IPartitioner> partitionerMapper) throws IOException {
            Version sstableVersion = SSTableFormat.Type.current().info.getVersion(in.readUTF());
            SSTableFormat.Type format = SSTableFormat.Type.validate(in.readUTF());
            long estimatedKeys = in.readLong();
            int count = in.readInt();
            ArrayList<SSTableReader.PartitionPositionBounds> sections = new ArrayList<SSTableReader.PartitionPositionBounds>(count);
            for (int k = 0; k < count; ++k) {
                sections.add(new SSTableReader.PartitionPositionBounds(in.readLong(), in.readLong()));
            }
            CompressionInfo compressionInfo = (CompressionInfo)CompressionInfo.serializer.deserialize(in, version);
            int sstableLevel = in.readInt();
            SerializationHeader.Component header = SerializationHeader.serializer.deserialize(sstableVersion, in);
            TableId tableId = TableId.deserialize(in);
            boolean isEntireSSTable = in.readBoolean();
            ComponentManifest manifest = null;
            DecoratedKey firstKey = null;
            if (isEntireSSTable) {
                manifest = (ComponentManifest)ComponentManifest.serializer.deserialize(in, version);
                ByteBuffer keyBuf = ByteBufferUtil.readWithVIntLength(in);
                IPartitioner partitioner = partitionerMapper.apply(tableId);
                if (partitioner == null) {
                    throw new IllegalArgumentException(String.format("Could not determine partitioner for tableId %s", tableId));
                }
                firstKey = partitioner.decorateKey(keyBuf);
            }
            return CassandraStreamHeader.builder().withSSTableFormat(format).withSSTableVersion(sstableVersion).withSSTableLevel(sstableLevel).withEstimatedKeys(estimatedKeys).withSections(sections).withCompressionInfo(compressionInfo).withSerializationHeader(header).withComponentManifest(manifest).isEntireSSTable(isEntireSSTable).withFirstKey(firstKey).withTableId(tableId).build();
        }

        @Override
        public long serializedSize(CassandraStreamHeader header, int version) {
            long size = 0L;
            size += (long)TypeSizes.sizeof(header.version.toString());
            size += (long)TypeSizes.sizeof(header.format.name);
            size += (long)TypeSizes.sizeof(header.estimatedKeys);
            size += (long)TypeSizes.sizeof(header.sections.size());
            for (SSTableReader.PartitionPositionBounds section : header.sections) {
                size += (long)TypeSizes.sizeof(section.lowerPosition);
                size += (long)TypeSizes.sizeof(section.upperPosition);
            }
            header.calculateCompressionInfo();
            size += CompressionInfo.serializer.serializedSize(header.compressionInfo, version);
            size += (long)TypeSizes.sizeof(header.sstableLevel);
            size += (long)SerializationHeader.serializer.serializedSize(header.version, header.serializationHeader);
            size += (long)header.tableId.serializedSize();
            size += (long)TypeSizes.sizeof(header.isEntireSSTable);
            if (header.isEntireSSTable) {
                size += ComponentManifest.serializer.serializedSize(header.componentManifest, version);
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(header.firstKey.getKey());
            }
            return size;
        }
    }
}

