/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.hash.Hasher;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.WithOnlyQueriedData;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.HashingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowIterators {
    private static final Logger logger = LoggerFactory.getLogger(RowIterators.class);

    private RowIterators() {
    }

    public static void digest(RowIterator iterator, Hasher hasher) {
        HashingUtils.updateBytes(hasher, iterator.partitionKey().getKey().duplicate());
        iterator.columns().regulars.digest(hasher);
        iterator.columns().statics.digest(hasher);
        HashingUtils.updateWithBoolean(hasher, iterator.isReverseOrder());
        iterator.staticRow().digest(hasher);
        while (iterator.hasNext()) {
            ((Row)iterator.next()).digest(hasher);
        }
    }

    public static RowIterator withOnlyQueriedData(RowIterator iterator, ColumnFilter filter) {
        if (filter.allFetchedColumnsAreQueried()) {
            return iterator;
        }
        return Transformation.apply(iterator, new WithOnlyQueriedData(filter));
    }

    public static RowIterator loggingIterator(RowIterator iterator, final String id) {
        final TableMetadata metadata = iterator.metadata();
        logger.info("[{}] Logging iterator on {}.{}, partition key={}, reversed={}", new Object[]{id, metadata.keyspace, metadata.name, metadata.partitionKeyType.getString(iterator.partitionKey().getKey()), iterator.isReverseOrder()});
        class Log
        extends Transformation {
            Log() {
            }

            @Override
            public Row applyToStatic(Row row) {
                if (!row.isEmpty()) {
                    logger.info("[{}] {}", (Object)id, (Object)row.toString(metadata));
                }
                return row;
            }

            @Override
            public Row applyToRow(Row row) {
                logger.info("[{}] {}", (Object)id, (Object)row.toString(metadata));
                return row;
            }
        }
        return Transformation.apply(iterator, new Log());
    }
}

