/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.AbstractBufferClusteringPrefix;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.schema.TableMetadata;

public abstract class AbstractRangeTombstoneMarker<B extends ClusteringBoundOrBoundary>
implements RangeTombstoneMarker {
    protected final B bound;

    protected AbstractRangeTombstoneMarker(B bound) {
        this.bound = bound;
    }

    public B clustering() {
        return this.bound;
    }

    @Override
    public Unfiltered.Kind kind() {
        return Unfiltered.Kind.RANGE_TOMBSTONE_MARKER;
    }

    @Override
    public boolean isBoundary() {
        return ((ClusteringBoundOrBoundary)this.bound).isBoundary();
    }

    @Override
    public boolean isOpen(boolean reversed) {
        return ((ClusteringBoundOrBoundary)this.bound).isOpen(reversed);
    }

    @Override
    public boolean isClose(boolean reversed) {
        return ((ClusteringBoundOrBoundary)this.bound).isClose(reversed);
    }

    @Override
    public void validateData(TableMetadata metadata) {
        ClusteringPrefix bound = this.clustering();
        for (int i = 0; i < ((AbstractBufferClusteringPrefix)bound).size(); ++i) {
            ByteBuffer value = ((AbstractBufferClusteringPrefix)bound).get(i);
            if (value == null) continue;
            metadata.comparator.subtype(i).validate(value);
        }
    }

    @Override
    public String toString(TableMetadata metadata, boolean fullDetails) {
        return this.toString(metadata);
    }

    @Override
    public String toString(TableMetadata metadata, boolean includeClusteringKeys, boolean fullDetails) {
        return this.toString(metadata);
    }
}

