/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.cassandra.cache.CacheProvider;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.schema.TableId;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;

public class OHCProvider
implements CacheProvider<RowCacheKey, IRowCacheEntry> {
    @Override
    public ICache<RowCacheKey, IRowCacheEntry> create() {
        OHCacheBuilder builder = OHCacheBuilder.newBuilder();
        builder.capacity(DatabaseDescriptor.getRowCacheSizeInMB() * 1024L * 1024L).keySerializer((CacheSerializer)KeySerializer.instance).valueSerializer((CacheSerializer)ValueSerializer.instance).throwOOME(true);
        return new OHCacheAdapter((OHCache<RowCacheKey, IRowCacheEntry>)builder.build());
    }

    private static class ValueSerializer
    implements CacheSerializer<IRowCacheEntry> {
        private static ValueSerializer instance = new ValueSerializer();

        private ValueSerializer() {
        }

        public void serialize(IRowCacheEntry entry, ByteBuffer buf) {
            assert (entry != null);
            try (DataOutputBufferFixed out = new DataOutputBufferFixed(buf);){
                boolean isSentinel = entry instanceof RowCacheSentinel;
                out.writeBoolean(isSentinel);
                if (isSentinel) {
                    out.writeLong(((RowCacheSentinel)entry).sentinelId);
                } else {
                    CachedPartition.cacheSerializer.serialize((CachedPartition)entry, out);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IRowCacheEntry deserialize(ByteBuffer buf) {
            try {
                DataInputBuffer in = new DataInputBuffer(buf, false);
                boolean isSentinel = in.readBoolean();
                if (isSentinel) {
                    return new RowCacheSentinel(in.readLong());
                }
                return CachedPartition.cacheSerializer.deserialize(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int serializedSize(IRowCacheEntry entry) {
            int size = TypeSizes.sizeof(true);
            size = entry instanceof RowCacheSentinel ? (size += TypeSizes.sizeof(((RowCacheSentinel)entry).sentinelId)) : (int)((long)size + CachedPartition.cacheSerializer.serializedSize((CachedPartition)entry));
            return size;
        }
    }

    private static class KeySerializer
    implements CacheSerializer<RowCacheKey> {
        private static KeySerializer instance = new KeySerializer();

        private KeySerializer() {
        }

        public void serialize(RowCacheKey rowCacheKey, ByteBuffer buf) {
            try (DataOutputBufferFixed dataOutput = new DataOutputBufferFixed(buf);){
                rowCacheKey.tableId.serialize(dataOutput);
                dataOutput.writeUTF(rowCacheKey.indexName != null ? rowCacheKey.indexName : "");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            buf.putInt(rowCacheKey.key.length);
            buf.put(rowCacheKey.key);
        }

        public RowCacheKey deserialize(ByteBuffer buf) {
            TableId tableId = null;
            String indexName = null;
            try (DataInputBuffer dataInput = new DataInputBuffer(buf, false);){
                tableId = TableId.deserialize(dataInput);
                indexName = dataInput.readUTF();
                if (indexName.isEmpty()) {
                    indexName = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] key = new byte[buf.getInt()];
            buf.get(key);
            return new RowCacheKey(tableId, indexName, key);
        }

        public int serializedSize(RowCacheKey rowCacheKey) {
            return rowCacheKey.tableId.serializedSize() + TypeSizes.sizeof(rowCacheKey.indexName != null ? rowCacheKey.indexName : "") + 4 + rowCacheKey.key.length;
        }
    }

    private static class OHCacheAdapter
    implements ICache<RowCacheKey, IRowCacheEntry> {
        private final OHCache<RowCacheKey, IRowCacheEntry> ohCache;

        public OHCacheAdapter(OHCache<RowCacheKey, IRowCacheEntry> ohCache) {
            this.ohCache = ohCache;
        }

        @Override
        public long capacity() {
            return this.ohCache.capacity();
        }

        @Override
        public void setCapacity(long capacity) {
            this.ohCache.setCapacity(capacity);
        }

        @Override
        public void put(RowCacheKey key, IRowCacheEntry value) {
            this.ohCache.put((Object)key, (Object)value);
        }

        @Override
        public boolean putIfAbsent(RowCacheKey key, IRowCacheEntry value) {
            return this.ohCache.putIfAbsent((Object)key, (Object)value);
        }

        @Override
        public boolean replace(RowCacheKey key, IRowCacheEntry old, IRowCacheEntry value) {
            return this.ohCache.addOrReplace((Object)key, (Object)old, (Object)value);
        }

        @Override
        public IRowCacheEntry get(RowCacheKey key) {
            return (IRowCacheEntry)this.ohCache.get((Object)key);
        }

        @Override
        public void remove(RowCacheKey key) {
            this.ohCache.remove((Object)key);
        }

        @Override
        public int size() {
            return (int)this.ohCache.size();
        }

        @Override
        public long weightedSize() {
            return this.ohCache.memUsed();
        }

        @Override
        public void clear() {
            this.ohCache.clear();
        }

        @Override
        public Iterator<RowCacheKey> hotKeyIterator(int n) {
            return this.ohCache.hotKeyIterator(n);
        }

        @Override
        public Iterator<RowCacheKey> keyIterator() {
            return this.ohCache.keyIterator();
        }

        @Override
        public boolean containsKey(RowCacheKey key) {
            return this.ohCache.containsKey((Object)key);
        }
    }
}

