/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.binlog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.utils.binlog.BinLogArchiver;
import org.apache.cassandra.utils.concurrent.WeightedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinLog
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(BinLog.class);
    private ChronicleQueue queue;
    private ExcerptAppender appender;
    @VisibleForTesting
    Thread binLogThread = new NamedThreadFactory("Binary Log thread").newThread(this);
    final WeightedQueue<ReleaseableWriteMarshallable> sampleQueue;
    private final BinLogArchiver archiver;
    private static final ReleaseableWriteMarshallable NO_OP = new ReleaseableWriteMarshallable(){

        public void writeMarshallable(WireOut wire) {
        }

        @Override
        public void release() {
        }
    };
    private volatile boolean shouldContinue = true;

    public BinLog(Path path, RollCycle rollCycle, int maxQueueWeight, BinLogArchiver archiver) {
        Preconditions.checkNotNull((Object)path, (Object)"path was null");
        Preconditions.checkNotNull((Object)rollCycle, (Object)"rollCycle was null");
        Preconditions.checkArgument((maxQueueWeight > 0 ? 1 : 0) != 0, (Object)"maxQueueWeight must be > 0");
        SingleChronicleQueueBuilder builder = ChronicleQueueBuilder.single((File)path.toFile());
        builder.rollCycle(rollCycle);
        this.sampleQueue = new WeightedQueue(maxQueueWeight);
        this.archiver = archiver;
        builder.storeFileListener((StoreFileListener)this.archiver);
        this.queue = builder.build();
        this.appender = this.queue.acquireAppender();
    }

    public void start() {
        if (!this.shouldContinue) {
            throw new IllegalStateException("Can't reuse stopped BinLog");
        }
        this.binLogThread.start();
    }

    public synchronized void stop() throws InterruptedException {
        if (!this.shouldContinue) {
            return;
        }
        this.shouldContinue = false;
        this.sampleQueue.put(NO_OP);
        this.binLogThread.join();
        this.appender = null;
        this.queue = null;
        this.archiver.stop();
    }

    public boolean offer(ReleaseableWriteMarshallable record) {
        if (!this.shouldContinue) {
            return false;
        }
        return this.sampleQueue.offer(record);
    }

    public void put(ReleaseableWriteMarshallable record) throws InterruptedException {
        if (!this.shouldContinue) {
            return;
        }
        while (this.shouldContinue) {
            if (!this.sampleQueue.offer(record, 1L, TimeUnit.SECONDS)) continue;
            return;
        }
    }

    private void processTasks(List<ReleaseableWriteMarshallable> tasks) {
        for (int ii = 0; ii < tasks.size(); ++ii) {
            WriteMarshallable t = tasks.get(ii);
            if (t == NO_OP) continue;
            this.appender.writeDocument(t);
        }
    }

    @Override
    public void run() {
        ArrayList<ReleaseableWriteMarshallable> tasks = new ArrayList<ReleaseableWriteMarshallable>(16);
        while (this.shouldContinue) {
            try {
                tasks.clear();
                ReleaseableWriteMarshallable task = this.sampleQueue.take();
                tasks.add(task);
                this.sampleQueue.drainTo((Collection<ReleaseableWriteMarshallable>)tasks, 15);
                this.processTasks(tasks);
            }
            catch (Throwable t) {
                logger.error("Unexpected exception in binary log thread", t);
            }
            finally {
                for (int ii = 0; ii < tasks.size(); ++ii) {
                    ((ReleaseableWriteMarshallable)tasks.get(ii)).release();
                }
            }
        }
        this.finalize();
    }

    public void finalize() {
        ReleaseableWriteMarshallable toRelease;
        while ((toRelease = this.sampleQueue.poll()) != null) {
            toRelease.release();
        }
    }

    public static abstract class ReleaseableWriteMarshallable
    implements WriteMarshallable {
        public abstract void release();
    }
}

