/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.audit.AuditLogManager;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.AuthChallenge;
import org.apache.cassandra.transport.messages.AuthSuccess;
import org.apache.cassandra.transport.messages.ErrorMessage;

public class AuthResponse
extends Message.Request {
    public static final Message.Codec<AuthResponse> codec = new Message.Codec<AuthResponse>(){

        @Override
        public AuthResponse decode(ByteBuf body, ProtocolVersion version) {
            if (version == ProtocolVersion.V1) {
                throw new ProtocolException("SASL Authentication is not supported in version 1 of the protocol");
            }
            ByteBuffer b = CBUtil.readValue(body);
            byte[] token = new byte[b.remaining()];
            b.get(token);
            return new AuthResponse(token);
        }

        @Override
        public void encode(AuthResponse response, ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeValue(response.token, dest);
        }

        @Override
        public int encodedSize(AuthResponse response, ProtocolVersion version) {
            return CBUtil.sizeOfValue(response.token);
        }
    };
    private final byte[] token;

    public AuthResponse(byte[] token) {
        super(Message.Type.AUTH_RESPONSE);
        assert (token != null);
        this.token = token;
    }

    @Override
    protected Message.Response execute(QueryState queryState, long queryStartNanoTime, boolean traceRequest) {
        AuditLogManager auditLogManager = AuditLogManager.getInstance();
        try {
            IAuthenticator.SaslNegotiator negotiator = ((ServerConnection)this.connection).getSaslNegotiator(queryState);
            byte[] challenge = negotiator.evaluateResponse(this.token);
            if (negotiator.isComplete()) {
                AuthenticatedUser user = negotiator.getAuthenticatedUser();
                queryState.getClientState().login(user);
                ClientMetrics.instance.markAuthSuccess();
                if (auditLogManager.isAuditingEnabled()) {
                    this.logSuccess(queryState);
                }
                return new AuthSuccess(challenge);
            }
            return new AuthChallenge(challenge);
        }
        catch (AuthenticationException e) {
            ClientMetrics.instance.markAuthFailure();
            if (auditLogManager.isAuditingEnabled()) {
                this.logException(queryState, e);
            }
            return ErrorMessage.fromException(e);
        }
    }

    private void logSuccess(QueryState state) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation("LOGIN SUCCESSFUL").setType(AuditLogEntryType.LOGIN_SUCCESS).build();
        AuditLogManager.getInstance().log(entry);
    }

    private void logException(QueryState state, AuthenticationException e) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation("LOGIN FAILURE").setType(AuditLogEntryType.LOGIN_ERROR).build();
        AuditLogManager.getInstance().log(entry, e);
    }
}

