/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.FBUtilities;

public class QueryState {
    private final ClientState clientState;
    private long timestamp = Long.MIN_VALUE;
    private int nowInSeconds = Integer.MIN_VALUE;

    public QueryState(ClientState clientState) {
        this.clientState = clientState;
    }

    public QueryState(ClientState clientState, long timestamp, int nowInSeconds) {
        this(clientState);
        this.timestamp = timestamp;
        this.nowInSeconds = nowInSeconds;
    }

    public static QueryState forInternalCalls() {
        return new QueryState(ClientState.forInternalCalls());
    }

    public long getTimestamp() {
        if (this.timestamp == Long.MIN_VALUE) {
            this.timestamp = this.clientState.getTimestamp();
        }
        return this.timestamp;
    }

    public int getNowInSeconds() {
        if (this.nowInSeconds == Integer.MIN_VALUE) {
            this.nowInSeconds = FBUtilities.nowInSeconds();
        }
        return this.nowInSeconds;
    }

    public long generatedTimestamp() {
        return this.timestamp;
    }

    public int generatedNowInSeconds() {
        return this.nowInSeconds;
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public InetAddress getClientAddress() {
        return this.clientState.getClientAddress();
    }
}

