/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;

public class ValidationRequest
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new ValidationRequestSerializer();
    public final int nowInSec;

    public ValidationRequest(RepairJobDesc desc, int nowInSec) {
        super(RepairMessage.Type.VALIDATION_REQUEST, desc);
        this.nowInSec = nowInSec;
    }

    public String toString() {
        return "ValidationRequest{nowInSec=" + this.nowInSec + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationRequest that = (ValidationRequest)o;
        return this.nowInSec == that.nowInSec;
    }

    public int hashCode() {
        return this.nowInSec;
    }

    public static class ValidationRequestSerializer
    implements RepairMessage.MessageSerializer<ValidationRequest> {
        @Override
        public void serialize(ValidationRequest message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            out.writeInt(message.nowInSec);
        }

        @Override
        public ValidationRequest deserialize(DataInputPlus dis, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(dis, version);
            return new ValidationRequest(desc, dis.readInt());
        }

        @Override
        public long serializedSize(ValidationRequest message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            return size += (long)TypeSizes.sizeof(message.nowInSec);
        }
    }
}

