/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.MerkleTrees;

public class ValidationComplete
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new ValidationCompleteSerializer();
    public final MerkleTrees trees;

    public ValidationComplete(RepairJobDesc desc) {
        super(RepairMessage.Type.VALIDATION_COMPLETE, desc);
        this.trees = null;
    }

    public ValidationComplete(RepairJobDesc desc, MerkleTrees trees) {
        super(RepairMessage.Type.VALIDATION_COMPLETE, desc);
        assert (trees != null);
        this.trees = trees;
    }

    public boolean success() {
        return this.trees != null;
    }

    public ValidationComplete tryMoveOffHeap() throws IOException {
        return this.trees == null ? this : new ValidationComplete(this.desc, this.trees.tryMoveOffHeap());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ValidationComplete)) {
            return false;
        }
        ValidationComplete other = (ValidationComplete)o;
        return this.messageType == other.messageType && this.desc.equals(other.desc);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageType, this.desc});
    }

    private static class ValidationCompleteSerializer
    implements RepairMessage.MessageSerializer<ValidationComplete> {
        private ValidationCompleteSerializer() {
        }

        @Override
        public void serialize(ValidationComplete message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            out.writeBoolean(message.success());
            if (message.trees != null) {
                MerkleTrees.serializer.serialize(message.trees, out, version);
            }
        }

        @Override
        public ValidationComplete deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(in, version);
            boolean success = in.readBoolean();
            if (success) {
                MerkleTrees trees = MerkleTrees.serializer.deserialize(in, version);
                return new ValidationComplete(desc, trees);
            }
            return new ValidationComplete(desc);
        }

        @Override
        public long serializedSize(ValidationComplete message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += (long)TypeSizes.sizeof(message.success());
            if (message.trees != null) {
                size += MerkleTrees.serializer.serializedSize(message.trees, version);
            }
            return size;
        }
    }
}

