/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncNodePair;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.streaming.SessionSummary;

public class SyncComplete
extends RepairMessage {
    public static final RepairMessage.MessageSerializer serializer = new SyncCompleteSerializer();
    public final SyncNodePair nodes;
    public final boolean success;
    public final List<SessionSummary> summaries;

    public SyncComplete(RepairJobDesc desc, SyncNodePair nodes, boolean success, List<SessionSummary> summaries) {
        super(RepairMessage.Type.SYNC_COMPLETE, desc);
        this.nodes = nodes;
        this.success = success;
        this.summaries = summaries;
    }

    public SyncComplete(RepairJobDesc desc, InetAddressAndPort endpoint1, InetAddressAndPort endpoint2, boolean success, List<SessionSummary> summaries) {
        super(RepairMessage.Type.SYNC_COMPLETE, desc);
        this.summaries = summaries;
        this.nodes = new SyncNodePair(endpoint1, endpoint2);
        this.success = success;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyncComplete)) {
            return false;
        }
        SyncComplete other = (SyncComplete)o;
        return this.messageType == other.messageType && this.desc.equals(other.desc) && this.success == other.success && this.nodes.equals(other.nodes) && this.summaries.equals(other.summaries);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageType, this.desc, this.success, this.nodes, this.summaries});
    }

    private static class SyncCompleteSerializer
    implements RepairMessage.MessageSerializer<SyncComplete> {
        private SyncCompleteSerializer() {
        }

        @Override
        public void serialize(SyncComplete message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            SyncNodePair.serializer.serialize(message.nodes, out, version);
            out.writeBoolean(message.success);
            out.writeInt(message.summaries.size());
            for (SessionSummary summary : message.summaries) {
                SessionSummary.serializer.serialize(summary, out, version);
            }
        }

        @Override
        public SyncComplete deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(in, version);
            SyncNodePair nodes = (SyncNodePair)SyncNodePair.serializer.deserialize(in, version);
            boolean success = in.readBoolean();
            int numSummaries = in.readInt();
            ArrayList<SessionSummary> summaries = new ArrayList<SessionSummary>(numSummaries);
            for (int i = 0; i < numSummaries; ++i) {
                summaries.add((SessionSummary)SessionSummary.serializer.deserialize(in, version));
            }
            return new SyncComplete(desc, nodes, success, summaries);
        }

        @Override
        public long serializedSize(SyncComplete message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += SyncNodePair.serializer.serializedSize(message.nodes, version);
            size += (long)TypeSizes.sizeof(message.success);
            size += (long)TypeSizes.sizeof(message.summaries.size());
            for (SessionSummary summary : message.summaries) {
                size += SessionSummary.serializer.serializedSize(summary, version);
            }
            return size;
        }
    }
}

