/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class StatusRequest
extends RepairMessage {
    public final UUID sessionID;
    public static RepairMessage.MessageSerializer serializer = new RepairMessage.MessageSerializer<StatusRequest>(){

        @Override
        public void serialize(StatusRequest msg, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(msg.sessionID, out, version);
        }

        @Override
        public StatusRequest deserialize(DataInputPlus in, int version) throws IOException {
            return new StatusRequest(UUIDSerializer.serializer.deserialize(in, version));
        }

        @Override
        public long serializedSize(StatusRequest msg, int version) {
            return UUIDSerializer.serializer.serializedSize(msg.sessionID, version);
        }
    };

    public StatusRequest(UUID sessionID) {
        super(RepairMessage.Type.STATUS_REQUEST, null);
        this.sessionID = sessionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusRequest request = (StatusRequest)o;
        return this.sessionID.equals(request.sessionID);
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }

    public String toString() {
        return "StatusRequest{sessionID=" + this.sessionID + '}';
    }
}

