/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.AsymmetricSyncRequest;
import org.apache.cassandra.repair.messages.CleanupMessage;
import org.apache.cassandra.repair.messages.FailSession;
import org.apache.cassandra.repair.messages.FinalizeCommit;
import org.apache.cassandra.repair.messages.FinalizePromise;
import org.apache.cassandra.repair.messages.FinalizePropose;
import org.apache.cassandra.repair.messages.PrepareConsistentRequest;
import org.apache.cassandra.repair.messages.PrepareConsistentResponse;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.SnapshotMessage;
import org.apache.cassandra.repair.messages.StatusRequest;
import org.apache.cassandra.repair.messages.StatusResponse;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.repair.messages.ValidationRequest;

public abstract class RepairMessage {
    public static final IVersionedSerializer<RepairMessage> serializer = new RepairMessageSerializer();
    public static final int MIN_MESSAGING_VERSION = 12;
    private static final String MIXED_MODE_ERROR = "Some nodes involved in repair are on an incompatible major version. Repair is not supported in mixed major version clusters.";
    public final Type messageType;
    public final RepairJobDesc desc;

    protected RepairMessage(Type messageType, RepairJobDesc desc) {
        this.messageType = messageType;
        this.desc = desc;
    }

    public static class RepairMessageSerializer
    implements MessageSerializer<RepairMessage> {
        @Override
        public void serialize(RepairMessage message, DataOutputPlus out, int version) throws IOException {
            Preconditions.checkArgument((version >= 12 ? 1 : 0) != 0, (Object)RepairMessage.MIXED_MODE_ERROR);
            out.write(message.messageType.type);
            message.messageType.serializer.serialize(message, out, version);
        }

        @Override
        public RepairMessage deserialize(DataInputPlus in, int version) throws IOException {
            Preconditions.checkArgument((version >= 12 ? 1 : 0) != 0, (Object)RepairMessage.MIXED_MODE_ERROR);
            Type messageType = Type.fromByte(in.readByte());
            return (RepairMessage)messageType.serializer.deserialize(in, version);
        }

        @Override
        public long serializedSize(RepairMessage message, int version) {
            Preconditions.checkArgument((version >= 12 ? 1 : 0) != 0, (Object)RepairMessage.MIXED_MODE_ERROR);
            long size = 1L;
            return size += message.messageType.serializer.serializedSize(message, version);
        }
    }

    public static enum Type {
        VALIDATION_REQUEST(0, ValidationRequest.serializer),
        VALIDATION_COMPLETE(1, ValidationComplete.serializer),
        SYNC_REQUEST(2, SyncRequest.serializer),
        SYNC_COMPLETE(3, SyncComplete.serializer),
        PREPARE_MESSAGE(5, PrepareMessage.serializer),
        SNAPSHOT(6, SnapshotMessage.serializer),
        CLEANUP(7, CleanupMessage.serializer),
        CONSISTENT_REQUEST(8, PrepareConsistentRequest.serializer),
        CONSISTENT_RESPONSE(9, PrepareConsistentResponse.serializer),
        FINALIZE_PROPOSE(10, FinalizePropose.serializer),
        FINALIZE_PROMISE(11, FinalizePromise.serializer),
        FINALIZE_COMMIT(12, FinalizeCommit.serializer),
        FAILED_SESSION(13, FailSession.serializer),
        STATUS_REQUEST(14, StatusRequest.serializer),
        STATUS_RESPONSE(15, StatusResponse.serializer),
        ASYMMETRIC_SYNC_REQUEST(16, AsymmetricSyncRequest.serializer);

        private final byte type;
        private final MessageSerializer<RepairMessage> serializer;

        private Type(int type, MessageSerializer<RepairMessage> serializer) {
            this.type = (byte)type;
            this.serializer = serializer;
        }

        public static Type fromByte(byte b) {
            for (Type t : Type.values()) {
                if (t.type != b) continue;
                return t;
            }
            throw new IllegalArgumentException("Unknown RepairMessage.Type: " + b);
        }
    }

    public static interface MessageSerializer<T extends RepairMessage>
    extends IVersionedSerializer<T> {
    }
}

