/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class FinalizeCommit
extends RepairMessage {
    public final UUID sessionID;
    public static RepairMessage.MessageSerializer serializer = new RepairMessage.MessageSerializer<FinalizeCommit>(){

        @Override
        public void serialize(FinalizeCommit msg, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(msg.sessionID, out, version);
        }

        @Override
        public FinalizeCommit deserialize(DataInputPlus in, int version) throws IOException {
            return new FinalizeCommit(UUIDSerializer.serializer.deserialize(in, version));
        }

        @Override
        public long serializedSize(FinalizeCommit msg, int version) {
            return UUIDSerializer.serializer.serializedSize(msg.sessionID, version);
        }
    };

    public FinalizeCommit(UUID sessionID) {
        super(RepairMessage.Type.FINALIZE_COMMIT, null);
        assert (sessionID != null);
        this.sessionID = sessionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizeCommit that = (FinalizeCommit)o;
        return this.sessionID.equals(that.sessionID);
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }

    public String toString() {
        return "FinalizeCommit{sessionID=" + this.sessionID + '}';
    }
}

