/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.streaming.PreviewKind;

public class AsymmetricSyncRequest
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new SyncRequestSerializer();
    public final InetAddressAndPort initiator;
    public final InetAddressAndPort fetchingNode;
    public final InetAddressAndPort fetchFrom;
    public final Collection<Range<Token>> ranges;
    public final PreviewKind previewKind;

    public AsymmetricSyncRequest(RepairJobDesc desc, InetAddressAndPort initiator, InetAddressAndPort fetchingNode, InetAddressAndPort fetchFrom, Collection<Range<Token>> ranges, PreviewKind previewKind) {
        super(RepairMessage.Type.ASYMMETRIC_SYNC_REQUEST, desc);
        this.initiator = initiator;
        this.fetchingNode = fetchingNode;
        this.fetchFrom = fetchFrom;
        this.ranges = ranges;
        this.previewKind = previewKind;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AsymmetricSyncRequest)) {
            return false;
        }
        AsymmetricSyncRequest req = (AsymmetricSyncRequest)o;
        return this.messageType == req.messageType && this.desc.equals(req.desc) && this.initiator.equals(req.initiator) && this.fetchingNode.equals(req.fetchingNode) && this.fetchFrom.equals(req.fetchFrom) && this.ranges.equals(req.ranges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageType, this.desc, this.initiator, this.fetchingNode, this.fetchFrom, this.ranges});
    }

    public String toString() {
        return "AsymmetricSyncRequest{initiator=" + this.initiator + ", fetchingNode=" + this.fetchingNode + ", fetchFrom=" + this.fetchFrom + ", ranges=" + this.ranges + ", previewKind=" + (Object)((Object)this.previewKind) + ", desc=" + this.desc + '}';
    }

    public static class SyncRequestSerializer
    implements RepairMessage.MessageSerializer<AsymmetricSyncRequest> {
        @Override
        public void serialize(AsymmetricSyncRequest message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(message.initiator, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(message.fetchingNode, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(message.fetchFrom, out, version);
            out.writeInt(message.ranges.size());
            for (Range<Token> range : message.ranges) {
                IPartitioner.validate(range);
                AbstractBounds.tokenSerializer.serialize(range, out, version);
            }
            out.writeInt(message.previewKind.getSerializationVal());
        }

        @Override
        public AsymmetricSyncRequest deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(in, version);
            InetAddressAndPort owner = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            InetAddressAndPort src = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            InetAddressAndPort dst = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            int rangesCount = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(rangesCount);
            for (int i = 0; i < rangesCount; ++i) {
                ranges.add((Range)AbstractBounds.tokenSerializer.deserialize(in, IPartitioner.global(), version));
            }
            PreviewKind previewKind = PreviewKind.deserialize(in.readInt());
            return new AsymmetricSyncRequest(desc, owner, src, dst, ranges, previewKind);
        }

        @Override
        public long serializedSize(AsymmetricSyncRequest message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(message.initiator, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(message.fetchingNode, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(message.fetchFrom, version);
            size += (long)TypeSizes.sizeof(message.ranges.size());
            for (Range<Token> range : message.ranges) {
                size += AbstractBounds.tokenSerializer.serializedSize(range, version);
            }
            return size += (long)TypeSizes.sizeof(message.previewKind.getSerializationVal());
        }
    }
}

