/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import java.util.concurrent.RunnableFuture;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.SnapshotMessage;

public class SnapshotTask
extends AbstractFuture<InetAddressAndPort>
implements RunnableFuture<InetAddressAndPort> {
    private final RepairJobDesc desc;
    private final InetAddressAndPort endpoint;

    SnapshotTask(RepairJobDesc desc, InetAddressAndPort endpoint) {
        this.desc = desc;
        this.endpoint = endpoint;
    }

    @Override
    public void run() {
        MessagingService.instance().sendWithCallback(Message.out(Verb.REPAIR_REQ, new SnapshotMessage(this.desc)), this.endpoint, new SnapshotCallback(this));
    }

    static class SnapshotCallback
    implements RequestCallback {
        final SnapshotTask task;

        SnapshotCallback(SnapshotTask task) {
            this.task = task;
        }

        public void onResponse(Message msg) {
            this.task.set(this.task.endpoint);
        }

        @Override
        public boolean invokeOnFailure() {
            return true;
        }

        @Override
        public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
            this.task.setException(new RuntimeException("Could not create snapshot at " + from));
        }
    }
}

