/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ChunkReader;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.utils.memory.BufferPool;

public abstract class BufferManagingRebufferer
implements Rebufferer,
Rebufferer.BufferHolder {
    protected final ChunkReader source;
    protected final ByteBuffer buffer;
    protected long offset = 0L;

    abstract long alignedPosition(long var1);

    protected BufferManagingRebufferer(ChunkReader wrapped) {
        this.source = wrapped;
        this.buffer = BufferPool.get(wrapped.chunkSize(), wrapped.preferredBufferType()).order(ByteOrder.BIG_ENDIAN);
        this.buffer.limit(0);
    }

    @Override
    public void closeReader() {
        BufferPool.put(this.buffer);
        this.offset = -1L;
    }

    @Override
    public void close() {
        assert (this.offset == -1L);
        this.source.close();
    }

    @Override
    public ChannelProxy channel() {
        return this.source.channel();
    }

    @Override
    public long fileLength() {
        return this.source.fileLength();
    }

    @Override
    public Rebufferer.BufferHolder rebuffer(long position) {
        this.offset = this.alignedPosition(position);
        this.source.readChunk(this.offset, this.buffer);
        return this;
    }

    @Override
    public double getCrcCheckChance() {
        return this.source.getCrcCheckChance();
    }

    public String toString() {
        return "BufferManagingRebufferer." + this.getClass().getSimpleName() + ":" + this.source;
    }

    @Override
    public ByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public void release() {
    }

    public static class Aligned
    extends BufferManagingRebufferer {
        public Aligned(ChunkReader wrapped) {
            super(wrapped);
            assert (Integer.bitCount(wrapped.chunkSize()) == 1);
        }

        @Override
        long alignedPosition(long position) {
            return position & (long)(-this.buffer.capacity());
        }
    }

    public static class Unaligned
    extends BufferManagingRebufferer {
        public Unaligned(ChunkReader wrapped) {
            super(wrapped);
        }

        @Override
        long alignedPosition(long position) {
            return position;
        }
    }
}

