/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.HintMessage;
import org.apache.cassandra.hints.HintsService;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HintVerbHandler
implements IVerbHandler<HintMessage> {
    public static final HintVerbHandler instance = new HintVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(HintVerbHandler.class);

    @Override
    public void doVerb(Message<HintMessage> message) {
        UUID hostId = ((HintMessage)message.payload).hostId;
        Hint hint = ((HintMessage)message.payload).hint;
        InetAddressAndPort address = StorageService.instance.getEndpointForHostId(hostId);
        if (hint == null) {
            logger.trace("Failed to decode and apply a hint for {}: {} - table with id {} is unknown", new Object[]{address, hostId, ((HintMessage)message.payload).unknownTableID});
            HintVerbHandler.respond(message);
            return;
        }
        try {
            hint.mutation.getPartitionUpdates().forEach(PartitionUpdate::validate);
        }
        catch (MarshalException e2) {
            logger.warn("Failed to validate a hint for {}: {} - skipped", (Object)address, (Object)hostId);
            HintVerbHandler.respond(message);
            return;
        }
        if (!hostId.equals(StorageService.instance.getLocalHostUUID())) {
            HintsService.instance.write(hostId, hint);
            HintVerbHandler.respond(message);
        } else if (!StorageProxy.instance.appliesLocally(hint.mutation)) {
            HintsService.instance.writeForAllReplicas(hint);
            HintVerbHandler.respond(message);
        } else {
            ((CompletableFuture)hint.applyFuture().thenAccept(o -> HintVerbHandler.respond(message))).exceptionally(e -> {
                logger.debug("Failed to apply hint", e);
                return null;
            });
        }
    }

    private static void respond(Message<HintMessage> respondTo) {
        MessagingService.instance().send(respondTo.emptyResponse(), respondTo.from());
    }
}

