/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.collect.ImmutableCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.TokenMetadata;

final class BootstrapEvent
extends DiagnosticEvent {
    private final BootstrapEventType type;
    @Nullable
    private final TokenMetadata tokenMetadata;
    private final InetAddressAndPort address;
    @Nullable
    private final String allocationKeyspace;
    private final Integer numTokens;
    private final Collection<Token> tokens;

    BootstrapEvent(BootstrapEventType type, InetAddressAndPort address, @Nullable TokenMetadata tokenMetadata, @Nullable String allocationKeyspace, int numTokens, ImmutableCollection<Token> tokens) {
        this.type = type;
        this.address = address;
        this.tokenMetadata = tokenMetadata;
        this.allocationKeyspace = allocationKeyspace;
        this.numTokens = numTokens;
        this.tokens = tokens;
    }

    public BootstrapEventType getType() {
        return this.type;
    }

    @Override
    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("tokenMetadata", (Serializable)((Object)String.valueOf(this.tokenMetadata)));
        ret.put("allocationKeyspace", (Serializable)((Object)this.allocationKeyspace));
        ret.put("numTokens", this.numTokens);
        ret.put("tokens", (Serializable)((Object)String.valueOf(this.tokens)));
        return ret;
    }

    static enum BootstrapEventType {
        BOOTSTRAP_USING_SPECIFIED_TOKENS,
        BOOTSTRAP_USING_RANDOM_TOKENS,
        TOKENS_ALLOCATED;

    }
}

