/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;

final class SSTableTasksTable
extends AbstractVirtualTable {
    private static final String KEYSPACE_NAME = "keyspace_name";
    private static final String TABLE_NAME = "table_name";
    private static final String TASK_ID = "task_id";
    private static final String KIND = "kind";
    private static final String PROGRESS = "progress";
    private static final String TOTAL = "total";
    private static final String UNIT = "unit";

    SSTableTasksTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "sstable_tasks").comment("current sstable tasks").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(KEYSPACE_NAME, (AbstractType)UTF8Type.instance).addClusteringColumn(TABLE_NAME, (AbstractType)UTF8Type.instance).addClusteringColumn(TASK_ID, (AbstractType)UUIDType.instance).addRegularColumn(KIND, (AbstractType)UTF8Type.instance).addRegularColumn(PROGRESS, (AbstractType)LongType.instance).addRegularColumn(TOTAL, (AbstractType)LongType.instance).addRegularColumn(UNIT, (AbstractType)UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        for (CompactionInfo task : CompactionManager.instance.getSSTableTasks()) {
            result.row(task.getKeyspace().orElse("*"), task.getTable().orElse("*"), task.getTaskId()).column(KIND, task.getTaskType().toString().toLowerCase()).column(PROGRESS, task.getCompleted()).column(TOTAL, task.getTotal()).column(UNIT, task.getUnit().toString().toLowerCase());
        }
        return result;
    }
}

