/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.DroppedColumn;
import org.apache.cassandra.schema.TableMetadata;

public class SerializationHelper {
    private final Flag flag;
    public final int version;
    private final ColumnFilter columnsToFetch;
    private ColumnFilter.Tester tester;
    private final boolean hasDroppedColumns;
    private final Map<ByteBuffer, DroppedColumn> droppedColumns;
    private DroppedColumn currentDroppedComplex;

    public SerializationHelper(TableMetadata metadata, int version, Flag flag, ColumnFilter columnsToFetch) {
        this.flag = flag;
        this.version = version;
        this.columnsToFetch = columnsToFetch;
        this.droppedColumns = metadata.droppedColumns;
        this.hasDroppedColumns = this.droppedColumns.size() > 0;
    }

    public SerializationHelper(TableMetadata metadata, int version, Flag flag) {
        this(metadata, version, flag, null);
    }

    public boolean includes(ColumnMetadata column) {
        return this.columnsToFetch == null || this.columnsToFetch.fetches(column);
    }

    public boolean includes(Cell cell, LivenessInfo rowLiveness) {
        if (this.columnsToFetch == null) {
            return true;
        }
        ColumnMetadata column = cell.column();
        if (column.isComplex()) {
            if (!this.includes(cell.path())) {
                return false;
            }
            return !this.canSkipValue(cell.path()) || cell.timestamp() >= rowLiveness.timestamp();
        }
        return this.columnsToFetch.fetchedColumnIsQueried(column) || cell.timestamp() >= rowLiveness.timestamp();
    }

    public boolean includes(CellPath path) {
        return path == null || this.tester == null || this.tester.fetches(path);
    }

    public boolean canSkipValue(ColumnMetadata column) {
        return this.columnsToFetch != null && !this.columnsToFetch.fetchedColumnIsQueried(column);
    }

    public boolean canSkipValue(CellPath path) {
        return path != null && this.tester != null && !this.tester.fetchedCellIsQueried(path);
    }

    public void startOfComplexColumn(ColumnMetadata column) {
        this.tester = this.columnsToFetch == null ? null : this.columnsToFetch.newTester(column);
        this.currentDroppedComplex = this.droppedColumns.get(column.name.bytes);
    }

    public void endOfComplexColumn() {
        this.tester = null;
    }

    public boolean isDropped(Cell cell, boolean isComplex) {
        if (!this.hasDroppedColumns) {
            return false;
        }
        DroppedColumn dropped = isComplex ? this.currentDroppedComplex : this.droppedColumns.get(cell.column().name.bytes);
        return dropped != null && cell.timestamp() <= dropped.droppedTime;
    }

    public boolean isDroppedComplexDeletion(DeletionTime complexDeletion) {
        return this.currentDroppedComplex != null && complexDeletion.markedForDeleteAt() <= this.currentDroppedComplex.droppedTime;
    }

    public ByteBuffer maybeClearCounterValue(ByteBuffer value) {
        return this.flag == Flag.FROM_REMOTE || this.flag == Flag.LOCAL && CounterContext.instance().shouldClearLocal(value) ? CounterContext.instance().clearAllLocal(value) : value;
    }

    public static enum Flag {
        LOCAL,
        FROM_REMOTE,
        PRESERVE_SIZE;

    }
}

