/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.Iterables;
import com.google.common.hash.Hasher;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.HashingUtils;

public abstract class AbstractRow
implements Row {
    @Override
    public Unfiltered.Kind kind() {
        return Unfiltered.Kind.ROW;
    }

    @Override
    public boolean hasLiveData(int nowInSec, boolean enforceStrictLiveness) {
        if (this.primaryKeyLivenessInfo().isLive(nowInSec)) {
            return true;
        }
        if (enforceStrictLiveness) {
            return false;
        }
        return Iterables.any(this.cells(), cell -> cell.isLive(nowInSec));
    }

    @Override
    public boolean isStatic() {
        return this.clustering() == Clustering.STATIC_CLUSTERING;
    }

    @Override
    public void digest(Hasher hasher) {
        HashingUtils.updateWithByte(hasher, this.kind().ordinal());
        this.clustering().digest(hasher);
        this.deletion().digest(hasher);
        this.primaryKeyLivenessInfo().digest(hasher);
        for (ColumnData cd : this) {
            cd.digest(hasher);
        }
    }

    @Override
    public void validateData(TableMetadata metadata) {
        Clustering clustering = this.clustering();
        for (int i = 0; i < clustering.size(); ++i) {
            ByteBuffer value = clustering.get(i);
            if (value == null) continue;
            metadata.comparator.subtype(i).validate(value);
        }
        this.primaryKeyLivenessInfo().validate();
        if (this.deletion().time().localDeletionTime() < 0) {
            throw new MarshalException("A local deletion time should not be negative");
        }
        for (ColumnData cd : this) {
            cd.validate();
        }
    }

    @Override
    public boolean hasInvalidDeletions() {
        if (this.primaryKeyLivenessInfo().isExpiring() && (this.primaryKeyLivenessInfo().ttl() < 0 || this.primaryKeyLivenessInfo().localExpirationTime() < 0)) {
            return true;
        }
        if (!this.deletion().time().validate()) {
            return true;
        }
        for (ColumnData cd : this) {
            if (!cd.hasInvalidDeletions()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.columnData().toString();
    }

    @Override
    public String toString(TableMetadata metadata) {
        return this.toString(metadata, false);
    }

    @Override
    public String toString(TableMetadata metadata, boolean fullDetails) {
        return this.toString(metadata, true, fullDetails);
    }

    @Override
    public String toString(TableMetadata metadata, boolean includeClusterKeys, boolean fullDetails) {
        StringBuilder sb = new StringBuilder();
        sb.append("Row");
        if (fullDetails) {
            sb.append("[info=").append(this.primaryKeyLivenessInfo());
            if (!this.deletion().isLive()) {
                sb.append(" del=").append(this.deletion());
            }
            sb.append(" ]");
        }
        sb.append(": ");
        if (includeClusterKeys) {
            sb.append(this.clustering().toString(metadata));
        } else {
            sb.append(this.clustering().toCQLString(metadata));
        }
        sb.append(" | ");
        boolean isFirst = true;
        for (ColumnData cd : this) {
            ComplexColumnData complexData;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            if (fullDetails) {
                if (cd.column().isSimple()) {
                    sb.append(cd);
                    continue;
                }
                complexData = (ComplexColumnData)cd;
                if (!complexData.complexDeletion().isLive()) {
                    sb.append("del(").append(cd.column().name).append(")=").append(complexData.complexDeletion());
                }
                for (Cell cell2 : complexData) {
                    sb.append(", ").append(cell2);
                }
                continue;
            }
            if (cd.column().isSimple()) {
                Cell cell3 = (Cell)cd;
                sb.append(cell3.column().name).append('=');
                if (cell3.isTombstone()) {
                    sb.append("<tombstone>");
                    continue;
                }
                sb.append(cell3.column().type.getString(cell3.value()));
                continue;
            }
            sb.append(cd.column().name).append('=');
            complexData = (ComplexColumnData)cd;
            Function<Cell, String> transform = null;
            if (cd.column().type.isCollection()) {
                CollectionType ct = (CollectionType)cd.column().type;
                transform = cell -> String.format("%s -> %s", ct.nameComparator().getString(cell.path().get(0)), ct.valueComparator().getString(cell.value()));
            } else if (cd.column().type.isUDT()) {
                UserType ut = (UserType)cd.column().type;
                transform = cell -> {
                    Short fId = ut.nameComparator().getSerializer().deserialize(cell.path().get(0));
                    return String.format("%s -> %s", ut.fieldNameAsString(fId.shortValue()), ut.fieldType(fId.shortValue()).getString(cell.value()));
                };
            } else {
                transform = cell -> "";
            }
            sb.append(StreamSupport.stream(complexData.spliterator(), false).map(transform).collect(Collectors.joining(", ", "{", "}")));
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Row)) {
            return false;
        }
        Row that = (Row)other;
        if (!(this.clustering().equals(that.clustering()) && this.primaryKeyLivenessInfo().equals(that.primaryKeyLivenessInfo()) && this.deletion().equals(that.deletion()))) {
            return false;
        }
        return Iterables.elementsEqual((Iterable)this, (Iterable)that);
    }

    public int hashCode() {
        int hash = Objects.hash(this.clustering(), this.primaryKeyLivenessInfo(), this.deletion());
        for (ColumnData cd : this) {
            hash += 31 * cd.hashCode();
        }
        return hash;
    }
}

