/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.AbstractStrategyHolder;
import org.apache.cassandra.db.compaction.PendingRepairManager;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.schema.CompactionParams;

public class PendingRepairHolder
extends AbstractStrategyHolder {
    private final List<PendingRepairManager> managers = new ArrayList<PendingRepairManager>();
    private final boolean isTransient;

    public PendingRepairHolder(ColumnFamilyStore cfs, AbstractStrategyHolder.DestinationRouter router, boolean isTransient) {
        super(cfs, router);
        this.isTransient = isTransient;
    }

    @Override
    public void startup() {
        this.managers.forEach(PendingRepairManager::startup);
    }

    @Override
    public void shutdown() {
        this.managers.forEach(PendingRepairManager::shutdown);
    }

    @Override
    public void setStrategyInternal(CompactionParams params, int numTokenPartitions) {
        this.managers.clear();
        for (int i = 0; i < numTokenPartitions; ++i) {
            this.managers.add(new PendingRepairManager(this.cfs, params, this.isTransient));
        }
    }

    @Override
    public boolean managesRepairedGroup(boolean isRepaired, boolean isPendingRepair, boolean isTransient) {
        Preconditions.checkArgument((!isPendingRepair || !isRepaired ? 1 : 0) != 0, (Object)"SSTables cannot be both repaired and pending repair");
        return isPendingRepair && this.isTransient == isTransient;
    }

    @Override
    public AbstractCompactionStrategy getStrategyFor(SSTableReader sstable) {
        Preconditions.checkArgument((boolean)this.managesSSTable(sstable), (Object)"Attempting to get compaction strategy from wrong holder");
        return this.managers.get(this.router.getIndexForSSTable(sstable)).getOrCreate(sstable);
    }

    @Override
    public Iterable<AbstractCompactionStrategy> allStrategies() {
        return Iterables.concat((Iterable)Iterables.transform(this.managers, PendingRepairManager::getStrategies));
    }

    Iterable<AbstractCompactionStrategy> getStrategiesFor(UUID session) {
        ArrayList<AbstractCompactionStrategy> strategies = new ArrayList<AbstractCompactionStrategy>(this.managers.size());
        for (PendingRepairManager manager : this.managers) {
            AbstractCompactionStrategy strategy = manager.get(session);
            if (strategy == null) continue;
            strategies.add(strategy);
        }
        return strategies;
    }

    public Iterable<PendingRepairManager> getManagers() {
        return this.managers;
    }

    @Override
    public Collection<AbstractStrategyHolder.TaskSupplier> getBackgroundTaskSuppliers(int gcBefore) {
        ArrayList<AbstractStrategyHolder.TaskSupplier> suppliers = new ArrayList<AbstractStrategyHolder.TaskSupplier>(this.managers.size());
        for (PendingRepairManager manager : this.managers) {
            suppliers.add(new AbstractStrategyHolder.TaskSupplier(manager.getMaxEstimatedRemainingTasks(), () -> manager.getNextBackgroundTask(gcBefore)));
        }
        return suppliers;
    }

    @Override
    public Collection<AbstractCompactionTask> getMaximalTasks(int gcBefore, boolean splitOutput) {
        ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>(this.managers.size());
        for (PendingRepairManager manager : this.managers) {
            Collection<AbstractCompactionTask> task = manager.getMaximalTasks(gcBefore, splitOutput);
            if (task == null) continue;
            tasks.addAll(task);
        }
        return tasks;
    }

    @Override
    public Collection<AbstractCompactionTask> getUserDefinedTasks(AbstractStrategyHolder.GroupedSSTableContainer sstables, int gcBefore) {
        ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>(this.managers.size());
        for (int i = 0; i < this.managers.size(); ++i) {
            if (sstables.isGroupEmpty(i)) continue;
            tasks.addAll(this.managers.get(i).createUserDefinedTasks(sstables.getGroup(i), gcBefore));
        }
        return tasks;
    }

    AbstractCompactionTask getNextRepairFinishedTask() {
        ArrayList<AbstractStrategyHolder.TaskSupplier> repairFinishedSuppliers = this.getRepairFinishedTaskSuppliers();
        if (!repairFinishedSuppliers.isEmpty()) {
            Collections.sort(repairFinishedSuppliers);
            for (AbstractStrategyHolder.TaskSupplier supplier : repairFinishedSuppliers) {
                AbstractCompactionTask task = supplier.getTask();
                if (task == null) continue;
                return task;
            }
        }
        return null;
    }

    private ArrayList<AbstractStrategyHolder.TaskSupplier> getRepairFinishedTaskSuppliers() {
        ArrayList<AbstractStrategyHolder.TaskSupplier> suppliers = new ArrayList<AbstractStrategyHolder.TaskSupplier>(this.managers.size());
        for (PendingRepairManager manager : this.managers) {
            int numPending = manager.getNumPendingRepairFinishedTasks();
            if (numPending <= 0) continue;
            suppliers.add(new AbstractStrategyHolder.TaskSupplier(numPending, manager::getNextRepairFinishedTask));
        }
        return suppliers;
    }

    @Override
    public void addSSTables(AbstractStrategyHolder.GroupedSSTableContainer sstables) {
        Preconditions.checkArgument((sstables.numGroups() == this.managers.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.managers.size(); ++i) {
            if (sstables.isGroupEmpty(i)) continue;
            this.managers.get(i).addSSTables(sstables.getGroup(i));
        }
    }

    @Override
    public void removeSSTables(AbstractStrategyHolder.GroupedSSTableContainer sstables) {
        Preconditions.checkArgument((sstables.numGroups() == this.managers.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.managers.size(); ++i) {
            if (sstables.isGroupEmpty(i)) continue;
            this.managers.get(i).removeSSTables(sstables.getGroup(i));
        }
    }

    @Override
    public void replaceSSTables(AbstractStrategyHolder.GroupedSSTableContainer removed, AbstractStrategyHolder.GroupedSSTableContainer added) {
        Preconditions.checkArgument((removed.numGroups() == this.managers.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((added.numGroups() == this.managers.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.managers.size(); ++i) {
            if (removed.isGroupEmpty(i) && added.isGroupEmpty(i)) continue;
            if (removed.isGroupEmpty(i)) {
                this.managers.get(i).addSSTables(added.getGroup(i));
                continue;
            }
            this.managers.get(i).replaceSSTables(removed.getGroup(i), added.getGroup(i));
        }
    }

    @Override
    public List<ISSTableScanner> getScanners(AbstractStrategyHolder.GroupedSSTableContainer sstables, Collection<Range<Token>> ranges) {
        ArrayList<ISSTableScanner> scanners = new ArrayList<ISSTableScanner>(this.managers.size());
        for (int i = 0; i < this.managers.size(); ++i) {
            if (sstables.isGroupEmpty(i)) continue;
            scanners.addAll(this.managers.get(i).getScanners(sstables.getGroup(i), ranges));
        }
        return scanners;
    }

    @Override
    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, MetadataCollector collector, SerializationHeader header, Collection<Index> indexes, LifecycleNewTracker lifecycleNewTracker) {
        Preconditions.checkArgument((repairedAt == 0L ? 1 : 0) != 0, (Object)"PendingRepairHolder can't create sstablewriter with repaired at set");
        Preconditions.checkArgument((pendingRepair != null ? 1 : 0) != 0, (Object)"PendingRepairHolder can't create sstable writer without pendingRepair id");
        AbstractCompactionStrategy strategy = this.managers.get(this.router.getIndexForSSTableDirectory(descriptor)).getOrCreate(pendingRepair);
        return strategy.createSSTableMultiWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, collector, header, indexes, lifecycleNewTracker);
    }

    @Override
    public int getStrategyIndex(AbstractCompactionStrategy strategy) {
        for (int i = 0; i < this.managers.size(); ++i) {
            if (!this.managers.get(i).hasStrategy(strategy)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasDataForSession(UUID sessionID) {
        return Iterables.any(this.managers, prm -> prm.hasDataForSession(sessionID));
    }

    @Override
    public boolean containsSSTable(SSTableReader sstable) {
        return Iterables.any(this.managers, prm -> prm.containsSSTable(sstable));
    }
}

