/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.hash.Hasher;
import java.util.Objects;
import org.apache.cassandra.db.ExpirationDateOverflowHandling;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.HashingUtils;

public class LivenessInfo {
    public static final long NO_TIMESTAMP = Long.MIN_VALUE;
    public static final int NO_TTL = 0;
    public static final int EXPIRED_LIVENESS_TTL = Integer.MAX_VALUE;
    public static final int NO_EXPIRATION_TIME = Integer.MAX_VALUE;
    public static final LivenessInfo EMPTY = new LivenessInfo(Long.MIN_VALUE);
    protected final long timestamp;

    protected LivenessInfo(long timestamp) {
        this.timestamp = timestamp;
    }

    public static LivenessInfo create(long timestamp, int nowInSec) {
        return new LivenessInfo(timestamp);
    }

    public static LivenessInfo expiring(long timestamp, int ttl, int nowInSec) {
        assert (ttl != Integer.MAX_VALUE);
        return new ExpiringLivenessInfo(timestamp, ttl, ExpirationDateOverflowHandling.computeLocalExpirationTime(nowInSec, ttl));
    }

    public static LivenessInfo create(long timestamp, int ttl, int nowInSec) {
        return ttl == 0 ? LivenessInfo.create(timestamp, nowInSec) : LivenessInfo.expiring(timestamp, ttl, nowInSec);
    }

    public static LivenessInfo withExpirationTime(long timestamp, int ttl, int localExpirationTime) {
        if (ttl == Integer.MAX_VALUE) {
            return new ExpiredLivenessInfo(timestamp, ttl, localExpirationTime);
        }
        return ttl == 0 ? new LivenessInfo(timestamp) : new ExpiringLivenessInfo(timestamp, ttl, localExpirationTime);
    }

    public boolean isEmpty() {
        return this.timestamp == Long.MIN_VALUE;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public boolean isExpiring() {
        return false;
    }

    public int ttl() {
        return 0;
    }

    public int localExpirationTime() {
        return Integer.MAX_VALUE;
    }

    public boolean isLive(int nowInSec) {
        return !this.isEmpty();
    }

    public void digest(Hasher hasher) {
        HashingUtils.updateWithLong(hasher, this.timestamp());
    }

    public void validate() {
    }

    public int dataSize() {
        return TypeSizes.sizeof(this.timestamp());
    }

    public boolean supersedes(LivenessInfo other) {
        if (this.timestamp != other.timestamp) {
            return this.timestamp > other.timestamp;
        }
        if (this.isExpired() ^ other.isExpired()) {
            return this.isExpired();
        }
        if (this.isExpiring() == other.isExpiring()) {
            return this.localExpirationTime() > other.localExpirationTime();
        }
        return this.isExpiring();
    }

    protected boolean isExpired() {
        return false;
    }

    public LivenessInfo withUpdatedTimestamp(long newTimestamp) {
        return new LivenessInfo(newTimestamp);
    }

    public LivenessInfo withUpdatedTimestampAndLocalDeletionTime(long newTimestamp, int newLocalDeletionTime) {
        return LivenessInfo.create(newTimestamp, this.ttl(), newLocalDeletionTime);
    }

    public String toString() {
        return String.format("[ts=%d]", this.timestamp);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LivenessInfo)) {
            return false;
        }
        LivenessInfo that = (LivenessInfo)other;
        return this.timestamp() == that.timestamp() && this.ttl() == that.ttl() && this.localExpirationTime() == that.localExpirationTime();
    }

    public int hashCode() {
        return Objects.hash(this.timestamp(), this.ttl(), this.localExpirationTime());
    }

    private static class ExpiringLivenessInfo
    extends LivenessInfo {
        private final int ttl;
        private final int localExpirationTime;

        private ExpiringLivenessInfo(long timestamp, int ttl, int localExpirationTime) {
            super(timestamp);
            assert (ttl != 0 && localExpirationTime != Integer.MAX_VALUE);
            this.ttl = ttl;
            this.localExpirationTime = localExpirationTime;
        }

        @Override
        public int ttl() {
            return this.ttl;
        }

        @Override
        public int localExpirationTime() {
            return this.localExpirationTime;
        }

        @Override
        public boolean isExpiring() {
            return true;
        }

        @Override
        public boolean isLive(int nowInSec) {
            return nowInSec < this.localExpirationTime;
        }

        @Override
        public void digest(Hasher hasher) {
            super.digest(hasher);
            HashingUtils.updateWithInt(hasher, this.localExpirationTime);
            HashingUtils.updateWithInt(hasher, this.ttl);
        }

        @Override
        public void validate() {
            if (this.ttl < 0) {
                throw new MarshalException("A TTL should not be negative");
            }
            if (this.localExpirationTime < 0) {
                throw new MarshalException("A local expiration time should not be negative");
            }
        }

        @Override
        public int dataSize() {
            return super.dataSize() + TypeSizes.sizeof(this.ttl) + TypeSizes.sizeof(this.localExpirationTime);
        }

        @Override
        public LivenessInfo withUpdatedTimestamp(long newTimestamp) {
            return new ExpiringLivenessInfo(newTimestamp, this.ttl, this.localExpirationTime);
        }

        @Override
        public String toString() {
            return String.format("[ts=%d ttl=%d, let=%d]", this.timestamp, this.ttl, this.localExpirationTime);
        }
    }

    private static class ExpiredLivenessInfo
    extends ExpiringLivenessInfo {
        private ExpiredLivenessInfo(long timestamp, int ttl, int localExpirationTime) {
            super(timestamp, ttl, localExpirationTime);
            assert (ttl == Integer.MAX_VALUE);
            assert (timestamp != Long.MIN_VALUE);
        }

        @Override
        public boolean isExpired() {
            return true;
        }

        @Override
        public boolean isLive(int nowInSec) {
            return false;
        }

        @Override
        public LivenessInfo withUpdatedTimestamp(long newTimestamp) {
            return new ExpiredLivenessInfo(newTimestamp, this.ttl(), this.localExpirationTime());
        }
    }
}

