/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;

public class EncryptionOptions {
    public final String keystore;
    public final String keystore_password;
    public final String truststore;
    public final String truststore_password;
    public final List<String> cipher_suites;
    public final String protocol;
    public final String algorithm;
    public final String store_type;
    public final boolean require_client_auth;
    public final boolean require_endpoint_verification;
    public final boolean enabled;
    public final boolean optional;

    public EncryptionOptions() {
        this.keystore = "conf/.keystore";
        this.keystore_password = "cassandra";
        this.truststore = "conf/.truststore";
        this.truststore_password = "cassandra";
        this.cipher_suites = ImmutableList.of();
        this.protocol = "TLS";
        this.algorithm = null;
        this.store_type = "JKS";
        this.require_client_auth = false;
        this.require_endpoint_verification = false;
        this.enabled = false;
        this.optional = false;
    }

    public EncryptionOptions(String keystore, String keystore_password, String truststore, String truststore_password, List<String> cipher_suites, String protocol, String algorithm, String store_type, boolean require_client_auth, boolean require_endpoint_verification, boolean enabled, boolean optional) {
        this.keystore = keystore;
        this.keystore_password = keystore_password;
        this.truststore = truststore;
        this.truststore_password = truststore_password;
        this.cipher_suites = cipher_suites;
        this.protocol = protocol;
        this.algorithm = algorithm;
        this.store_type = store_type;
        this.require_client_auth = require_client_auth;
        this.require_endpoint_verification = require_endpoint_verification;
        this.enabled = enabled;
        this.optional = optional;
    }

    public EncryptionOptions(EncryptionOptions options) {
        this.keystore = options.keystore;
        this.keystore_password = options.keystore_password;
        this.truststore = options.truststore;
        this.truststore_password = options.truststore_password;
        this.cipher_suites = options.cipher_suites;
        this.protocol = options.protocol;
        this.algorithm = options.algorithm;
        this.store_type = options.store_type;
        this.require_client_auth = options.require_client_auth;
        this.require_endpoint_verification = options.require_endpoint_verification;
        this.enabled = options.enabled;
        this.optional = options.optional;
    }

    public EncryptionOptions withKeyStore(String keystore) {
        return new EncryptionOptions(keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withKeyStorePassword(String keystore_password) {
        return new EncryptionOptions(this.keystore, keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withTrustStore(String truststore) {
        return new EncryptionOptions(this.keystore, this.keystore_password, truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withTrustStorePassword(String truststore_password) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withCipherSuites(List<String> cipher_suites) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withCipherSuites(String ... cipher_suites) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, (List<String>)ImmutableList.copyOf((Object[])cipher_suites), this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withProtocol(String protocol) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withAlgorithm(String algorithm) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withStoreType(String store_type) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withRequireClientAuth(boolean require_client_auth) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, require_client_auth, this.require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withRequireEndpointVerification(boolean require_endpoint_verification) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, require_endpoint_verification, this.enabled, this.optional);
    }

    public EncryptionOptions withEnabled(boolean enabled) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, enabled, this.optional);
    }

    public EncryptionOptions withOptional(boolean optional) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, optional);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionOptions opt = (EncryptionOptions)o;
        return this.enabled == opt.enabled && this.optional == opt.optional && this.require_client_auth == opt.require_client_auth && this.require_endpoint_verification == opt.require_endpoint_verification && Objects.equals(this.keystore, opt.keystore) && Objects.equals(this.keystore_password, opt.keystore_password) && Objects.equals(this.truststore, opt.truststore) && Objects.equals(this.truststore_password, opt.truststore_password) && Objects.equals(this.protocol, opt.protocol) && Objects.equals(this.algorithm, opt.algorithm) && Objects.equals(this.store_type, opt.store_type) && Objects.equals(this.cipher_suites, opt.cipher_suites);
    }

    public int hashCode() {
        int result = 0;
        result += 31 * (this.keystore == null ? 0 : this.keystore.hashCode());
        result += 31 * (this.keystore_password == null ? 0 : this.keystore_password.hashCode());
        result += 31 * (this.truststore == null ? 0 : this.truststore.hashCode());
        result += 31 * (this.truststore_password == null ? 0 : this.truststore_password.hashCode());
        result += 31 * (this.protocol == null ? 0 : this.protocol.hashCode());
        result += 31 * (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result += 31 * (this.store_type == null ? 0 : this.store_type.hashCode());
        result += 31 * Boolean.hashCode(this.enabled);
        result += 31 * Boolean.hashCode(this.optional);
        result += 31 * (this.cipher_suites == null ? 0 : this.cipher_suites.hashCode());
        result += 31 * Boolean.hashCode(this.require_client_auth);
        return result += 31 * Boolean.hashCode(this.require_endpoint_verification);
    }

    public static class ServerEncryptionOptions
    extends EncryptionOptions {
        public final InternodeEncryption internode_encryption;
        public final boolean enable_legacy_ssl_storage_port;

        public ServerEncryptionOptions() {
            this.internode_encryption = InternodeEncryption.none;
            this.enable_legacy_ssl_storage_port = false;
        }

        public ServerEncryptionOptions(String keystore, String keystore_password, String truststore, String truststore_password, List<String> cipher_suites, String protocol, String algorithm, String store_type, boolean require_client_auth, boolean require_endpoint_verification, boolean enabled, boolean optional, InternodeEncryption internode_encryption, boolean enable_legacy_ssl_storage_port) {
            super(keystore, keystore_password, truststore, truststore_password, cipher_suites, protocol, algorithm, store_type, require_client_auth, require_endpoint_verification, enabled, optional);
            this.internode_encryption = internode_encryption;
            this.enable_legacy_ssl_storage_port = enable_legacy_ssl_storage_port;
        }

        public ServerEncryptionOptions(ServerEncryptionOptions options) {
            super(options);
            this.internode_encryption = options.internode_encryption;
            this.enable_legacy_ssl_storage_port = options.enable_legacy_ssl_storage_port;
        }

        public boolean shouldEncrypt(InetAddressAndPort endpoint) {
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            switch (this.internode_encryption) {
                case none: {
                    return false;
                }
                case all: {
                    break;
                }
                case dc: {
                    if (!snitch.getDatacenter(endpoint).equals(snitch.getLocalDatacenter())) break;
                    return false;
                }
                case rack: {
                    if (!snitch.getRack(endpoint).equals(snitch.getLocalRack()) || !snitch.getDatacenter(endpoint).equals(snitch.getLocalDatacenter())) break;
                    return false;
                }
            }
            return true;
        }

        @Override
        public ServerEncryptionOptions withKeyStore(String keystore) {
            return new ServerEncryptionOptions(keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withKeyStorePassword(String keystore_password) {
            return new ServerEncryptionOptions(this.keystore, keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withTrustStore(String truststore) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withTrustStorePassword(String truststore_password) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withCipherSuites(List<String> cipher_suites) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withCipherSuites(String ... cipher_suites) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, (List<String>)ImmutableList.copyOf((Object[])cipher_suites), this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withProtocol(String protocol) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withAlgorithm(String algorithm) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withStoreType(String store_type) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withRequireClientAuth(boolean require_client_auth) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withRequireEndpointVerification(boolean require_endpoint_verification) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withEnabled(boolean enabled) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, enabled, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        @Override
        public ServerEncryptionOptions withOptional(boolean optional) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, optional, this.internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        public ServerEncryptionOptions withInternodeEncryption(InternodeEncryption internode_encryption) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, internode_encryption, this.enable_legacy_ssl_storage_port);
        }

        public ServerEncryptionOptions withLegacySslStoragePort(boolean enable_legacy_ssl_storage_port) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional, this.internode_encryption, enable_legacy_ssl_storage_port);
        }

        public static enum InternodeEncryption {
            all,
            none,
            dc,
            rack;

        }
    }
}

