/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class CompactTables {
    public static final ByteBuffer SUPER_COLUMN_MAP_COLUMN = ByteBufferUtil.EMPTY_BYTE_BUFFER;
    public static final String SUPER_COLUMN_MAP_COLUMN_STR = (String)UTF8Type.instance.compose(SUPER_COLUMN_MAP_COLUMN);

    private CompactTables() {
    }

    public static ColumnDefinition getCompactValueColumn(PartitionColumns columns, boolean isSuper) {
        if (isSuper) {
            for (ColumnDefinition column : columns.regulars) {
                if (!column.name.bytes.equals(SUPER_COLUMN_MAP_COLUMN)) continue;
                return column;
            }
            throw new AssertionError((Object)"Invalid super column table definition, no 'dynamic' map column");
        }
        assert (columns.regulars.simpleColumnCount() == 1 && columns.regulars.complexColumnCount() == 0);
        return columns.regulars.getSimple(0);
    }

    public static AbstractType<?> columnDefinitionComparator(String kind, boolean isSuper, AbstractType<?> rawComparator, AbstractType<?> rawSubComparator) {
        if (!"regular".equals(kind)) {
            return UTF8Type.instance;
        }
        return isSuper ? rawSubComparator : rawComparator;
    }

    public static boolean hasEmptyCompactValue(CFMetaData metadata) {
        return metadata.compactValueColumn().type instanceof EmptyType;
    }

    public static boolean isSuperColumnMapColumn(ColumnDefinition column) {
        return column.kind == ColumnDefinition.Kind.REGULAR && column.name.bytes.equals(SUPER_COLUMN_MAP_COLUMN);
    }

    public static DefaultNames defaultNameGenerator(Set<String> usedNames) {
        return new DefaultNames(new HashSet<String>(usedNames));
    }

    public static DefaultNames defaultNameGenerator(Iterable<ColumnDefinition> defs) {
        HashSet<String> usedNames = new HashSet<String>();
        for (ColumnDefinition def : defs) {
            usedNames.add(def.name.toString());
        }
        return new DefaultNames(usedNames);
    }

    public static class DefaultNames {
        private static final String DEFAULT_PARTITION_KEY_NAME = "key";
        private static final String DEFAULT_CLUSTERING_NAME = "column";
        private static final String DEFAULT_COMPACT_VALUE_NAME = "value";
        private final Set<String> usedNames;
        private int partitionIndex = 0;
        private int clusteringIndex = 1;
        private int compactIndex = 0;

        private DefaultNames(Set<String> usedNames) {
            this.usedNames = usedNames;
        }

        public String defaultPartitionKeyName() {
            String candidate;
            do {
                candidate = this.partitionIndex == 0 ? DEFAULT_PARTITION_KEY_NAME : DEFAULT_PARTITION_KEY_NAME + (this.partitionIndex + 1);
                ++this.partitionIndex;
            } while (!this.usedNames.add(candidate));
            return candidate;
        }

        public String defaultClusteringName() {
            String candidate;
            do {
                candidate = DEFAULT_CLUSTERING_NAME + this.clusteringIndex;
                ++this.clusteringIndex;
            } while (!this.usedNames.add(candidate));
            return candidate;
        }

        public String defaultCompactValueName() {
            String candidate;
            do {
                candidate = this.compactIndex == 0 ? DEFAULT_COMPACT_VALUE_NAME : DEFAULT_COMPACT_VALUE_NAME + this.compactIndex;
                ++this.compactIndex;
            } while (!this.usedNames.add(candidate));
            return candidate;
        }
    }
}

