/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.UTName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public class CreateTypeStatement
extends SchemaAlteringStatement {
    private final UTName name;
    private final List<FieldIdentifier> columnNames = new ArrayList<FieldIdentifier>();
    private final List<CQL3Type.Raw> columnTypes = new ArrayList<CQL3Type.Raw>();
    private final boolean ifNotExists;

    public CreateTypeStatement(UTName name, boolean ifNotExists) {
        this.name = name;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.name.hasKeyspace()) {
            this.name.setKeyspace(state.getKeyspace());
        }
    }

    public void addDefinition(FieldIdentifier name, CQL3Type.Raw type) {
        this.columnNames.add(name);
        this.columnTypes.add(type);
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace(), Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        if (ksm == null) {
            throw new InvalidRequestException(String.format("Cannot add type in unknown keyspace %s", this.name.getKeyspace()));
        }
        if (ksm.types.get(this.name.getUserTypeName()).isPresent() && !this.ifNotExists) {
            throw new InvalidRequestException(String.format("A user type of name %s already exists", this.name));
        }
        for (CQL3Type.Raw type : this.columnTypes) {
            if (type.isCounter()) {
                throw new InvalidRequestException("A user type cannot contain counters");
            }
            if (!type.isUDT() || type.isFrozen()) continue;
            throw new InvalidRequestException("A user type cannot contain non-frozen UDTs");
        }
    }

    public static void checkForDuplicateNames(UserType type) throws InvalidRequestException {
        for (int i = 0; i < type.size() - 1; ++i) {
            FieldIdentifier fieldName = type.fieldName(i);
            for (int j = i + 1; j < type.size(); ++j) {
                if (!fieldName.equals(type.fieldName(j))) continue;
                throw new InvalidRequestException(String.format("Duplicate field name %s in type %s", fieldName, type.name));
            }
        }
    }

    public void addToRawBuilder(Types.RawBuilder builder) throws InvalidRequestException {
        builder.add(this.name.getStringTypeName(), this.columnNames.stream().map(FieldIdentifier::toString).collect(Collectors.toList()), this.columnTypes.stream().map(Object::toString).collect(Collectors.toList()));
    }

    @Override
    public String keyspace() {
        return this.name.getKeyspace();
    }

    public UserType createType() throws InvalidRequestException {
        ArrayList types = new ArrayList(this.columnTypes.size());
        for (CQL3Type.Raw type : this.columnTypes) {
            types.add(type.prepare(this.keyspace()).getType());
        }
        return new UserType(this.name.getKeyspace(), this.name.getUserTypeName(), this.columnNames, types, true);
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        assert (ksm != null);
        if (ksm.types.get(this.name.getUserTypeName()).isPresent()) {
            return null;
        }
        UserType type = this.createType();
        CreateTypeStatement.checkForDuplicateNames(type);
        MigrationManager.announceNewType(type, isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TYPE, this.keyspace(), this.name.getStringTypeName());
    }
}

