/* The following code was generated by JFlex 1.6.0 */

package org.apache.cassandra.index.sasi.analyzer;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Arrays;

/**
 * This class implements Word Break rules from the Unicode Text Segmentation 
 * algorithm, as specified in 
 * <a href="http://unicode.org/reports/tr29/">Unicode Standard Annex #29</a>. ∂
 * <p/>
 * Tokens produced are of the following types:
 * <ul>
 *   <li>&lt;ALPHANUM&gt;: A sequence of alphabetic and numeric characters</li>
 *   <li>&lt;NUM&gt;: A number</li>
 *   <li>&lt;SOUTHEAST_ASIAN&gt;: A sequence of characters from South and Southeast
 *       Asian languages, including Thai, Lao, Myanmar, and Khmer</li>
 *   <li>&lt;IDEOGRAPHIC&gt;: A single CJKV ideographic character</li>
 *   <li>&lt;HIRAGANA&gt;: A single hiragana character</li>
 *   <li>&lt;KATAKANA&gt;: A sequence of katakana characters</li>
 *   <li>&lt;HANGUL&gt;: A sequence of Hangul characters</li>
 * </ul>
 */

public final class StandardTokenizerImpl implements StandardTokenizerInterface {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 4096;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\42\0\1\213\4\0\1\212\4\0\1\203\1\0\1\204\1\0\12\200"+
    "\1\202\1\203\5\0\32\176\4\0\1\205\1\0\32\176\57\0\1\176"+
    "\2\0\1\177\7\0\1\176\1\0\1\202\2\0\1\176\5\0\27\176"+
    "\1\0\37\176\1\0\u01ca\176\4\0\14\176\5\0\1\202\10\0\5\176"+
    "\7\0\1\176\1\0\1\176\21\0\160\177\5\176\1\0\2\176\2\0"+
    "\4\176\1\203\7\0\1\176\1\202\3\176\1\0\1\176\1\0\24\176"+
    "\1\0\123\176\1\0\213\176\1\0\7\177\236\176\11\0\46\176\2\0"+
    "\1\176\7\0\47\176\1\0\1\203\7\0\55\177\1\0\1\177\1\0"+
    "\2\177\1\0\2\177\1\0\1\177\10\0\33\214\5\0\3\214\1\176"+
    "\1\202\13\0\5\177\7\0\2\203\2\0\13\177\1\0\1\177\3\0"+
    "\53\176\25\177\12\200\1\0\1\200\1\203\1\0\2\176\1\177\143\176"+
    "\1\0\1\176\7\177\1\177\1\0\6\177\2\176\2\177\1\0\4\177"+
    "\2\176\12\200\3\176\2\0\1\176\17\0\1\177\1\176\1\177\36\176"+
    "\33\177\2\0\131\176\13\177\1\176\16\0\12\200\41\176\11\177\2\176"+
    "\2\0\1\203\1\0\1\176\5\0\26\176\4\177\1\176\11\177\1\176"+
    "\3\177\1\176\5\177\22\0\31\176\3\177\104\0\1\176\1\0\13\176"+
    "\67\0\33\177\1\0\4\177\66\176\3\177\1\176\22\177\1\176\7\177"+
    "\12\176\2\177\2\0\12\200\1\0\7\176\1\0\7\176\1\0\3\177"+
    "\1\0\10\176\2\0\2\176\2\0\26\176\1\0\7\176\1\0\1\176"+
    "\3\0\4\176\2\0\1\177\1\176\7\177\2\0\2\177\2\0\3\177"+
    "\1\176\10\0\1\177\4\0\2\176\1\0\3\176\2\177\2\0\12\200"+
    "\2\176\17\0\3\177\1\0\6\176\4\0\2\176\2\0\26\176\1\0"+
    "\7\176\1\0\2\176\1\0\2\176\1\0\2\176\2\0\1\177\1\0"+
    "\5\177\4\0\2\177\2\0\3\177\3\0\1\177\7\0\4\176\1\0"+
    "\1\176\7\0\12\200\2\177\3\176\1\177\13\0\3\177\1\0\11\176"+
    "\1\0\3\176\1\0\26\176\1\0\7\176\1\0\2\176\1\0\5\176"+
    "\2\0\1\177\1\176\10\177\1\0\3\177\1\0\3\177\2\0\1\176"+
    "\17\0\2\176\2\177\2\0\12\200\21\0\3\177\1\0\10\176\2\0"+
    "\2\176\2\0\26\176\1\0\7\176\1\0\2\176\1\0\5\176\2\0"+
    "\1\177\1\176\7\177\2\0\2\177\2\0\3\177\10\0\2\177\4\0"+
    "\2\176\1\0\3\176\2\177\2\0\12\200\1\0\1\176\20\0\1\177"+
    "\1\176\1\0\6\176\3\0\3\176\1\0\4\176\3\0\2\176\1\0"+
    "\1\176\1\0\2\176\3\0\2\176\3\0\3\176\3\0\14\176\4\0"+
    "\5\177\3\0\3\177\1\0\4\177\2\0\1\176\6\0\1\177\16\0"+
    "\12\200\21\0\3\177\1\0\10\176\1\0\3\176\1\0\27\176\1\0"+
    "\12\176\1\0\5\176\3\0\1\176\7\177\1\0\3\177\1\0\4\177"+
    "\7\0\2\177\1\0\2\176\6\0\2\176\2\177\2\0\12\200\22\0"+
    "\2\177\1\0\10\176\1\0\3\176\1\0\27\176\1\0\12\176\1\0"+
    "\5\176\2\0\1\177\1\176\7\177\1\0\3\177\1\0\4\177\7\0"+
    "\2\177\7\0\1\176\1\0\2\176\2\177\2\0\12\200\1\0\2\176"+
    "\17\0\2\177\1\0\10\176\1\0\3\176\1\0\51\176\2\0\1\176"+
    "\7\177\1\0\3\177\1\0\4\177\1\176\10\0\1\177\10\0\2\176"+
    "\2\177\2\0\12\200\12\0\6\176\2\0\2\177\1\0\22\176\3\0"+
    "\30\176\1\0\11\176\1\0\1\176\2\0\7\176\3\0\1\177\4\0"+
    "\6\177\1\0\1\177\1\0\10\177\22\0\2\177\15\0\60\206\1\207"+
    "\2\206\7\207\5\0\7\206\10\207\1\0\12\200\47\0\2\206\1\0"+
    "\1\206\2\0\2\206\1\0\1\206\2\0\1\206\6\0\4\206\1\0"+
    "\7\206\1\0\3\206\1\0\1\206\1\0\1\206\2\0\2\206\1\0"+
    "\4\206\1\207\2\206\6\207\1\0\2\207\1\206\2\0\5\206\1\0"+
    "\1\206\1\0\6\207\2\0\12\200\2\0\4\206\40\0\1\176\27\0"+
    "\2\177\6\0\12\200\13\0\1\177\1\0\1\177\1\0\1\177\4\0"+
    "\2\177\10\176\1\0\44\176\4\0\24\177\1\0\2\177\5\176\13\177"+
    "\1\0\44\177\11\0\1\177\71\0\53\206\24\207\1\206\12\200\6\0"+
    "\6\206\4\207\4\206\3\207\1\206\3\207\2\206\7\207\3\206\4\207"+
    "\15\206\14\207\1\206\1\207\12\200\4\207\2\206\46\176\1\0\1\176"+
    "\5\0\1\176\2\0\53\176\1\0\4\176\u0100\216\111\176\1\0\4\176"+
    "\2\0\7\176\1\0\1\176\1\0\4\176\2\0\51\176\1\0\4\176"+
    "\2\0\41\176\1\0\4\176\2\0\7\176\1\0\1\176\1\0\4\176"+
    "\2\0\17\176\1\0\71\176\1\0\4\176\2\0\103\176\2\0\3\177"+
    "\40\0\20\176\20\0\125\176\14\0\u026c\176\2\0\21\176\1\0\32\176"+
    "\5\0\113\176\3\0\3\176\17\0\15\176\1\0\4\176\3\177\13\0"+
    "\22\176\3\177\13\0\22\176\2\177\14\0\15\176\1\0\3\176\1\0"+
    "\2\177\14\0\64\206\40\207\3\0\1\206\4\0\1\206\1\207\2\0"+
    "\12\200\41\0\3\177\1\177\1\0\12\200\6\0\130\176\10\0\51\176"+
    "\1\177\1\176\5\0\106\176\12\0\35\176\3\0\14\177\4\0\14\177"+
    "\12\0\12\200\36\206\2\0\5\206\13\0\54\206\4\0\21\207\7\206"+
    "\2\207\6\0\12\200\1\206\3\0\2\206\40\0\27\176\5\177\4\0"+
    "\65\206\12\207\1\0\35\207\2\0\1\177\12\200\6\0\12\200\6\0"+
    "\16\206\122\0\5\177\57\176\21\177\7\176\4\0\12\200\21\0\11\177"+
    "\14\0\3\177\36\176\15\177\2\176\12\200\54\176\16\177\14\0\44\176"+
    "\24\177\10\0\12\200\3\0\3\176\12\200\44\176\122\0\3\177\1\0"+
    "\25\177\4\176\1\177\4\176\3\177\2\176\11\0\300\176\47\177\25\0"+
    "\4\177\u0116\176\2\0\6\176\2\0\46\176\2\0\6\176\2\0\10\176"+
    "\1\0\1\176\1\0\1\176\1\0\1\176\1\0\37\176\2\0\65\176"+
    "\1\0\7\176\1\0\1\176\3\0\3\176\1\0\7\176\3\0\4\176"+
    "\2\0\6\176\4\0\15\176\5\0\3\176\1\0\7\176\17\0\2\177"+
    "\2\177\10\0\2\204\12\0\1\204\2\0\1\202\2\0\5\177\20\0"+
    "\2\205\3\0\1\203\17\0\1\205\13\0\5\177\1\0\12\177\1\0"+
    "\1\176\15\0\1\176\20\0\15\176\63\0\41\177\21\0\1\176\4\0"+
    "\1\176\2\0\12\176\1\0\1\176\3\0\5\176\6\0\1\176\1\0"+
    "\1\176\1\0\1\176\1\0\4\176\1\0\13\176\2\0\4\176\5\0"+
    "\5\176\4\0\1\176\21\0\51\176\u032d\0\64\176\u0716\0\57\176\1\0"+
    "\57\176\1\0\205\176\6\0\4\176\3\177\2\176\14\0\46\176\1\0"+
    "\1\176\5\0\1\176\2\0\70\176\7\0\1\176\17\0\1\177\27\176"+
    "\11\0\7\176\1\0\7\176\1\0\7\176\1\0\7\176\1\0\7\176"+
    "\1\0\7\176\1\0\7\176\1\0\7\176\1\0\40\177\57\0\1\176"+
    "\120\0\32\210\1\0\131\210\14\0\326\210\57\0\1\176\1\0\1\210"+
    "\31\0\11\210\6\177\1\0\5\201\2\0\3\210\1\176\1\176\4\0"+
    "\126\211\2\0\2\177\2\201\3\211\133\201\1\0\4\201\5\0\51\176"+
    "\3\0\136\216\21\0\33\176\65\0\20\201\320\0\57\201\1\0\130\201"+
    "\250\0\u19b6\210\112\0\u51cd\210\63\0\u048d\176\103\0\56\176\2\0\u010d\176"+
    "\3\0\20\176\12\200\2\176\24\0\57\176\4\177\1\0\12\177\1\0"+
    "\31\176\7\0\1\177\120\176\2\177\45\0\11\176\2\0\147\176\2\0"+
    "\4\176\1\0\4\176\14\0\13\176\115\0\12\176\1\177\3\176\1\177"+
    "\4\176\1\177\27\176\5\177\30\0\64\176\14\0\2\177\62\176\21\177"+
    "\13\0\12\200\6\0\22\177\6\176\3\0\1\176\4\0\12\200\34\176"+
    "\10\177\2\0\27\176\15\177\14\0\35\216\3\0\4\177\57\176\16\177"+
    "\16\0\1\176\12\200\46\0\51\176\16\177\11\0\3\176\1\177\10\176"+
    "\2\177\2\0\12\200\6\0\33\206\1\207\4\0\60\206\1\207\1\206"+
    "\3\207\2\206\2\207\5\206\2\207\1\206\1\207\1\206\30\0\5\206"+
    "\13\176\5\177\2\0\3\176\2\177\12\0\6\176\2\0\6\176\2\0"+
    "\6\176\11\0\7\176\1\0\7\176\221\0\43\176\10\177\1\0\2\177"+
    "\2\0\12\200\6\0\u2ba4\216\14\0\27\216\4\0\61\216\4\0\1\44"+
    "\1\40\1\67\1\64\1\33\1\30\2\0\1\24\1\21\2\0\1\17"+
    "\1\15\14\0\1\3\1\6\20\0\1\156\7\0\1\111\1\10\5\0"+
    "\1\1\1\172\3\0\1\163\1\163\1\163\1\163\1\163\1\163\1\163"+
    "\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163"+
    "\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163"+
    "\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163"+
    "\1\163\1\163\1\163\1\163\1\164\1\163\1\163\1\163\1\170\1\166"+
    "\17\0\1\160\u02c1\0\1\114\277\0\1\157\1\115\1\16\3\167\2\62"+
    "\1\167\1\62\2\167\1\36\21\167\2\106\7\117\1\116\7\117\7\102"+
    "\1\37\1\102\1\140\2\66\1\65\1\140\1\66\1\65\10\140\2\107"+
    "\5\103\2\75\5\103\1\22\10\53\5\23\3\41\12\122\20\41\3\63"+
    "\32\43\1\42\2\61\2\126\1\127\2\126\2\127\2\126\1\127\3\61"+
    "\1\60\2\61\12\110\1\136\1\50\1\45\1\110\6\50\1\45\13\50"+
    "\31\61\7\50\12\123\1\50\5\13\3\137\3\101\1\100\4\101\2\100"+
    "\10\101\1\100\7\35\1\34\2\35\7\101\16\137\1\151\4\124\1\4"+
    "\4\121\1\4\5\150\1\147\1\150\3\147\7\150\1\147\23\150\5\113"+
    "\3\150\6\113\2\113\6\112\5\112\3\144\2\101\7\143\36\101\4\143"+
    "\5\101\5\137\6\135\2\137\1\135\4\35\13\146\12\121\14\146\12\175"+
    "\15\174\1\145\2\174\1\173\3\152\1\13\2\152\5\161\4\152\4\162"+
    "\1\161\3\162\1\161\5\162\2\70\1\73\2\70\1\73\1\70\2\73"+
    "\1\70\1\73\12\70\1\73\4\5\1\154\1\153\1\155\1\12\3\165"+
    "\1\155\2\165\1\141\2\142\2\165\1\12\1\165\1\12\1\165\1\12"+
    "\1\165\3\12\1\165\2\12\1\165\1\12\2\165\1\12\1\165\1\12"+
    "\1\165\1\12\1\165\1\12\1\165\1\12\1\76\2\72\1\76\1\72"+
    "\2\76\4\72\1\76\7\72\1\76\4\72\1\76\4\72\1\165\1\12"+
    "\1\165\12\31\1\57\21\31\1\57\3\32\1\57\3\31\1\57\1\31"+
    "\2\2\2\31\1\57\15\134\4\47\4\54\1\120\1\56\10\120\7\54"+
    "\6\165\4\25\1\27\37\25\1\27\4\25\25\105\1\171\11\105\21\26"+
    "\5\105\1\7\12\55\5\105\6\104\4\76\1\77\1\26\5\133\12\131"+
    "\17\133\1\74\3\71\14\130\1\11\11\46\1\52\5\46\4\132\13\51"+
    "\2\14\11\46\1\52\31\46\1\52\4\11\4\46\2\52\2\125\1\20"+
    "\5\125\52\20\u1900\0\u016e\210\2\0\152\210\46\0\7\176\14\0\5\176"+
    "\5\0\1\214\1\177\12\214\1\0\15\214\1\0\5\214\1\0\1\214"+
    "\1\0\2\214\1\0\2\214\1\0\12\214\142\176\41\0\u016b\176\22\0"+
    "\100\176\2\0\66\176\50\0\14\176\4\0\20\177\1\203\2\0\1\202"+
    "\1\203\13\0\7\177\14\0\2\205\30\0\3\205\1\203\1\0\1\204"+
    "\1\0\1\203\1\202\32\0\5\176\1\0\207\176\2\0\1\177\7\0"+
    "\1\204\4\0\1\203\1\0\1\204\1\0\12\200\1\202\1\203\5\0"+
    "\32\176\4\0\1\205\1\0\32\176\13\0\70\201\2\177\37\216\3\0"+
    "\6\216\2\0\6\216\2\0\6\216\2\0\3\216\34\0\3\177\4\0"+
    "\14\176\1\0\32\176\1\0\23\176\1\0\2\176\1\0\17\176\2\0"+
    "\16\176\42\0\173\176\105\0\65\176\210\0\1\177\202\0\35\176\3\0"+
    "\61\176\57\0\37\176\21\0\33\176\65\0\36\176\2\0\44\176\4\0"+
    "\10\176\1\0\5\176\52\0\236\176\2\0\12\200\u0356\0\6\176\2\0"+
    "\1\176\1\0\54\176\1\0\2\176\3\0\1\176\2\0\27\176\252\0"+
    "\26\176\12\0\32\176\106\0\70\176\6\0\2\176\100\0\1\176\3\177"+
    "\1\0\2\177\5\0\4\177\4\176\1\0\3\176\1\0\33\176\4\0"+
    "\3\177\4\0\1\177\40\0\35\176\203\0\66\176\12\0\26\176\12\0"+
    "\23\176\215\0\111\176\u03b7\0\3\177\65\176\17\177\37\0\12\200\20\0"+
    "\3\177\55\176\13\177\2\0\1\177\22\0\31\176\7\0\12\200\6\0"+
    "\3\177\44\176\16\177\1\0\12\200\100\0\3\177\60\176\16\177\4\176"+
    "\13\0\12\200\u04a6\0\53\176\15\177\10\0\12\200\u0936\0\u036f\176\221\0"+
    "\143\176\u0b9d\0\u042f\176\u33d1\0\u0239\176\u04c7\0\105\176\13\0\1\176\56\177"+
    "\20\0\4\177\15\176\u4060\0\1\201\1\211\u2163\0\5\177\3\0\6\177"+
    "\10\177\10\177\2\0\7\177\36\0\4\177\224\0\3\177\u01bb\0\125\176"+
    "\1\0\107\176\1\0\2\176\2\0\1\176\2\0\2\176\2\0\4\176"+
    "\1\0\14\176\1\0\1\176\1\0\7\176\1\0\101\176\1\0\4\176"+
    "\2\0\10\176\1\0\7\176\1\0\34\176\1\0\4\176\1\0\5\176"+
    "\1\0\1\176\3\0\7\176\1\0\u0154\176\2\0\31\176\1\0\31\176"+
    "\1\0\37\176\1\0\31\176\1\0\37\176\1\0\31\176\1\0\37\176"+
    "\1\0\31\176\1\0\37\176\1\0\31\176\1\0\10\176\2\0\62\200"+
    "\u1600\0\4\176\1\0\33\176\1\0\2\176\1\0\1\176\2\0\1\176"+
    "\1\0\12\176\1\0\4\176\1\0\1\176\1\0\1\176\6\0\1\176"+
    "\4\0\1\176\1\0\1\176\1\0\1\176\1\0\3\176\1\0\2\176"+
    "\1\0\1\176\2\0\1\176\1\0\1\176\1\0\1\176\1\0\1\176"+
    "\1\0\1\176\1\0\2\176\1\0\1\176\2\0\4\176\1\0\7\176"+
    "\1\0\4\176\1\0\4\176\1\0\1\176\1\0\12\176\1\0\21\176"+
    "\5\0\3\176\1\0\5\176\1\0\21\176\u032a\0\32\215\1\211\u0dff\0"+
    "\ua6d7\210\51\0\u1035\210\13\0\336\210\u3fe2\0\u021e\210\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05ee\0"+
    "\1\177\36\0\140\177\200\0\360\177\uffff\0\uffff\0\ufe12\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\26\1\1\2\1\3\1\4\1\1\1\5\1\6"+
    "\1\7\1\2\1\1\1\10\21\0\1\2\1\0\1\2"+
    "\12\0\1\3\21\0\1\2\25\0\1\2\11\0\1\1"+
    "\124\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[198];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\217\0\u011e\0\u01ad\0\u023c\0\u02cb\0\u035a\0\u03e9"+
    "\0\u0478\0\u0507\0\u0596\0\u0625\0\u06b4\0\u0743\0\u07d2\0\u0861"+
    "\0\u08f0\0\u097f\0\u0a0e\0\u0a9d\0\u0b2c\0\u0bbb\0\u0c4a\0\u0cd9"+
    "\0\u0d68\0\u0df7\0\u0e86\0\u0f15\0\u0fa4\0\u1033\0\u10c2\0\u1151"+
    "\0\u11e0\0\u1151\0\u011e\0\u01ad\0\u126f\0\u12fe\0\u035a\0\u03e9"+
    "\0\u0478\0\u0507\0\u138d\0\u141c\0\u14ab\0\u153a\0\u07d2\0\u15c9"+
    "\0\u1658\0\u16e7\0\u1776\0\u1805\0\u1894\0\u1923\0\u02cb\0\u19b2"+
    "\0\u1a41\0\u06b4\0\u1ad0\0\u1b5f\0\u1bee\0\u1c7d\0\u1d0c\0\u1d9b"+
    "\0\u1e2a\0\u1eb9\0\u1f48\0\u1fd7\0\u2066\0\u20f5\0\u2184\0\u2213"+
    "\0\u22a2\0\u2331\0\u23c0\0\u244f\0\u24de\0\u256d\0\u25fc\0\u268b"+
    "\0\u0e86\0\u271a\0\u27a9\0\u2838\0\u28c7\0\u2956\0\u29e5\0\u2a74"+
    "\0\u2b03\0\u2b92\0\u2c21\0\u2cb0\0\u2d3f\0\u2dce\0\u2e5d\0\u2eec"+
    "\0\u2f7b\0\u300a\0\u3099\0\u3128\0\u31b7\0\u3246\0\u32d5\0\u3364"+
    "\0\u33f3\0\u3482\0\u3511\0\u35a0\0\u362f\0\u36be\0\u374d\0\u37dc"+
    "\0\u386b\0\u38fa\0\u3989\0\u3a18\0\u3aa7\0\u3b36\0\u3bc5\0\u3c54"+
    "\0\u3ce3\0\u3d72\0\u3e01\0\u3e90\0\u3f1f\0\u3fae\0\u403d\0\u40cc"+
    "\0\u415b\0\u41ea\0\u4279\0\u4308\0\u4397\0\u4426\0\u44b5\0\u4544"+
    "\0\u45d3\0\u4662\0\u46f1\0\u4780\0\u480f\0\u489e\0\u492d\0\u49bc"+
    "\0\u4a4b\0\u4ada\0\u4b69\0\u4bf8\0\u4c87\0\u4d16\0\u4da5\0\u4e34"+
    "\0\u4ec3\0\u4f52\0\u4fe1\0\u5070\0\u50ff\0\u518e\0\u521d\0\u52ac"+
    "\0\u533b\0\u53ca\0\u5459\0\u54e8\0\u5577\0\u5606\0\u5695\0\u5724"+
    "\0\u57b3\0\u5842\0\u58d1\0\u5960\0\u59ef\0\u5a7e\0\u5b0d\0\u5b9c"+
    "\0\u5c2b\0\u5cba\0\u5d49\0\u5dd8\0\u5e67\0\u5ef6\0\u5f85\0\u6014"+
    "\0\u60a3\0\u6132\0\u61c1\0\u6250\0\u62df\0\u636e\0\u63fd\0\u648c"+
    "\0\u651b\0\u65aa\0\u6639\0\u66c8\0\u6757\0\u67e6";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[198];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\2\1\4\2\2\1\5\1\2\1\6"+
    "\4\2\1\7\1\2\1\10\1\2\1\11\2\2\1\12"+
    "\3\2\1\13\2\2\1\14\4\2\1\15\3\2\1\16"+
    "\17\2\1\17\2\2\1\20\66\2\1\21\1\2\1\22"+
    "\2\2\1\23\1\24\1\2\1\25\1\2\1\26\1\2"+
    "\1\27\3\2\1\30\1\2\1\31\1\32\3\2\1\33"+
    "\2\34\1\35\1\36\2\2\1\37\1\40\1\41\221\0"+
    "\1\30\2\0\1\30\4\0\1\30\16\0\1\30\15\0"+
    "\1\30\20\0\1\30\1\0\1\30\41\0\1\30\4\0"+
    "\1\30\10\0\2\30\5\0\2\30\10\0\1\30\27\0"+
    "\2\30\5\0\1\30\2\0\1\30\3\0\2\30\10\0"+
    "\4\30\1\0\3\30\1\0\1\30\2\0\1\30\2\0"+
    "\1\30\4\0\4\30\1\0\2\30\1\0\1\30\2\0"+
    "\1\30\1\0\1\30\2\0\4\30\2\0\3\30\1\0"+
    "\2\30\1\0\3\30\1\0\4\30\1\0\2\30\5\0"+
    "\4\30\2\0\10\30\1\0\1\30\2\0\1\30\1\0"+
    "\2\30\4\0\1\30\3\0\3\30\30\0\1\30\4\0"+
    "\1\30\11\0\1\30\22\0\1\30\3\0\1\30\27\0"+
    "\1\30\63\0\1\30\32\0\1\30\3\0\4\30\1\0"+
    "\1\30\1\0\1\31\2\0\1\30\1\0\2\30\2\0"+
    "\2\30\2\0\3\30\1\0\1\30\1\0\1\30\2\0"+
    "\4\30\1\0\3\30\1\0\1\30\1\0\3\30\1\0"+
    "\2\30\1\0\4\30\1\0\2\30\2\0\10\30\1\0"+
    "\2\30\1\0\10\30\1\31\1\0\7\30\1\0\10\30"+
    "\1\0\6\30\1\0\1\30\1\0\2\30\2\0\1\30"+
    "\1\0\1\30\3\0\3\30\37\0\1\30\17\0\1\30"+
    "\23\0\1\30\23\0\1\30\6\0\3\30\37\0\1\30"+
    "\7\0\1\30\31\0\1\30\1\0\2\30\1\0\1\30"+
    "\1\0\4\30\1\0\1\30\1\0\1\30\1\0\2\30"+
    "\1\0\3\30\1\0\2\30\1\0\4\30\1\0\3\30"+
    "\1\0\17\30\1\0\2\30\1\0\21\30\1\0\2\30"+
    "\1\0\41\30\1\0\1\30\1\0\2\30\2\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\37\0\1\30"+
    "\3\0\2\30\12\0\2\30\13\0\1\30\6\0\1\30"+
    "\2\0\2\30\6\0\1\30\4\0\2\30\2\0\2\30"+
    "\5\0\3\30\20\0\1\30\16\0\1\30\7\0\1\30"+
    "\31\0\1\30\1\0\2\30\1\0\1\30\2\0\2\30"+
    "\2\0\1\30\3\0\2\30\1\0\3\30\1\0\2\30"+
    "\1\0\4\30\1\0\3\30\1\0\1\30\1\0\2\30"+
    "\2\0\11\30\1\0\2\30\1\0\1\30\1\0\2\30"+
    "\1\0\14\30\1\0\2\30\1\0\10\30\1\0\2\30"+
    "\1\0\1\30\1\0\23\30\1\0\1\30\1\0\2\30"+
    "\2\0\1\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\23\0\1\30\26\0\2\30\23\0\1\31\1\30\40\0"+
    "\1\31\102\0\1\31\27\0\4\30\2\0\2\30\14\0"+
    "\3\30\15\0\3\30\3\0\1\30\7\0\2\30\1\0"+
    "\4\31\1\0\2\30\13\0\1\30\23\0\1\30\45\0"+
    "\1\30\3\0\2\30\12\0\2\30\1\0\3\30\7\0"+
    "\1\30\6\0\2\30\1\0\2\30\6\0\1\30\4\0"+
    "\2\30\2\0\2\30\5\0\3\30\2\0\1\30\3\0"+
    "\2\31\10\0\1\30\16\0\1\30\7\0\1\30\31\0"+
    "\1\30\4\0\1\30\6\0\1\30\3\0\1\30\6\0"+
    "\1\30\5\0\1\30\2\0\2\30\1\0\17\30\2\0"+
    "\1\30\13\0\7\30\2\0\1\30\1\0\1\30\1\0"+
    "\2\30\2\0\1\30\1\0\3\30\2\0\1\30\1\0"+
    "\1\30\1\0\1\30\1\0\1\30\6\0\2\30\6\0"+
    "\1\30\7\0\1\30\1\0\1\30\43\0\1\30\17\0"+
    "\2\30\22\0\1\30\2\0\2\30\13\0\1\30\3\0"+
    "\2\30\5\0\3\30\20\0\1\30\16\0\1\30\7\0"+
    "\1\30\36\0\1\30\6\0\1\30\3\0\1\30\3\0"+
    "\1\30\7\0\1\30\31\0\20\30\5\0\3\30\4\0"+
    "\1\30\6\0\1\30\3\0\2\30\2\0\2\30\4\0"+
    "\1\30\5\0\1\30\2\0\1\30\4\0\1\30\1\0"+
    "\1\30\1\0\1\30\140\0\1\36\41\0\1\32\43\0"+
    "\1\35\6\0\1\35\2\0\1\35\3\0\2\35\10\0"+
    "\4\35\1\0\3\35\1\0\1\35\2\0\1\35\2\0"+
    "\1\35\4\0\4\35\1\0\2\35\6\0\1\35\2\0"+
    "\4\35\2\0\3\35\1\0\2\35\1\0\3\35\1\0"+
    "\4\35\1\0\2\35\5\0\4\35\2\0\10\35\4\0"+
    "\1\35\1\0\2\35\4\0\1\35\3\0\3\35\23\0"+
    "\1\35\1\0\2\35\1\0\1\35\1\0\4\35\1\0"+
    "\1\35\1\0\1\35\1\0\2\35\1\0\3\35\1\0"+
    "\2\35\1\0\4\35\1\0\3\35\1\0\17\35\1\0"+
    "\2\35\1\0\21\35\1\0\2\35\1\0\41\35\1\0"+
    "\1\35\1\0\2\35\2\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\3\35\23\0\1\35\1\0\2\35\1\0"+
    "\1\35\1\0\4\35\1\0\1\35\1\0\1\35\1\0"+
    "\2\35\2\0\1\35\2\0\2\35\1\0\4\35\1\0"+
    "\3\35\1\0\17\35\1\0\2\35\1\0\21\35\1\0"+
    "\2\35\1\0\41\35\1\0\1\35\1\0\2\35\2\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\3\35\37\0"+
    "\1\35\17\0\1\35\23\0\1\35\32\0\1\35\41\0"+
    "\1\35\7\0\1\35\31\0\1\35\1\0\2\35\3\0"+
    "\4\35\1\0\1\35\1\0\1\35\1\0\2\35\1\0"+
    "\3\35\1\0\2\35\1\0\4\35\1\0\3\35\1\0"+
    "\10\35\1\0\6\35\1\0\2\35\1\0\21\35\1\0"+
    "\2\35\1\0\41\35\1\0\1\35\1\0\2\35\2\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\3\35\166\0"+
    "\1\42\25\0\1\36\2\42\22\0\1\43\1\0\1\44"+
    "\2\0\1\45\1\0\1\46\4\0\1\47\1\0\1\50"+
    "\1\0\1\51\2\0\1\52\3\0\1\53\2\0\1\54"+
    "\4\0\1\55\3\0\1\56\17\0\1\57\2\0\1\60"+
    "\21\0\1\61\2\0\1\62\61\0\2\30\1\63\1\0"+
    "\1\64\1\0\1\64\1\65\1\0\1\30\2\0\1\64"+
    "\1\0\1\37\1\0\1\30\1\0\1\43\1\0\1\44"+
    "\2\0\1\66\1\0\1\67\4\0\1\47\1\0\1\50"+
    "\1\0\1\51\2\0\1\52\3\0\1\70\2\0\1\71"+
    "\4\0\1\72\3\0\1\73\17\0\1\57\2\0\1\74"+
    "\21\0\1\75\2\0\1\76\61\0\1\30\2\31\2\0"+
    "\2\77\1\100\1\0\1\31\2\0\1\77\1\0\1\37"+
    "\1\0\1\30\6\0\1\101\21\0\1\102\2\0\1\103"+
    "\10\0\1\104\22\0\1\105\21\0\1\106\2\0\1\107"+
    "\41\0\1\110\20\0\1\32\1\0\1\32\3\0\1\65"+
    "\1\0\1\32\10\0\1\43\1\0\1\44\2\0\1\111"+
    "\1\0\1\67\4\0\1\47\1\0\1\50\1\0\1\51"+
    "\2\0\1\52\3\0\1\112\2\0\1\113\4\0\1\72"+
    "\3\0\1\114\17\0\1\57\2\0\1\115\21\0\1\116"+
    "\2\0\1\117\41\0\1\120\17\0\1\30\1\121\1\31"+
    "\1\122\3\0\1\121\1\0\1\121\4\0\1\37\1\0"+
    "\1\30\206\0\2\34\15\0\1\123\21\0\1\124\2\0"+
    "\1\125\10\0\1\126\22\0\1\127\21\0\1\130\2\0"+
    "\1\131\62\0\1\35\7\0\1\35\15\0\1\132\21\0"+
    "\1\133\2\0\1\134\10\0\1\135\22\0\1\136\21\0"+
    "\1\137\2\0\1\140\62\0\1\36\7\0\1\36\10\0"+
    "\1\43\1\0\1\44\2\0\1\141\1\0\1\46\4\0"+
    "\1\47\1\0\1\50\1\0\1\51\2\0\1\52\3\0"+
    "\1\142\2\0\1\143\4\0\1\55\3\0\1\144\17\0"+
    "\1\57\2\0\1\145\21\0\1\146\2\0\1\147\61\0"+
    "\1\30\1\37\1\63\1\0\1\64\1\0\1\64\1\65"+
    "\1\0\1\37\2\0\1\150\1\151\1\37\1\0\1\30"+
    "\6\0\1\152\21\0\1\153\2\0\1\154\10\0\1\155"+
    "\22\0\1\156\21\0\1\157\2\0\1\160\55\0\1\161"+
    "\4\0\1\42\7\0\1\42\5\0\1\162\2\0\1\43"+
    "\1\0\1\44\2\0\1\163\1\0\1\46\4\0\1\47"+
    "\1\0\1\50\1\0\1\51\2\0\1\52\3\0\1\164"+
    "\2\0\1\165\4\0\1\55\3\0\1\166\17\0\1\57"+
    "\2\0\1\167\21\0\1\170\2\0\1\171\61\0\1\30"+
    "\1\41\1\63\1\0\1\64\1\0\1\64\1\65\1\0"+
    "\1\41\2\0\1\64\1\0\1\37\1\0\1\41\7\0"+
    "\1\30\4\0\1\30\11\0\1\30\22\0\1\30\3\0"+
    "\1\30\13\0\1\30\2\0\1\30\10\0\1\30\22\0"+
    "\4\30\35\0\1\30\32\0\1\30\3\0\4\30\1\0"+
    "\1\30\1\0\1\63\2\0\1\30\1\0\2\30\2\0"+
    "\2\30\2\0\3\30\1\0\1\30\1\0\1\30\2\0"+
    "\4\30\1\0\3\30\1\0\1\30\1\0\3\30\1\0"+
    "\2\30\1\0\4\30\1\0\2\30\2\0\10\30\1\0"+
    "\2\30\1\0\10\30\1\63\1\0\7\30\1\0\10\30"+
    "\1\0\6\30\1\0\1\30\1\0\2\30\2\0\1\30"+
    "\1\0\1\30\3\0\3\30\23\0\1\30\26\0\2\30"+
    "\23\0\1\63\1\30\40\0\1\63\13\0\1\30\66\0"+
    "\1\63\11\0\1\30\15\0\4\30\2\0\2\30\14\0"+
    "\4\30\1\0\2\30\11\0\3\30\3\0\1\30\1\0"+
    "\1\30\4\0\3\30\1\0\4\63\1\0\2\30\5\0"+
    "\4\30\2\0\2\30\12\0\1\30\7\0\1\30\45\0"+
    "\1\30\3\0\2\30\12\0\2\30\1\0\3\30\7\0"+
    "\1\30\6\0\2\30\1\0\2\30\6\0\1\30\4\0"+
    "\2\30\2\0\2\30\5\0\3\30\2\0\1\30\3\0"+
    "\2\63\10\0\1\30\16\0\1\30\7\0\1\30\31\0"+
    "\1\30\4\0\1\30\6\0\1\30\3\0\1\30\6\0"+
    "\1\30\5\0\1\30\2\0\2\30\1\0\17\30\2\0"+
    "\1\30\13\0\7\30\2\0\1\30\1\0\1\30\1\0"+
    "\2\30\2\0\1\30\1\0\3\30\2\0\1\30\1\0"+
    "\1\30\1\0\1\30\1\0\1\30\4\0\1\30\1\0"+
    "\2\30\6\0\1\30\7\0\1\30\1\0\1\30\34\0"+
    "\1\30\6\0\1\30\3\0\1\30\3\0\1\30\7\0"+
    "\1\30\31\0\20\30\5\0\3\30\4\0\1\30\6\0"+
    "\1\30\3\0\2\30\2\0\2\30\4\0\5\30\1\0"+
    "\1\30\2\0\1\30\4\0\1\30\1\0\1\30\1\0"+
    "\1\30\135\0\2\30\25\0\4\30\56\0\1\30\15\0"+
    "\2\30\10\0\2\30\1\0\1\30\1\0\1\30\11\0"+
    "\1\30\11\0\2\30\6\0\1\30\2\0\4\30\3\0"+
    "\1\30\2\0\2\30\1\0\3\30\1\0\2\30\1\0"+
    "\1\30\10\0\1\30\1\0\2\30\2\0\2\30\1\0"+
    "\4\30\23\0\1\30\22\0\1\43\1\0\1\44\2\0"+
    "\1\172\1\0\1\46\4\0\1\47\1\0\1\50\1\0"+
    "\1\51\2\0\1\52\3\0\1\173\2\0\1\174\4\0"+
    "\1\55\3\0\1\175\17\0\1\57\2\0\1\176\21\0"+
    "\1\177\2\0\1\200\61\0\1\30\2\63\2\0\2\201"+
    "\1\65\1\0\1\63\2\0\1\201\1\0\1\37\1\0"+
    "\1\30\1\0\1\43\1\0\1\44\2\0\1\202\1\0"+
    "\1\203\4\0\1\47\1\0\1\50\1\0\1\51\2\0"+
    "\1\52\3\0\1\204\2\0\1\205\4\0\1\206\3\0"+
    "\1\207\17\0\1\57\2\0\1\210\21\0\1\211\2\0"+
    "\1\212\61\0\1\30\1\64\7\0\1\64\4\0\1\30"+
    "\1\0\1\30\1\0\1\43\1\0\1\44\2\0\1\213"+
    "\1\0\1\46\4\0\1\47\1\0\1\50\1\0\1\51"+
    "\2\0\1\52\3\0\1\214\2\0\1\215\4\0\1\55"+
    "\3\0\1\216\17\0\1\57\2\0\1\217\21\0\1\220"+
    "\2\0\1\221\41\0\1\120\17\0\1\30\1\65\1\63"+
    "\1\122\3\0\1\65\1\0\1\65\4\0\1\37\1\0"+
    "\1\30\7\0\1\30\4\0\1\30\11\0\1\30\22\0"+
    "\1\30\3\0\1\30\13\0\1\31\2\0\1\31\10\0"+
    "\1\30\22\0\4\31\35\0\1\30\27\0\1\30\26\0"+
    "\2\30\23\0\1\31\1\30\40\0\1\31\13\0\1\31"+
    "\66\0\1\31\11\0\1\31\15\0\4\30\2\0\2\30"+
    "\14\0\3\30\1\31\1\0\2\31\11\0\3\30\3\0"+
    "\1\30\1\0\1\31\4\0\1\31\2\30\1\0\4\31"+
    "\1\0\2\30\5\0\4\31\2\0\1\30\1\31\12\0"+
    "\1\31\7\0\1\30\31\0\1\30\4\0\1\30\6\0"+
    "\1\30\3\0\1\30\6\0\1\30\5\0\1\30\2\0"+
    "\2\30\1\0\17\30\2\0\1\30\13\0\7\30\2\0"+
    "\1\30\1\0\1\30\1\0\2\30\2\0\1\30\1\0"+
    "\3\30\2\0\1\30\1\0\1\30\1\0\1\30\1\0"+
    "\1\30\4\0\1\31\1\0\2\30\6\0\1\30\7\0"+
    "\1\30\1\0\1\30\34\0\1\30\6\0\1\30\3\0"+
    "\1\30\3\0\1\30\7\0\1\30\31\0\20\30\5\0"+
    "\3\30\4\0\1\30\6\0\1\30\3\0\2\30\2\0"+
    "\2\30\4\0\1\30\4\31\1\0\1\30\2\0\1\30"+
    "\4\0\1\30\1\0\1\30\1\0\1\30\135\0\2\31"+
    "\25\0\4\31\56\0\1\31\15\0\2\31\10\0\2\31"+
    "\1\0\1\31\1\0\1\31\11\0\1\31\11\0\2\31"+
    "\6\0\1\31\2\0\4\31\3\0\1\31\2\0\2\31"+
    "\1\0\3\31\1\0\2\31\1\0\1\31\10\0\1\31"+
    "\1\0\2\31\2\0\2\31\1\0\4\31\23\0\1\31"+
    "\27\0\1\222\1\0\1\223\17\0\1\224\2\0\1\225"+
    "\4\0\1\226\3\0\1\227\22\0\1\230\21\0\1\231"+
    "\2\0\1\232\62\0\1\77\1\31\6\0\1\77\10\0"+
    "\1\43\1\0\1\44\2\0\1\233\1\0\1\67\4\0"+
    "\1\47\1\0\1\50\1\0\1\51\2\0\1\52\3\0"+
    "\1\234\2\0\1\235\4\0\1\72\3\0\1\236\17\0"+
    "\1\57\2\0\1\237\21\0\1\240\2\0\1\241\41\0"+
    "\1\120\17\0\1\30\1\100\1\31\1\122\3\0\1\100"+
    "\1\0\1\100\4\0\1\37\1\0\1\30\71\0\1\32"+
    "\2\0\1\32\33\0\4\32\217\0\1\32\100\0\1\32"+
    "\44\0\1\32\1\0\2\32\21\0\1\32\4\0\1\32"+
    "\17\0\4\32\3\0\1\32\12\0\1\32\204\0\1\32"+
    "\223\0\4\32\153\0\2\32\25\0\4\32\56\0\1\32"+
    "\15\0\2\32\10\0\2\32\1\0\1\32\1\0\1\32"+
    "\11\0\1\32\11\0\2\32\6\0\1\32\2\0\4\32"+
    "\3\0\1\32\2\0\2\32\1\0\3\32\1\0\2\32"+
    "\1\0\1\32\10\0\1\32\1\0\2\32\2\0\2\32"+
    "\1\0\4\32\23\0\1\32\200\0\1\32\46\0\1\30"+
    "\4\0\1\30\11\0\1\30\22\0\1\30\3\0\1\30"+
    "\13\0\1\121\2\0\1\121\10\0\1\30\22\0\4\121"+
    "\35\0\1\30\27\0\1\30\26\0\2\30\23\0\1\31"+
    "\1\30\40\0\1\31\13\0\1\121\66\0\1\31\11\0"+
    "\1\121\15\0\4\30\2\0\2\30\14\0\3\30\1\121"+
    "\1\0\2\121\11\0\3\30\3\0\1\30\1\0\1\121"+
    "\4\0\1\121\2\30\1\0\4\31\1\0\2\30\5\0"+
    "\4\121\2\0\1\30\1\121\12\0\1\121\7\0\1\30"+
    "\31\0\1\30\4\0\1\30\6\0\1\30\3\0\1\30"+
    "\6\0\1\30\5\0\1\30\2\0\2\30\1\0\17\30"+
    "\2\0\1\30\13\0\7\30\2\0\1\30\1\0\1\30"+
    "\1\0\2\30\2\0\1\30\1\0\3\30\2\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\0\1\30\4\0\1\121"+
    "\1\0\2\30\6\0\1\30\7\0\1\30\1\0\1\30"+
    "\34\0\1\30\6\0\1\30\3\0\1\30\3\0\1\30"+
    "\7\0\1\30\31\0\20\30\5\0\3\30\4\0\1\30"+
    "\6\0\1\30\3\0\2\30\2\0\2\30\4\0\1\30"+
    "\4\121\1\0\1\30\2\0\1\30\4\0\1\30\1\0"+
    "\1\30\1\0\1\30\135\0\2\121\25\0\4\121\56\0"+
    "\1\121\15\0\2\121\10\0\2\121\1\0\1\121\1\0"+
    "\1\121\11\0\1\121\11\0\2\121\6\0\1\121\2\0"+
    "\4\121\3\0\1\121\2\0\2\121\1\0\3\121\1\0"+
    "\2\121\1\0\1\121\10\0\1\121\1\0\2\121\2\0"+
    "\2\121\1\0\4\121\23\0\1\121\200\0\1\122\45\0"+
    "\1\242\21\0\1\243\2\0\1\244\10\0\1\245\22\0"+
    "\1\246\21\0\1\247\2\0\1\250\41\0\1\120\20\0"+
    "\1\122\1\0\1\122\3\0\1\65\1\0\1\122\100\0"+
    "\1\35\2\0\1\35\33\0\4\35\217\0\1\35\100\0"+
    "\1\35\44\0\1\35\1\0\2\35\21\0\1\35\4\0"+
    "\1\35\17\0\4\35\3\0\1\35\12\0\1\35\204\0"+
    "\1\35\223\0\4\35\153\0\2\35\25\0\4\35\56\0"+
    "\1\35\15\0\2\35\10\0\2\35\1\0\1\35\1\0"+
    "\1\35\11\0\1\35\11\0\2\35\6\0\1\35\2\0"+
    "\4\35\3\0\1\35\2\0\2\35\1\0\3\35\1\0"+
    "\2\35\1\0\1\35\10\0\1\35\1\0\2\35\2\0"+
    "\2\35\1\0\4\35\23\0\1\35\112\0\1\36\2\0"+
    "\1\36\33\0\4\36\217\0\1\36\100\0\1\36\44\0"+
    "\1\36\1\0\2\36\21\0\1\36\4\0\1\36\17\0"+
    "\4\36\3\0\1\36\12\0\1\36\204\0\1\36\223\0"+
    "\4\36\153\0\2\36\25\0\4\36\56\0\1\36\15\0"+
    "\2\36\10\0\2\36\1\0\1\36\1\0\1\36\11\0"+
    "\1\36\11\0\2\36\6\0\1\36\2\0\4\36\3\0"+
    "\1\36\2\0\2\36\1\0\3\36\1\0\2\36\1\0"+
    "\1\36\10\0\1\36\1\0\2\36\2\0\2\36\1\0"+
    "\4\36\23\0\1\36\30\0\1\30\4\0\1\30\11\0"+
    "\1\30\22\0\1\30\3\0\1\30\13\0\1\37\2\0"+
    "\1\37\10\0\1\30\22\0\4\37\35\0\1\30\27\0"+
    "\1\30\26\0\2\30\23\0\1\63\1\30\40\0\1\63"+
    "\13\0\1\37\66\0\1\63\11\0\1\37\15\0\4\30"+
    "\2\0\2\30\14\0\3\30\1\37\1\0\2\37\11\0"+
    "\3\30\3\0\1\30\1\0\1\37\4\0\1\37\2\30"+
    "\1\0\4\63\1\0\2\30\5\0\4\37\2\0\1\30"+
    "\1\37\12\0\1\37\7\0\1\30\31\0\1\30\4\0"+
    "\1\30\6\0\1\30\3\0\1\30\6\0\1\30\5\0"+
    "\1\30\2\0\2\30\1\0\17\30\2\0\1\30\13\0"+
    "\7\30\2\0\1\30\1\0\1\30\1\0\2\30\2\0"+
    "\1\30\1\0\3\30\2\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\0\1\30\4\0\1\37\1\0\2\30\6\0"+
    "\1\30\7\0\1\30\1\0\1\30\34\0\1\30\6\0"+
    "\1\30\3\0\1\30\3\0\1\30\7\0\1\30\31\0"+
    "\20\30\5\0\3\30\4\0\1\30\6\0\1\30\3\0"+
    "\2\30\2\0\2\30\4\0\1\30\4\37\1\0\1\30"+
    "\2\0\1\30\4\0\1\30\1\0\1\30\1\0\1\30"+
    "\135\0\2\37\25\0\4\37\56\0\1\37\15\0\2\37"+
    "\10\0\2\37\1\0\1\37\1\0\1\37\11\0\1\37"+
    "\11\0\2\37\6\0\1\37\2\0\4\37\3\0\1\37"+
    "\2\0\2\37\1\0\3\37\1\0\2\37\1\0\1\37"+
    "\10\0\1\37\1\0\2\37\2\0\2\37\1\0\4\37"+
    "\23\0\1\37\22\0\1\43\1\0\1\44\2\0\1\251"+
    "\1\0\1\46\4\0\1\47\1\0\1\50\1\0\1\51"+
    "\2\0\1\52\3\0\1\252\2\0\1\253\4\0\1\55"+
    "\3\0\1\254\17\0\1\57\2\0\1\255\21\0\1\256"+
    "\2\0\1\257\61\0\1\30\1\150\1\63\4\0\1\65"+
    "\1\0\1\150\4\0\1\37\1\0\1\30\6\0\1\260"+
    "\21\0\1\261\2\0\1\262\10\0\1\263\22\0\1\264"+
    "\21\0\1\265\2\0\1\266\62\0\1\151\7\0\1\151"+
    "\4\0\1\150\73\0\1\42\2\0\1\42\33\0\4\42"+
    "\217\0\1\42\100\0\1\42\44\0\1\42\1\0\2\42"+
    "\21\0\1\42\4\0\1\42\17\0\4\42\3\0\1\42"+
    "\12\0\1\42\204\0\1\42\223\0\4\42\153\0\2\42"+
    "\25\0\4\42\56\0\1\42\15\0\2\42\10\0\2\42"+
    "\1\0\1\42\1\0\1\42\11\0\1\42\11\0\2\42"+
    "\6\0\1\42\2\0\4\42\3\0\1\42\2\0\2\42"+
    "\1\0\3\42\1\0\2\42\1\0\1\42\10\0\1\42"+
    "\1\0\2\42\2\0\2\42\1\0\4\42\23\0\1\42"+
    "\166\0\1\162\26\0\2\162\27\0\1\267\21\0\1\270"+
    "\2\0\1\271\10\0\1\272\22\0\1\273\21\0\1\274"+
    "\2\0\1\275\55\0\1\161\4\0\1\162\7\0\1\162"+
    "\5\0\1\162\10\0\1\30\4\0\1\30\11\0\1\30"+
    "\22\0\1\30\3\0\1\30\13\0\1\41\2\0\1\41"+
    "\10\0\1\30\22\0\4\41\35\0\1\30\27\0\1\30"+
    "\26\0\2\30\23\0\1\63\1\30\40\0\1\63\13\0"+
    "\1\41\66\0\1\63\11\0\1\41\15\0\4\30\2\0"+
    "\2\30\14\0\3\30\1\41\1\0\2\41\11\0\3\30"+
    "\3\0\1\30\1\0\1\41\4\0\1\41\2\30\1\0"+
    "\4\63\1\0\2\30\5\0\4\41\2\0\1\30\1\41"+
    "\12\0\1\41\7\0\1\30\31\0\1\30\4\0\1\30"+
    "\6\0\1\30\3\0\1\30\6\0\1\30\5\0\1\30"+
    "\2\0\2\30\1\0\17\30\2\0\1\30\13\0\7\30"+
    "\2\0\1\30\1\0\1\30\1\0\2\30\2\0\1\30"+
    "\1\0\3\30\2\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\0\1\30\4\0\1\41\1\0\2\30\6\0\1\30"+
    "\7\0\1\30\1\0\1\30\34\0\1\30\6\0\1\30"+
    "\3\0\1\30\3\0\1\30\7\0\1\30\31\0\20\30"+
    "\5\0\3\30\4\0\1\30\6\0\1\30\3\0\2\30"+
    "\2\0\2\30\4\0\1\30\4\41\1\0\1\30\2\0"+
    "\1\30\4\0\1\30\1\0\1\30\1\0\1\30\135\0"+
    "\2\41\25\0\4\41\56\0\1\41\15\0\2\41\10\0"+
    "\2\41\1\0\1\41\1\0\1\41\11\0\1\41\11\0"+
    "\2\41\6\0\1\41\2\0\4\41\3\0\1\41\2\0"+
    "\2\41\1\0\3\41\1\0\2\41\1\0\1\41\10\0"+
    "\1\41\1\0\2\41\2\0\2\41\1\0\4\41\23\0"+
    "\1\41\30\0\1\30\4\0\1\30\11\0\1\30\22\0"+
    "\1\30\3\0\1\30\13\0\1\63\2\0\1\63\10\0"+
    "\1\30\22\0\4\63\35\0\1\30\27\0\1\30\26\0"+
    "\2\30\23\0\1\63\1\30\40\0\1\63\13\0\1\63"+
    "\66\0\1\63\11\0\1\63\15\0\4\30\2\0\2\30"+
    "\14\0\3\30\1\63\1\0\2\63\11\0\3\30\3\0"+
    "\1\30\1\0\1\63\4\0\1\63\2\30\1\0\4\63"+
    "\1\0\2\30\5\0\4\63\2\0\1\30\1\63\12\0"+
    "\1\63\7\0\1\30\31\0\1\30\4\0\1\30\6\0"+
    "\1\30\3\0\1\30\6\0\1\30\5\0\1\30\2\0"+
    "\2\30\1\0\17\30\2\0\1\30\13\0\7\30\2\0"+
    "\1\30\1\0\1\30\1\0\2\30\2\0\1\30\1\0"+
    "\3\30\2\0\1\30\1\0\1\30\1\0\1\30\1\0"+
    "\1\30\4\0\1\63\1\0\2\30\6\0\1\30\7\0"+
    "\1\30\1\0\1\30\34\0\1\30\6\0\1\30\3\0"+
    "\1\30\3\0\1\30\7\0\1\30\31\0\20\30\5\0"+
    "\3\30\4\0\1\30\6\0\1\30\3\0\2\30\2\0"+
    "\2\30\4\0\1\30\4\63\1\0\1\30\2\0\1\30"+
    "\4\0\1\30\1\0\1\30\1\0\1\30\135\0\2\63"+
    "\25\0\4\63\56\0\1\63\15\0\2\63\10\0\2\63"+
    "\1\0\1\63\1\0\1\63\11\0\1\63\11\0\2\63"+
    "\6\0\1\63\2\0\4\63\3\0\1\63\2\0\2\63"+
    "\1\0\3\63\1\0\2\63\1\0\1\63\10\0\1\63"+
    "\1\0\2\63\2\0\2\63\1\0\4\63\23\0\1\63"+
    "\27\0\1\276\1\0\1\277\17\0\1\300\2\0\1\301"+
    "\4\0\1\302\3\0\1\303\22\0\1\304\21\0\1\305"+
    "\2\0\1\306\62\0\1\201\1\63\6\0\1\201\16\0"+
    "\1\30\4\0\1\30\11\0\1\30\22\0\1\30\3\0"+
    "\1\30\13\0\1\64\2\0\1\64\10\0\1\30\22\0"+
    "\4\64\35\0\1\30\32\0\1\30\3\0\4\30\1\0"+
    "\1\30\4\0\1\30\1\0\2\30\2\0\2\30\2\0"+
    "\3\30\1\0\1\30\1\0\1\30\2\0\4\30\1\0"+
    "\3\30\1\0\1\30\1\0\3\30\1\0\2\30\1\0"+
    "\4\30\1\0\2\30\2\0\10\30\1\0\2\30\1\0"+
    "\10\30\2\0\7\30\1\0\10\30\1\0\6\30\1\0"+
    "\1\30\1\0\2\30\2\0\1\30\1\0\1\30\3\0"+
    "\3\30\23\0\1\30\26\0\2\30\24\0\1\30\54\0"+
    "\1\64\100\0\1\64\15\0\4\30\2\0\2\30\14\0"+
    "\3\30\1\64\1\0\2\64\11\0\3\30\3\0\1\30"+
    "\1\0\1\64\4\0\1\64\2\30\6\0\2\30\5\0"+
    "\4\64\2\0\1\30\1\64\12\0\1\64\7\0\1\30"+
    "\45\0\1\30\3\0\2\30\12\0\2\30\1\0\3\30"+
    "\7\0\1\30\6\0\2\30\1\0\2\30\6\0\1\30"+
    "\4\0\2\30\2\0\2\30\5\0\3\30\2\0\1\30"+
    "\15\0\1\30\16\0\1\30\7\0\1\30\31\0\1\30"+
    "\4\0\1\30\6\0\1\30\3\0\1\30\6\0\1\30"+
    "\5\0\1\30\2\0\2\30\1\0\17\30\2\0\1\30"+
    "\13\0\7\30\2\0\1\30\1\0\1\30\1\0\2\30"+
    "\2\0\1\30\1\0\3\30\2\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\0\1\30\4\0\1\64\1\0\2\30"+
    "\6\0\1\30\7\0\1\30\1\0\1\30\34\0\1\30"+
    "\6\0\1\30\3\0\1\30\3\0\1\30\7\0\1\30"+
    "\31\0\20\30\5\0\3\30\4\0\1\30\6\0\1\30"+
    "\3\0\2\30\2\0\2\30\4\0\1\30\4\64\1\0"+
    "\1\30\2\0\1\30\4\0\1\30\1\0\1\30\1\0"+
    "\1\30\135\0\2\64\25\0\4\64\56\0\1\64\15\0"+
    "\2\64\10\0\2\64\1\0\1\64\1\0\1\64\11\0"+
    "\1\64\11\0\2\64\6\0\1\64\2\0\4\64\3\0"+
    "\1\64\2\0\2\64\1\0\3\64\1\0\2\64\1\0"+
    "\1\64\10\0\1\64\1\0\2\64\2\0\2\64\1\0"+
    "\4\64\23\0\1\64\30\0\1\30\4\0\1\30\11\0"+
    "\1\30\22\0\1\30\3\0\1\30\13\0\1\65\2\0"+
    "\1\65\10\0\1\30\22\0\4\65\35\0\1\30\27\0"+
    "\1\30\26\0\2\30\23\0\1\63\1\30\40\0\1\63"+
    "\13\0\1\65\66\0\1\63\11\0\1\65\15\0\4\30"+
    "\2\0\2\30\14\0\3\30\1\65\1\0\2\65\11\0"+
    "\3\30\3\0\1\30\1\0\1\65\4\0\1\65\2\30"+
    "\1\0\4\63\1\0\2\30\5\0\4\65\2\0\1\30"+
    "\1\65\12\0\1\65\7\0\1\30\31\0\1\30\4\0"+
    "\1\30\6\0\1\30\3\0\1\30\6\0\1\30\5\0"+
    "\1\30\2\0\2\30\1\0\17\30\2\0\1\30\13\0"+
    "\7\30\2\0\1\30\1\0\1\30\1\0\2\30\2\0"+
    "\1\30\1\0\3\30\2\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\0\1\30\4\0\1\65\1\0\2\30\6\0"+
    "\1\30\7\0\1\30\1\0\1\30\34\0\1\30\6\0"+
    "\1\30\3\0\1\30\3\0\1\30\7\0\1\30\31\0"+
    "\20\30\5\0\3\30\4\0\1\30\6\0\1\30\3\0"+
    "\2\30\2\0\2\30\4\0\1\30\4\65\1\0\1\30"+
    "\2\0\1\30\4\0\1\30\1\0\1\30\1\0\1\30"+
    "\135\0\2\65\25\0\4\65\56\0\1\65\15\0\2\65"+
    "\10\0\2\65\1\0\1\65\1\0\1\65\11\0\1\65"+
    "\11\0\2\65\6\0\1\65\2\0\4\65\3\0\1\65"+
    "\2\0\2\65\1\0\3\65\1\0\2\65\1\0\1\65"+
    "\10\0\1\65\1\0\2\65\2\0\2\65\1\0\4\65"+
    "\23\0\1\65\112\0\1\77\2\0\1\77\33\0\4\77"+
    "\103\0\1\31\104\0\1\31\147\0\1\31\41\0\1\31"+
    "\13\0\1\77\66\0\1\31\11\0\1\77\44\0\1\77"+
    "\1\0\2\77\21\0\1\77\4\0\1\77\3\0\4\31"+
    "\10\0\4\77\3\0\1\77\12\0\1\77\165\0\2\31"+
    "\234\0\1\77\223\0\4\77\153\0\2\77\25\0\4\77"+
    "\56\0\1\77\15\0\2\77\10\0\2\77\1\0\1\77"+
    "\1\0\1\77\11\0\1\77\11\0\2\77\6\0\1\77"+
    "\2\0\4\77\3\0\1\77\2\0\2\77\1\0\3\77"+
    "\1\0\2\77\1\0\1\77\10\0\1\77\1\0\2\77"+
    "\2\0\2\77\1\0\4\77\23\0\1\77\30\0\1\30"+
    "\4\0\1\30\11\0\1\30\22\0\1\30\3\0\1\30"+
    "\13\0\1\100\2\0\1\100\10\0\1\30\22\0\4\100"+
    "\35\0\1\30\27\0\1\30\26\0\2\30\23\0\1\31"+
    "\1\30\40\0\1\31\13\0\1\100\66\0\1\31\11\0"+
    "\1\100\15\0\4\30\2\0\2\30\14\0\3\30\1\100"+
    "\1\0\2\100\11\0\3\30\3\0\1\30\1\0\1\100"+
    "\4\0\1\100\2\30\1\0\4\31\1\0\2\30\5\0"+
    "\4\100\2\0\1\30\1\100\12\0\1\100\7\0\1\30"+
    "\31\0\1\30\4\0\1\30\6\0\1\30\3\0\1\30"+
    "\6\0\1\30\5\0\1\30\2\0\2\30\1\0\17\30"+
    "\2\0\1\30\13\0\7\30\2\0\1\30\1\0\1\30"+
    "\1\0\2\30\2\0\1\30\1\0\3\30\2\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\0\1\30\4\0\1\100"+
    "\1\0\2\30\6\0\1\30\7\0\1\30\1\0\1\30"+
    "\34\0\1\30\6\0\1\30\3\0\1\30\3\0\1\30"+
    "\7\0\1\30\31\0\20\30\5\0\3\30\4\0\1\30"+
    "\6\0\1\30\3\0\2\30\2\0\2\30\4\0\1\30"+
    "\4\100\1\0\1\30\2\0\1\30\4\0\1\30\1\0"+
    "\1\30\1\0\1\30\135\0\2\100\25\0\4\100\56\0"+
    "\1\100\15\0\2\100\10\0\2\100\1\0\1\100\1\0"+
    "\1\100\11\0\1\100\11\0\2\100\6\0\1\100\2\0"+
    "\4\100\3\0\1\100\2\0\2\100\1\0\3\100\1\0"+
    "\2\100\1\0\1\100\10\0\1\100\1\0\2\100\2\0"+
    "\2\100\1\0\4\100\23\0\1\100\112\0\1\122\2\0"+
    "\1\122\33\0\4\122\217\0\1\122\100\0\1\122\44\0"+
    "\1\122\1\0\2\122\21\0\1\122\4\0\1\122\17\0"+
    "\4\122\3\0\1\122\12\0\1\122\204\0\1\122\223\0"+
    "\4\122\153\0\2\122\25\0\4\122\56\0\1\122\15\0"+
    "\2\122\10\0\2\122\1\0\1\122\1\0\1\122\11\0"+
    "\1\122\11\0\2\122\6\0\1\122\2\0\4\122\3\0"+
    "\1\122\2\0\2\122\1\0\3\122\1\0\2\122\1\0"+
    "\1\122\10\0\1\122\1\0\2\122\2\0\2\122\1\0"+
    "\4\122\23\0\1\122\30\0\1\30\4\0\1\30\11\0"+
    "\1\30\22\0\1\30\3\0\1\30\13\0\1\150\2\0"+
    "\1\150\10\0\1\30\22\0\4\150\35\0\1\30\27\0"+
    "\1\30\26\0\2\30\23\0\1\63\1\30\40\0\1\63"+
    "\13\0\1\150\66\0\1\63\11\0\1\150\15\0\4\30"+
    "\2\0\2\30\14\0\3\30\1\150\1\0\2\150\11\0"+
    "\3\30\3\0\1\30\1\0\1\150\4\0\1\150\2\30"+
    "\1\0\4\63\1\0\2\30\5\0\4\150\2\0\1\30"+
    "\1\150\12\0\1\150\7\0\1\30\31\0\1\30\4\0"+
    "\1\30\6\0\1\30\3\0\1\30\6\0\1\30\5\0"+
    "\1\30\2\0\2\30\1\0\17\30\2\0\1\30\13\0"+
    "\7\30\2\0\1\30\1\0\1\30\1\0\2\30\2\0"+
    "\1\30\1\0\3\30\2\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\0\1\30\4\0\1\150\1\0\2\30\6\0"+
    "\1\30\7\0\1\30\1\0\1\30\34\0\1\30\6\0"+
    "\1\30\3\0\1\30\3\0\1\30\7\0\1\30\31\0"+
    "\20\30\5\0\3\30\4\0\1\30\6\0\1\30\3\0"+
    "\2\30\2\0\2\30\4\0\1\30\4\150\1\0\1\30"+
    "\2\0\1\30\4\0\1\30\1\0\1\30\1\0\1\30"+
    "\135\0\2\150\25\0\4\150\56\0\1\150\15\0\2\150"+
    "\10\0\2\150\1\0\1\150\1\0\1\150\11\0\1\150"+
    "\11\0\2\150\6\0\1\150\2\0\4\150\3\0\1\150"+
    "\2\0\2\150\1\0\3\150\1\0\2\150\1\0\1\150"+
    "\10\0\1\150\1\0\2\150\2\0\2\150\1\0\4\150"+
    "\23\0\1\150\112\0\1\151\2\0\1\151\33\0\4\151"+
    "\217\0\1\151\100\0\1\151\44\0\1\151\1\0\2\151"+
    "\21\0\1\151\4\0\1\151\17\0\4\151\3\0\1\151"+
    "\12\0\1\151\204\0\1\151\223\0\4\151\153\0\2\151"+
    "\25\0\4\151\56\0\1\151\15\0\2\151\10\0\2\151"+
    "\1\0\1\151\1\0\1\151\11\0\1\151\11\0\2\151"+
    "\6\0\1\151\2\0\4\151\3\0\1\151\2\0\2\151"+
    "\1\0\3\151\1\0\2\151\1\0\1\151\10\0\1\151"+
    "\1\0\2\151\2\0\2\151\1\0\4\151\23\0\1\151"+
    "\112\0\1\162\2\0\1\162\33\0\4\162\217\0\1\162"+
    "\100\0\1\162\44\0\1\162\1\0\2\162\21\0\1\162"+
    "\4\0\1\162\17\0\4\162\3\0\1\162\12\0\1\162"+
    "\204\0\1\162\223\0\4\162\153\0\2\162\25\0\4\162"+
    "\56\0\1\162\15\0\2\162\10\0\2\162\1\0\1\162"+
    "\1\0\1\162\11\0\1\162\11\0\2\162\6\0\1\162"+
    "\2\0\4\162\3\0\1\162\2\0\2\162\1\0\3\162"+
    "\1\0\2\162\1\0\1\162\10\0\1\162\1\0\2\162"+
    "\2\0\2\162\1\0\4\162\23\0\1\162\112\0\1\201"+
    "\2\0\1\201\33\0\4\201\103\0\1\63\104\0\1\63"+
    "\147\0\1\63\41\0\1\63\13\0\1\201\66\0\1\63"+
    "\11\0\1\201\44\0\1\201\1\0\2\201\21\0\1\201"+
    "\4\0\1\201\3\0\4\63\10\0\4\201\3\0\1\201"+
    "\12\0\1\201\165\0\2\63\234\0\1\201\223\0\4\201"+
    "\153\0\2\201\25\0\4\201\56\0\1\201\15\0\2\201"+
    "\10\0\2\201\1\0\1\201\1\0\1\201\11\0\1\201"+
    "\11\0\2\201\6\0\1\201\2\0\4\201\3\0\1\201"+
    "\2\0\2\201\1\0\3\201\1\0\2\201\1\0\1\201"+
    "\10\0\1\201\1\0\2\201\2\0\2\201\1\0\4\201"+
    "\23\0\1\201\21\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[26741];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\37\1\21\0\1\1\1\0\1\1\12\0"+
    "\1\1\21\0\1\1\25\0\1\1\11\0\1\1\124\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[198];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
  /** Alphanumeric sequences */
  public static final int WORD_TYPE = StandardAnalyzer.TokenType.ALPHANUM.value;
  
  /** Numbers */
  public static final int NUMERIC_TYPE = StandardAnalyzer.TokenType.NUM.value;
  
  /**
   * Chars in class \p{Line_Break = Complex_Context} are from South East Asian
   * scripts (Thai, Lao, Myanmar, Khmer, etc.).  Sequences of these are kept 
   * together as as a single token rather than broken up, because the logic
   * required to break them at word boundaries is too complex for UAX#29.
   * <p>
   * See Unicode Line Breaking Algorithm: http://www.unicode.org/reports/tr14/#SA
   */
  public static final int SOUTH_EAST_ASIAN_TYPE = StandardAnalyzer.TokenType.SOUTHEAST_ASIAN.value;
  
  public static final int IDEOGRAPHIC_TYPE = StandardAnalyzer.TokenType.IDEOGRAPHIC.value;
  
  public static final int HIRAGANA_TYPE = StandardAnalyzer.TokenType.HIRAGANA.value;
  
  public static final int KATAKANA_TYPE = StandardAnalyzer.TokenType.KATAKANA.value;
  
  public static final int HANGUL_TYPE = StandardAnalyzer.TokenType.HANGUL.value;

  public final int yychar()
  {
    return yychar;
  }

  public String getText()
  {
    return String.valueOf(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }

  public char[] getArray()
  {
    return Arrays.copyOfRange(zzBuffer, zzStartRead, zzMarkedPos);
  }

  public byte[] getBytes()
  {
    return getText().getBytes();
  }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public StandardTokenizerImpl(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 3474) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;           
    int totalRead = 0;
    while (totalRead < requested) {
      int numRead = zzReader.read(zzBuffer, zzEndRead + totalRead, requested - totalRead);
      if (numRead == -1) {
        break;
      }
      totalRead += numRead;
    }

    if (totalRead > 0) {
      zzEndRead += totalRead;
      if (totalRead == requested) { /* possibly more input available */
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      return false;
    }

    // totalRead = 0: End of stream
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int getNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { /* Break so we don't hit fall-through warning: */ break; /* Not numeric, word, ideographic, hiragana, or SE Asian -- ignore it. */
          }
        case 9: break;
        case 2: 
          { return WORD_TYPE;
          }
        case 10: break;
        case 3: 
          { return NUMERIC_TYPE;
          }
        case 11: break;
        case 4: 
          { return KATAKANA_TYPE;
          }
        case 12: break;
        case 5: 
          { return SOUTH_EAST_ASIAN_TYPE;
          }
        case 13: break;
        case 6: 
          { return IDEOGRAPHIC_TYPE;
          }
        case 14: break;
        case 7: 
          { return HIRAGANA_TYPE;
          }
        case 15: break;
        case 8: 
          { return HANGUL_TYPE;
          }
        case 16: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return StandardAnalyzer.TokenType.EOF.value;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
