/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import com.google.common.base.Stopwatch;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventNotifier;
import org.apache.cassandra.utils.progress.ProgressListener;
import org.slf4j.helpers.MessageFormatter;

public abstract class TraceState
implements ProgressEventNotifier {
    public final UUID sessionId;
    public final InetAddress coordinator;
    public final Stopwatch watch;
    public final ByteBuffer sessionIdBytes;
    public final Tracing.TraceType traceType;
    public final int ttl;
    private boolean notify;
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private String tag;
    private volatile Status status;
    private final AtomicInteger references = new AtomicInteger(1);

    protected TraceState(InetAddress coordinator, UUID sessionId, Tracing.TraceType traceType) {
        assert (coordinator != null);
        assert (sessionId != null);
        this.coordinator = coordinator;
        this.sessionId = sessionId;
        this.sessionIdBytes = ByteBufferUtil.bytes(sessionId);
        this.traceType = traceType;
        this.ttl = traceType.getTTL();
        this.watch = Stopwatch.createStarted();
        this.status = Status.IDLE;
    }

    public void enableActivityNotification(String tag) {
        assert (this.traceType == Tracing.TraceType.REPAIR);
        this.notify = true;
        this.tag = tag;
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        assert (this.traceType == Tracing.TraceType.REPAIR);
        this.listeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        assert (this.traceType == Tracing.TraceType.REPAIR);
        this.listeners.remove(listener);
    }

    public int elapsed() {
        long elapsed = this.watch.elapsed(TimeUnit.MICROSECONDS);
        return elapsed < Integer.MAX_VALUE ? (int)elapsed : Integer.MAX_VALUE;
    }

    public synchronized void stop() {
        this.waitForPendingEvents();
        this.status = Status.STOPPED;
        this.notifyAll();
    }

    public synchronized Status waitActivity(long timeout) {
        if (this.status == Status.IDLE) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
        }
        if (this.status == Status.ACTIVE) {
            this.status = Status.IDLE;
            return Status.ACTIVE;
        }
        return this.status;
    }

    protected synchronized void notifyActivity() {
        this.status = Status.ACTIVE;
        this.notifyAll();
    }

    public void trace(String format, Object arg) {
        this.trace(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void trace(String format, Object[] args) {
        this.trace(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void trace(String message) {
        if (this.notify) {
            this.notifyActivity();
        }
        this.traceImpl(message);
        for (ProgressListener listener : this.listeners) {
            listener.progress(this.tag, ProgressEvent.createNotification(message));
        }
    }

    protected abstract void traceImpl(String var1);

    protected abstract void waitForPendingEvents();

    public boolean acquireReference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public int releaseReference() {
        this.waitForPendingEvents();
        return this.references.decrementAndGet();
    }

    public static enum Status {
        IDLE,
        ACTIVE,
        STOPPED;

    }
}

