/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.MultiColumnRelation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.view.ViewBuilder;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class View {
    private static final Logger logger = LoggerFactory.getLogger(View.class);
    public final String name;
    private volatile ViewDefinition definition;
    private final ColumnFamilyStore baseCfs;
    public volatile List<ColumnDefinition> baseNonPKColumnsInViewPK;
    private final boolean includeAllColumns;
    private ViewBuilder builder;
    private final SelectStatement.RawStatement rawSelect;
    private SelectStatement select;
    private ReadQuery query;

    public View(ViewDefinition definition, ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
        this.name = definition.viewName;
        this.includeAllColumns = definition.includeAllColumns;
        this.rawSelect = definition.select;
        this.updateDefinition(definition);
    }

    public ViewDefinition getDefinition() {
        return this.definition;
    }

    public void updateDefinition(ViewDefinition definition) {
        this.definition = definition;
        ArrayList<ColumnDefinition> nonPKDefPartOfViewPK = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition baseColumn : this.baseCfs.metadata.allColumns()) {
            ColumnDefinition viewColumn = this.getViewColumn(baseColumn);
            if (viewColumn == null || baseColumn.isPrimaryKeyColumn() || !viewColumn.isPrimaryKeyColumn()) continue;
            nonPKDefPartOfViewPK.add(baseColumn);
        }
        this.baseNonPKColumnsInViewPK = nonPKDefPartOfViewPK;
    }

    public ColumnDefinition getViewColumn(ColumnDefinition baseColumn) {
        return this.definition.metadata.getColumnDefinition(baseColumn.name);
    }

    public ColumnDefinition getBaseColumn(ColumnDefinition viewColumn) {
        ColumnDefinition baseColumn = this.baseCfs.metadata.getColumnDefinition(viewColumn.name);
        assert (baseColumn != null);
        return baseColumn;
    }

    public boolean mayBeAffectedBy(DecoratedKey partitionKey, Row update) {
        if (!this.getReadQuery().selectsClustering(partitionKey, update.clustering())) {
            return false;
        }
        if (this.includeAllColumns || !update.deletion().isLive() || !update.primaryKeyLivenessInfo().isEmpty()) {
            return true;
        }
        for (ColumnData data : update) {
            if (this.definition.metadata.getColumnDefinition(data.column().name) == null) continue;
            return true;
        }
        return false;
    }

    public boolean matchesViewFilter(DecoratedKey partitionKey, Row baseRow, int nowInSec) {
        return this.getReadQuery().selectsClustering(partitionKey, baseRow.clustering()) && this.getSelectStatement().rowFilterForInternalCalls().isSatisfiedBy(this.baseCfs.metadata, partitionKey, baseRow, nowInSec);
    }

    public SelectStatement getSelectStatement() {
        if (this.select == null) {
            ClientState state = ClientState.forInternalCalls();
            state.setKeyspace(this.baseCfs.keyspace.getName());
            this.rawSelect.prepareKeyspace(state);
            ParsedStatement.Prepared prepared = this.rawSelect.prepare(true);
            this.select = (SelectStatement)prepared.statement;
        }
        return this.select;
    }

    public ReadQuery getReadQuery() {
        if (this.query == null) {
            this.query = this.getSelectStatement().getQuery(QueryOptions.forInternalCalls(Collections.emptyList()), FBUtilities.nowInSeconds());
        }
        return this.query;
    }

    public synchronized void build() {
        if (this.builder != null) {
            this.builder.stop();
            this.builder = null;
        }
        this.builder = new ViewBuilder(this.baseCfs, this);
        CompactionManager.instance.submitViewBuilder(this.builder);
    }

    @Nullable
    public static CFMetaData findBaseTable(String keyspace, String viewName) {
        ViewDefinition view = Schema.instance.getView(keyspace, viewName);
        return view == null ? null : Schema.instance.getCFMetaData(view.baseTableId);
    }

    public static Iterable<ViewDefinition> findAll(String keyspace, String baseTable) {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(keyspace);
        UUID baseId = Schema.instance.getId(keyspace, baseTable);
        return Iterables.filter((Iterable)ksm.views, view -> view.baseTableId.equals(baseId));
    }

    public static String buildSelectStatement(String cfName, Collection<ColumnDefinition> includedColumns, String whereClause) {
        StringBuilder rawSelect = new StringBuilder("SELECT ");
        if (includedColumns == null || includedColumns.isEmpty()) {
            rawSelect.append("*");
        } else {
            rawSelect.append(includedColumns.stream().map(id -> id.name.toCQLString()).collect(Collectors.joining(", ")));
        }
        rawSelect.append(" FROM \"").append(cfName).append("\" WHERE ").append(whereClause).append(" ALLOW FILTERING");
        return rawSelect.toString();
    }

    public static String relationsToWhereClause(List<Relation> whereClause) {
        ArrayList<String> expressions = new ArrayList<String>(whereClause.size());
        for (Relation rel : whereClause) {
            StringBuilder sb = new StringBuilder();
            if (rel.isMultiColumn()) {
                sb.append(((MultiColumnRelation)rel).getEntities().stream().map(Object::toString).collect(Collectors.joining(", ", "(", ")")));
            } else {
                sb.append(((SingleColumnRelation)rel).getEntity());
            }
            sb.append(" ").append((Object)rel.operator()).append(" ");
            if (rel.isIN()) {
                sb.append(rel.getInValues().stream().map(Term.Raw::getText).collect(Collectors.joining(", ", "(", ")")));
            } else {
                sb.append(rel.getValue().getText());
            }
            expressions.add(sb.toString());
        }
        return expressions.stream().collect(Collectors.joining(" AND "));
    }
}

