/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.AbstractReaderFileProxy;
import org.apache.cassandra.io.util.BufferManagingRebufferer;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ChunkReader;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.ReaderFileProxy;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.RebuffererFactory;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.utils.concurrent.Ref;

public class CompressedSegmentedFile
extends SegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;

    public CompressedSegmentedFile(ChannelProxy channel, CompressionMetadata metadata, Config.DiskAccessMode mode) {
        this(channel, metadata, mode == Config.DiskAccessMode.mmap ? MmappedRegions.map(channel, metadata) : null);
    }

    public CompressedSegmentedFile(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions) {
        this(channel, metadata, regions, CompressedSegmentedFile.createRebufferer(channel, metadata, regions));
    }

    private static RebuffererFactory createRebufferer(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions) {
        return ChunkCache.maybeWrap(CompressedSegmentedFile.chunkReader(channel, metadata, regions));
    }

    public static ChunkReader chunkReader(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions) {
        return regions != null ? new Mmap(channel, metadata, regions) : new Standard(channel, metadata);
    }

    public CompressedSegmentedFile(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions, RebuffererFactory rebufferer) {
        super(new Cleanup(channel, metadata, regions, rebufferer), channel, rebufferer, metadata.compressedFileLength);
        this.metadata = metadata;
    }

    private CompressedSegmentedFile(CompressedSegmentedFile copy) {
        super(copy);
        this.metadata = copy.metadata;
    }

    @Override
    public ChannelProxy channel() {
        return this.channel;
    }

    @Override
    public CompressedSegmentedFile sharedCopy() {
        return new CompressedSegmentedFile(this);
    }

    @Override
    public void addTo(Ref.IdentityCollection identities) {
        super.addTo(identities);
        this.metadata.addTo(identities);
    }

    @Override
    public void dropPageCache(long before) {
        if (before >= this.metadata.dataLength) {
            super.dropPageCache(0L);
        }
        super.dropPageCache(this.metadata.chunkFor((long)before).offset);
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public long dataLength() {
        return this.metadata.dataLength;
    }

    static class Mmap
    extends CompressedChunkReader {
        protected final MmappedRegions regions;

        public Mmap(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions) {
            super(channel, metadata);
            this.regions = regions;
        }

        @Override
        public void readChunk(long position, ByteBuffer uncompressed) {
            try {
                assert ((position & (long)(-uncompressed.capacity())) == position);
                assert (position <= this.fileLength);
                CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
                MmappedRegions.Region region = this.regions.floor(chunk.offset);
                long segmentOffset = region.offset();
                int chunkOffset = Ints.checkedCast((long)(chunk.offset - segmentOffset));
                ByteBuffer compressedChunk = region.buffer();
                compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
                uncompressed.clear();
                try {
                    this.metadata.compressor().uncompress(compressedChunk, uncompressed);
                }
                catch (IOException e) {
                    throw new CorruptBlockException(this.channel.filePath(), chunk);
                }
                finally {
                    uncompressed.flip();
                }
                if (this.getCrcCheckChance() > ThreadLocalRandom.current().nextDouble()) {
                    compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
                    int checksum = (int)this.metadata.checksumType.of(compressedChunk);
                    compressedChunk.limit(compressedChunk.capacity());
                    if (compressedChunk.getInt() != checksum) {
                        throw new CorruptBlockException(this.channel.filePath(), chunk);
                    }
                }
            }
            catch (CorruptBlockException e) {
                throw new CorruptSSTableException((Exception)e, this.channel.filePath());
            }
        }

        @Override
        public void close() {
            this.regions.closeQuietly();
            super.close();
        }
    }

    static class Standard
    extends CompressedChunkReader {
        private final ThreadLocal<ByteBuffer> compressedHolder = ThreadLocal.withInitial(this::allocateBuffer);

        public Standard(ChannelProxy channel, CompressionMetadata metadata) {
            super(channel, metadata);
        }

        public ByteBuffer allocateBuffer() {
            return this.allocateBuffer(this.metadata.compressor().initialCompressedBufferLength(this.metadata.chunkLength()));
        }

        public ByteBuffer allocateBuffer(int size) {
            return this.metadata.compressor().preferredBufferType().allocate(size);
        }

        @Override
        public void readChunk(long position, ByteBuffer uncompressed) {
            try {
                assert ((position & (long)(-uncompressed.capacity())) == position);
                assert (position <= this.fileLength);
                CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
                ByteBuffer compressed = this.compressedHolder.get();
                if (compressed.capacity() < chunk.length) {
                    compressed = this.allocateBuffer(chunk.length);
                    this.compressedHolder.set(compressed);
                } else {
                    compressed.clear();
                }
                compressed.limit(chunk.length);
                if (this.channel.read(compressed, chunk.offset) != chunk.length) {
                    throw new CorruptBlockException(this.channel.filePath(), chunk);
                }
                compressed.flip();
                uncompressed.clear();
                try {
                    this.metadata.compressor().uncompress(compressed, uncompressed);
                }
                catch (IOException e) {
                    throw new CorruptBlockException(this.channel.filePath(), chunk);
                }
                finally {
                    uncompressed.flip();
                }
                if (this.getCrcCheckChance() > ThreadLocalRandom.current().nextDouble()) {
                    compressed.rewind();
                    int checksum = (int)this.metadata.checksumType.of(compressed);
                    compressed.clear().limit(4);
                    if (this.channel.read(compressed, chunk.offset + (long)chunk.length) != 4 || compressed.getInt(0) != checksum) {
                        throw new CorruptBlockException(this.channel.filePath(), chunk);
                    }
                }
            }
            catch (CorruptBlockException e) {
                throw new CorruptSSTableException((Exception)e, this.channel.filePath());
            }
        }
    }

    @VisibleForTesting
    public static abstract class CompressedChunkReader
    extends AbstractReaderFileProxy
    implements ChunkReader {
        final CompressionMetadata metadata;

        public CompressedChunkReader(ChannelProxy channel, CompressionMetadata metadata) {
            super(channel, metadata.dataLength);
            this.metadata = metadata;
            assert (Integer.bitCount(metadata.chunkLength()) == 1);
        }

        @Override
        @VisibleForTesting
        public double getCrcCheckChance() {
            return this.metadata.parameters.getCrcCheckChance();
        }

        @Override
        public String toString() {
            return String.format("CompressedChunkReader.%s(%s - %s, chunk length %d, data length %d)", this.getClass().getSimpleName(), this.channel.filePath(), this.metadata.compressor().getClass().getSimpleName(), this.metadata.chunkLength(), this.metadata.dataLength);
        }

        @Override
        public int chunkSize() {
            return this.metadata.chunkLength();
        }

        @Override
        public boolean alignmentRequired() {
            return true;
        }

        @Override
        public BufferType preferredBufferType() {
            return this.metadata.compressor().preferredBufferType();
        }

        @Override
        public Rebufferer instantiateRebufferer() {
            return BufferManagingRebufferer.on(this);
        }
    }

    public static class Builder
    extends SegmentedFile.Builder {
        final CompressedSequentialWriter writer;
        final Config.DiskAccessMode mode;

        public Builder(CompressedSequentialWriter writer) {
            this.writer = writer;
            this.mode = DatabaseDescriptor.getDiskAccessMode();
        }

        protected CompressionMetadata metadata(String path, long overrideLength) {
            if (this.writer == null) {
                return CompressionMetadata.create(path);
            }
            return this.writer.open(overrideLength);
        }

        @Override
        public SegmentedFile complete(ChannelProxy channel, int bufferSize, long overrideLength) {
            return new CompressedSegmentedFile(channel, this.metadata(channel.filePath(), overrideLength), this.mode);
        }
    }

    private static final class Cleanup
    extends SegmentedFile.Cleanup {
        final CompressionMetadata metadata;

        protected Cleanup(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions, ReaderFileProxy rebufferer) {
            super(channel, rebufferer);
            this.metadata = metadata;
        }

        @Override
        public void tidy() {
            if (ChunkCache.instance != null) {
                ChunkCache.instance.invalidateFile(this.name());
            }
            this.metadata.close();
            super.tidy();
        }
    }
}

