/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.utils.Pair;

public class CQL3CasRequest
implements CASRequest {
    public final CFMetaData cfm;
    public final DecoratedKey key;
    public final boolean isBatch;
    private final PartitionColumns conditionColumns;
    private final boolean updatesRegularRows;
    private final boolean updatesStaticRow;
    private boolean hasExists;
    private final SortedMap<Clustering, RowCondition> conditions;
    private final List<RowUpdate> updates = new ArrayList<RowUpdate>();

    public CQL3CasRequest(CFMetaData cfm, DecoratedKey key, boolean isBatch, PartitionColumns conditionColumns, boolean updatesRegularRows, boolean updatesStaticRow) {
        this.cfm = cfm;
        this.key = key;
        this.conditions = new TreeMap<Clusterable, RowCondition>(cfm.comparator);
        this.isBatch = isBatch;
        this.conditionColumns = conditionColumns;
        this.updatesRegularRows = updatesRegularRows;
        this.updatesStaticRow = updatesStaticRow;
    }

    public void addRowUpdate(Clustering clustering, ModificationStatement stmt, QueryOptions options, long timestamp) {
        this.updates.add(new RowUpdate(clustering, stmt, options, timestamp));
    }

    public void addNotExist(Clustering clustering) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(clustering, new NotExistCondition(clustering));
        if (previous != null && !(previous instanceof NotExistCondition)) {
            if (previous instanceof ExistCondition) {
                throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
            }
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
        this.hasExists = true;
    }

    public void addExist(Clustering clustering) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(clustering, new ExistCondition(clustering));
        if (previous instanceof NotExistCondition) {
            throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
        }
        this.hasExists = true;
    }

    public void addConditions(Clustering clustering, Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
        RowCondition condition = (RowCondition)this.conditions.get(clustering);
        if (condition == null) {
            condition = new ColumnsConditions(clustering);
            this.conditions.put(clustering, condition);
        } else if (!(condition instanceof ColumnsConditions)) {
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
        ((ColumnsConditions)condition).addConditions(conds, options);
    }

    private PartitionColumns columnsToRead() {
        if (this.hasExists) {
            PartitionColumns allColumns = this.cfm.partitionColumns();
            Columns statics = this.updatesStaticRow ? allColumns.statics : Columns.NONE;
            Columns regulars = this.updatesRegularRows ? allColumns.regulars : Columns.NONE;
            return new PartitionColumns(statics, regulars);
        }
        return this.conditionColumns;
    }

    @Override
    public SinglePartitionReadCommand readCommand(int nowInSec) {
        assert (!this.conditions.isEmpty());
        Slices.Builder builder = new Slices.Builder(this.cfm.comparator, this.conditions.size());
        for (Clustering clustering : this.conditions.keySet()) {
            if (clustering == Clustering.STATIC_CLUSTERING) continue;
            builder.add(Slice.make(clustering));
        }
        ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(builder.build(), false);
        return SinglePartitionReadCommand.create(this.cfm, nowInSec, this.key, ColumnFilter.selection(this.columnsToRead()), filter);
    }

    @Override
    public boolean appliesTo(FilteredPartition current) throws InvalidRequestException {
        for (RowCondition condition : this.conditions.values()) {
            if (condition.appliesTo(current)) continue;
            return false;
        }
        return true;
    }

    private PartitionColumns updatedColumns() {
        PartitionColumns.Builder builder = PartitionColumns.builder();
        for (RowUpdate upd : this.updates) {
            builder.addAll(upd.stmt.updatedColumns());
        }
        return builder.build();
    }

    @Override
    public PartitionUpdate makeUpdates(FilteredPartition current) throws InvalidRequestException {
        PartitionUpdate update = new PartitionUpdate(this.cfm, this.key, this.updatedColumns(), this.conditions.size());
        for (RowUpdate upd : this.updates) {
            upd.applyUpdates(current, update);
        }
        Keyspace.openAndGetStore((CFMetaData)this.cfm).indexManager.validate(update);
        return update;
    }

    private static class ColumnsConditions
    extends RowCondition {
        private final Multimap<Pair<ColumnIdentifier, ByteBuffer>, ColumnCondition.Bound> conditions = HashMultimap.create();

        private ColumnsConditions(Clustering clustering) {
            super(clustering);
        }

        public void addConditions(Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
            for (ColumnCondition condition : conds) {
                ColumnCondition.Bound current = condition.bind(options);
                this.conditions.put(Pair.create(condition.column.name, current.getCollectionElementValue()), (Object)current);
            }
        }

        @Override
        public boolean appliesTo(FilteredPartition current) throws InvalidRequestException {
            if (current == null) {
                return this.conditions.isEmpty();
            }
            for (ColumnCondition.Bound condition : this.conditions.values()) {
                if (condition.appliesTo(current.getRow(this.clustering))) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExistCondition
    extends RowCondition {
        private ExistCondition(Clustering clustering) {
            super(clustering);
        }

        @Override
        public boolean appliesTo(FilteredPartition current) {
            return current != null && current.getRow(this.clustering) != null;
        }
    }

    private static class NotExistCondition
    extends RowCondition {
        private NotExistCondition(Clustering clustering) {
            super(clustering);
        }

        @Override
        public boolean appliesTo(FilteredPartition current) {
            return current == null || current.getRow(this.clustering) == null;
        }
    }

    private static abstract class RowCondition {
        public final Clustering clustering;

        protected RowCondition(Clustering clustering) {
            this.clustering = clustering;
        }

        public abstract boolean appliesTo(FilteredPartition var1) throws InvalidRequestException;
    }

    private class RowUpdate {
        private final Clustering clustering;
        private final ModificationStatement stmt;
        private final QueryOptions options;
        private final long timestamp;

        private RowUpdate(Clustering clustering, ModificationStatement stmt, QueryOptions options, long timestamp) {
            this.clustering = clustering;
            this.stmt = stmt;
            this.options = options;
            this.timestamp = timestamp;
        }

        public void applyUpdates(FilteredPartition current, PartitionUpdate updates) throws InvalidRequestException {
            Map<DecoratedKey, Partition> map = this.stmt.requiresRead() ? Collections.singletonMap(CQL3CasRequest.this.key, current) : null;
            UpdateParameters params = new UpdateParameters(CQL3CasRequest.this.cfm, updates.columns(), this.options, this.timestamp, this.stmt.getTimeToLive(this.options), map);
            this.stmt.addUpdateForKey(updates, this.clustering, params);
        }
    }
}

