/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.ConfigurationException;

public final class Util {
    private Util() {
    }

    public static void initDatabaseDescriptor() {
        try {
            DatabaseDescriptor.forceStaticInitialization();
        }
        catch (ExceptionInInitializerError e) {
            Throwable cause = e.getCause();
            boolean logStackTrace = !(cause instanceof ConfigurationException) || ((ConfigurationException)cause).logStackTrace;
            System.out.println("Exception (" + cause.getClass().getName() + ") encountered during startup: " + cause.getMessage());
            if (logStackTrace) {
                cause.printStackTrace();
                System.exit(3);
            }
            System.err.println(cause.getMessage());
            System.exit(3);
        }
    }
}

