/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.StreamingRepairTask;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.repair.messages.AnticompactionRequest;
import org.apache.cassandra.repair.messages.CleanupMessage;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.service.ActiveRepairService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairMessageVerbHandler
implements IVerbHandler<RepairMessage> {
    private static final Logger logger = LoggerFactory.getLogger(RepairMessageVerbHandler.class);

    @Override
    public void doVerb(final MessageIn<RepairMessage> message, final int id) {
        RepairJobDesc desc = ((RepairMessage)message.payload).desc;
        try {
            switch (((RepairMessage)message.payload).messageType) {
                case PREPARE_MESSAGE: {
                    PrepareMessage prepareMessage = (PrepareMessage)message.payload;
                    logger.debug("Preparing, {}", (Object)prepareMessage);
                    ArrayList<ColumnFamilyStore> columnFamilyStores = new ArrayList<ColumnFamilyStore>(prepareMessage.cfIds.size());
                    for (UUID cfId : prepareMessage.cfIds) {
                        ColumnFamilyStore columnFamilyStore = ColumnFamilyStore.getIfExists(cfId);
                        if (columnFamilyStore == null) {
                            this.logErrorAndSendFailureResponse(String.format("Table with id %s was dropped during prepare phase of repair", cfId.toString()), message.from, id);
                            return;
                        }
                        columnFamilyStores.add(columnFamilyStore);
                    }
                    ActiveRepairService.instance.registerParentRepairSession(prepareMessage.parentRepairSession, columnFamilyStores, prepareMessage.ranges, prepareMessage.isIncremental, prepareMessage.timestamp, prepareMessage.isGlobal);
                    MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
                    break;
                }
                case SNAPSHOT: {
                    logger.debug("Snapshotting {}", (Object)desc);
                    ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(desc.keyspace, desc.columnFamily);
                    if (cfs == null) {
                        this.logErrorAndSendFailureResponse(String.format("Table %s.%s was dropped during snapshot phase of repair", desc.keyspace, desc.columnFamily), message.from, id);
                        return;
                    }
                    final Collection<Range<Token>> repairingRange = desc.ranges;
                    Set<SSTableReader> snapshottedSSSTables = cfs.snapshot(desc.sessionId.toString(), new Predicate<SSTableReader>(){

                        public boolean apply(SSTableReader sstable) {
                            return sstable != null && !sstable.metadata.isIndex() && ((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(repairingRange);
                        }
                    }, true, false);
                    if (ActiveRepairService.instance.getParentRepairSession((UUID)desc.parentSessionId).isGlobal) {
                        Set<SSTableReader> currentlyRepairing = ActiveRepairService.instance.currentlyRepairing(cfs.metadata.cfId, desc.parentSessionId);
                        if (!Sets.intersection(currentlyRepairing, snapshottedSSSTables).isEmpty()) {
                            cfs.clearSnapshot(desc.sessionId.toString());
                            this.logErrorAndSendFailureResponse("Cannot start multiple repair sessions over the same sstables", message.from, id);
                            return;
                        }
                        ActiveRepairService.instance.getParentRepairSession(desc.parentSessionId).addSSTables(cfs.metadata.cfId, snapshottedSSSTables);
                    }
                    logger.debug("Enqueuing response to snapshot request {} to {}", (Object)desc.sessionId, (Object)message.from);
                    MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
                    break;
                }
                case VALIDATION_REQUEST: {
                    ValidationRequest validationRequest = (ValidationRequest)message.payload;
                    logger.debug("Validating {}", (Object)validationRequest);
                    ColumnFamilyStore store = ColumnFamilyStore.getIfExists(desc.keyspace, desc.columnFamily);
                    if (store == null) {
                        logger.error("Table {}.{} was dropped during snapshot phase of repair", (Object)desc.keyspace, (Object)desc.columnFamily);
                        MessagingService.instance().sendOneWay(new ValidationComplete(desc).createMessage(), message.from);
                        return;
                    }
                    Validator validator = new Validator(desc, message.from, validationRequest.gcBefore);
                    CompactionManager.instance.submitValidation(store, validator);
                    break;
                }
                case SYNC_REQUEST: {
                    SyncRequest request = (SyncRequest)message.payload;
                    logger.debug("Syncing {}", (Object)request);
                    long repairedAt = 0L;
                    if (desc.parentSessionId != null && ActiveRepairService.instance.getParentRepairSession(desc.parentSessionId) != null) {
                        repairedAt = ActiveRepairService.instance.getParentRepairSession(desc.parentSessionId).getRepairedAt();
                    }
                    StreamingRepairTask task = new StreamingRepairTask(desc, request, repairedAt);
                    task.run();
                    break;
                }
                case ANTICOMPACTION_REQUEST: {
                    AnticompactionRequest anticompactionRequest = (AnticompactionRequest)message.payload;
                    logger.debug("Got anticompaction request {}", (Object)anticompactionRequest);
                    ListenableFuture<List<Object>> compactionDone = ActiveRepairService.instance.doAntiCompaction(anticompactionRequest.parentRepairSession, anticompactionRequest.successfulRanges);
                    compactionDone.addListener(new Runnable(){

                        @Override
                        public void run() {
                            MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
                        }
                    }, (Executor)MoreExecutors.sameThreadExecutor());
                    break;
                }
                case CLEANUP: {
                    logger.debug("cleaning up repair");
                    CleanupMessage cleanup = (CleanupMessage)message.payload;
                    ActiveRepairService.instance.removeParentRepairSession(cleanup.parentRepairSession);
                    MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
                    break;
                }
                default: {
                    ActiveRepairService.instance.handleMessage(message.from, (RepairMessage)message.payload);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Got error, removing parent repair session");
            if (desc != null && desc.parentSessionId != null) {
                ActiveRepairService.instance.removeParentRepairSession(desc.parentSessionId);
            }
            throw new RuntimeException(e);
        }
    }

    private void logErrorAndSendFailureResponse(String errorMessage, InetAddress to, int id) {
        logger.error(errorMessage);
        MessageOut reply = new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE).withParameter("FAIL", MessagingService.ONE_BYTE);
        MessagingService.instance().sendReply(reply, id, to);
    }
}

