/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import org.apache.cassandra.hints.ChecksummedDataInput;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.security.EncryptionUtils;

public class EncryptedChecksummedDataInput
extends ChecksummedDataInput {
    private static final ThreadLocal<ByteBuffer> reusableBuffers = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(0);
        }
    };
    private final Cipher cipher;
    private final ICompressor compressor;
    private final EncryptionUtils.ChannelProxyReadChannel readChannel;

    protected EncryptedChecksummedDataInput(ChannelProxy channel, Cipher cipher, ICompressor compressor, long filePosition) {
        super(channel);
        this.cipher = cipher;
        this.compressor = compressor;
        this.readChannel = new EncryptionUtils.ChannelProxyReadChannel(channel, filePosition);
        assert (cipher != null);
        assert (compressor != null);
    }

    @Override
    public boolean isEOF() {
        return this.getSourcePosition() == this.channel.size() && this.buffer.remaining() == 0;
    }

    @Override
    public long getSourcePosition() {
        return this.readChannel.getCurrentPosition();
    }

    @Override
    protected void readBuffer() {
        try {
            ByteBuffer byteBuffer = reusableBuffers.get();
            ByteBuffer decrypted = EncryptionUtils.decrypt(this.readChannel, byteBuffer, true, this.cipher);
            this.buffer = EncryptionUtils.uncompress(decrypted, this.buffer, true, this.compressor);
            if (decrypted.capacity() > byteBuffer.capacity()) {
                reusableBuffers.set(decrypted);
            }
        }
        catch (IOException ioe) {
            throw new FSReadError((Throwable)ioe, this.getPath());
        }
    }

    public static ChecksummedDataInput upgradeInput(ChecksummedDataInput input, Cipher cipher, ICompressor compressor) {
        long position = input.getPosition();
        input.close();
        return new EncryptedChecksummedDataInput(new ChannelProxy(input.getPath()), cipher, compressor, position);
    }

    @VisibleForTesting
    Cipher getCipher() {
        return this.cipher;
    }

    @VisibleForTesting
    ICompressor getCompressor() {
        return this.compressor;
    }
}

