/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.Collection;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class UnfilteredSerializer {
    public static final UnfilteredSerializer serializer = new UnfilteredSerializer();
    private static final int END_OF_PARTITION = 1;
    private static final int IS_MARKER = 2;
    private static final int HAS_TIMESTAMP = 4;
    private static final int HAS_TTL = 8;
    private static final int HAS_DELETION = 16;
    private static final int HAS_ALL_COLUMNS = 32;
    private static final int HAS_COMPLEX_DELETION = 64;
    private static final int EXTENSION_FLAG = 128;
    private static final int IS_STATIC = 1;
    private static final int HAS_SHADOWABLE_DELETION = 2;

    public void serialize(Unfiltered unfiltered, SerializationHeader header, DataOutputPlus out, int version) throws IOException {
        assert (!header.isForSSTable());
        this.serialize(unfiltered, header, out, 0L, version);
    }

    public void serialize(Unfiltered unfiltered, SerializationHeader header, DataOutputPlus out, long previousUnfilteredSize, int version) throws IOException {
        if (unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            this.serialize((RangeTombstoneMarker)unfiltered, header, out, previousUnfilteredSize, version);
        } else {
            this.serialize((Row)unfiltered, header, out, previousUnfilteredSize, version);
        }
    }

    public void serializeStaticRow(Row row, SerializationHeader header, DataOutputPlus out, int version) throws IOException {
        assert (row.isStatic());
        this.serialize(row, header, out, 0L, version);
    }

    private void serialize(Row row, SerializationHeader header, DataOutputPlus out, long previousUnfilteredSize, int version) throws IOException {
        int flags = 0;
        int extendedFlags = 0;
        boolean isStatic = row.isStatic();
        Columns headerColumns = header.columns(isStatic);
        LivenessInfo pkLiveness = row.primaryKeyLivenessInfo();
        Row.Deletion deletion = row.deletion();
        boolean hasComplexDeletion = row.hasComplexDeletion();
        boolean hasAllColumns = row.size() == headerColumns.size();
        boolean hasExtendedFlags = UnfilteredSerializer.hasExtendedFlags(row);
        if (isStatic) {
            extendedFlags |= 1;
        }
        if (!pkLiveness.isEmpty()) {
            flags |= 4;
        }
        if (pkLiveness.isExpiring()) {
            flags |= 8;
        }
        if (!deletion.isLive()) {
            flags |= 0x10;
            if (deletion.isShadowable()) {
                extendedFlags |= 2;
            }
        }
        if (hasComplexDeletion) {
            flags |= 0x40;
        }
        if (hasAllColumns) {
            flags |= 0x20;
        }
        if (hasExtendedFlags) {
            flags |= 0x80;
        }
        out.writeByte((byte)flags);
        if (hasExtendedFlags) {
            out.writeByte((byte)extendedFlags);
        }
        if (!isStatic) {
            Clustering.serializer.serialize(row.clustering(), out, version, header.clusteringTypes());
        }
        if (header.isForSSTable()) {
            out.writeUnsignedVInt(this.serializedRowBodySize(row, header, previousUnfilteredSize, version));
            out.writeUnsignedVInt(previousUnfilteredSize);
        }
        if ((flags & 4) != 0) {
            header.writeTimestamp(pkLiveness.timestamp(), out);
        }
        if ((flags & 8) != 0) {
            header.writeTTL(pkLiveness.ttl(), out);
            header.writeLocalDeletionTime(pkLiveness.localExpirationTime(), out);
        }
        if ((flags & 0x10) != 0) {
            header.writeDeletionTime(deletion.time(), out);
        }
        if (!hasAllColumns) {
            Columns.serializer.serializeSubset(Collections2.transform((Collection)row, ColumnData::column), headerColumns, out);
        }
        for (ColumnData data : row) {
            if (data.column.isSimple()) {
                Cell.serializer.serialize((Cell)data, out, pkLiveness, header);
                continue;
            }
            this.writeComplexColumn((ComplexColumnData)data, hasComplexDeletion, pkLiveness, header, out);
        }
    }

    private void writeComplexColumn(ComplexColumnData data, boolean hasComplexDeletion, LivenessInfo rowLiveness, SerializationHeader header, DataOutputPlus out) throws IOException {
        if (hasComplexDeletion) {
            header.writeDeletionTime(data.complexDeletion(), out);
        }
        out.writeUnsignedVInt(data.cellsCount());
        for (Cell cell : data) {
            Cell.serializer.serialize(cell, out, rowLiveness, header);
        }
    }

    private void serialize(RangeTombstoneMarker marker, SerializationHeader header, DataOutputPlus out, long previousUnfilteredSize, int version) throws IOException {
        out.writeByte(2);
        ClusteringBoundOrBoundary.serializer.serialize(marker.clustering(), out, version, header.clusteringTypes());
        if (header.isForSSTable()) {
            out.writeUnsignedVInt(this.serializedMarkerBodySize(marker, header, previousUnfilteredSize, version));
            out.writeUnsignedVInt(previousUnfilteredSize);
        }
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
            header.writeDeletionTime(bm.endDeletionTime(), out);
            header.writeDeletionTime(bm.startDeletionTime(), out);
        } else {
            header.writeDeletionTime(((RangeTombstoneBoundMarker)marker).deletionTime(), out);
        }
    }

    public long serializedSize(Unfiltered unfiltered, SerializationHeader header, int version) {
        assert (!header.isForSSTable());
        return this.serializedSize(unfiltered, header, 0L, version);
    }

    public long serializedSize(Unfiltered unfiltered, SerializationHeader header, long previousUnfilteredSize, int version) {
        return unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER ? this.serializedSize((RangeTombstoneMarker)unfiltered, header, previousUnfilteredSize, version) : this.serializedSize((Row)unfiltered, header, previousUnfilteredSize, version);
    }

    private long serializedSize(Row row, SerializationHeader header, long previousUnfilteredSize, int version) {
        long size = 1L;
        if (UnfilteredSerializer.hasExtendedFlags(row)) {
            ++size;
        }
        if (!row.isStatic()) {
            size += Clustering.serializer.serializedSize(row.clustering(), version, header.clusteringTypes());
        }
        return size + this.serializedRowBodySize(row, header, previousUnfilteredSize, version);
    }

    private long serializedRowBodySize(Row row, SerializationHeader header, long previousUnfilteredSize, int version) {
        boolean hasAllColumns;
        long size = 0L;
        if (header.isForSSTable()) {
            size += (long)TypeSizes.sizeofUnsignedVInt(previousUnfilteredSize);
        }
        boolean isStatic = row.isStatic();
        Columns headerColumns = header.columns(isStatic);
        LivenessInfo pkLiveness = row.primaryKeyLivenessInfo();
        Row.Deletion deletion = row.deletion();
        boolean hasComplexDeletion = row.hasComplexDeletion();
        boolean bl = hasAllColumns = row.size() == headerColumns.size();
        if (!pkLiveness.isEmpty()) {
            size += header.timestampSerializedSize(pkLiveness.timestamp());
        }
        if (pkLiveness.isExpiring()) {
            size += header.ttlSerializedSize(pkLiveness.ttl());
            size += header.localDeletionTimeSerializedSize(pkLiveness.localExpirationTime());
        }
        if (!deletion.isLive()) {
            size += header.deletionTimeSerializedSize(deletion.time());
        }
        if (!hasAllColumns) {
            size += Columns.serializer.serializedSubsetSize(Collections2.transform((Collection)row, ColumnData::column), header.columns(isStatic));
        }
        for (ColumnData data : row) {
            if (data.column.isSimple()) {
                size += Cell.serializer.serializedSize((Cell)data, pkLiveness, header);
                continue;
            }
            size += this.sizeOfComplexColumn((ComplexColumnData)data, hasComplexDeletion, pkLiveness, header);
        }
        return size;
    }

    private long sizeOfComplexColumn(ComplexColumnData data, boolean hasComplexDeletion, LivenessInfo rowLiveness, SerializationHeader header) {
        long size = 0L;
        if (hasComplexDeletion) {
            size += header.deletionTimeSerializedSize(data.complexDeletion());
        }
        size += (long)TypeSizes.sizeofUnsignedVInt(data.cellsCount());
        for (Cell cell : data) {
            size += Cell.serializer.serializedSize(cell, rowLiveness, header);
        }
        return size;
    }

    private long serializedSize(RangeTombstoneMarker marker, SerializationHeader header, long previousUnfilteredSize, int version) {
        assert (!header.isForSSTable());
        return 1L + ClusteringBoundOrBoundary.serializer.serializedSize(marker.clustering(), version, header.clusteringTypes()) + this.serializedMarkerBodySize(marker, header, previousUnfilteredSize, version);
    }

    private long serializedMarkerBodySize(RangeTombstoneMarker marker, SerializationHeader header, long previousUnfilteredSize, int version) {
        long size = 0L;
        if (header.isForSSTable()) {
            size += (long)TypeSizes.sizeofUnsignedVInt(previousUnfilteredSize);
        }
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
            size += header.deletionTimeSerializedSize(bm.endDeletionTime());
            size += header.deletionTimeSerializedSize(bm.startDeletionTime());
        } else {
            size += header.deletionTimeSerializedSize(((RangeTombstoneBoundMarker)marker).deletionTime());
        }
        return size;
    }

    public void writeEndOfPartition(DataOutputPlus out) throws IOException {
        out.writeByte(1);
    }

    public long serializedSizeEndOfPartition() {
        return 1L;
    }

    public Unfiltered deserialize(DataInputPlus in, SerializationHeader header, SerializationHelper helper, Row.Builder builder) throws IOException {
        assert (builder.isSorted());
        int flags = in.readUnsignedByte();
        if (UnfilteredSerializer.isEndOfPartition(flags)) {
            return null;
        }
        int extendedFlags = UnfilteredSerializer.readExtendedFlags(in, flags);
        if (UnfilteredSerializer.kind(flags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            ClusteringBoundOrBoundary bound = ClusteringBoundOrBoundary.serializer.deserialize(in, helper.version, header.clusteringTypes());
            return this.deserializeMarkerBody(in, header, bound);
        }
        assert (!UnfilteredSerializer.isStatic(extendedFlags));
        builder.newRow(Clustering.serializer.deserialize(in, helper.version, header.clusteringTypes()));
        return this.deserializeRowBody(in, header, helper, flags, extendedFlags, builder);
    }

    public Row deserializeStaticRow(DataInputPlus in, SerializationHeader header, SerializationHelper helper) throws IOException {
        int flags = in.readUnsignedByte();
        assert (!UnfilteredSerializer.isEndOfPartition(flags) && UnfilteredSerializer.kind(flags) == Unfiltered.Kind.ROW && UnfilteredSerializer.isExtended(flags)) : flags;
        int extendedFlags = in.readUnsignedByte();
        Row.Builder builder = BTreeRow.sortedBuilder();
        builder.newRow(Clustering.STATIC_CLUSTERING);
        return this.deserializeRowBody(in, header, helper, flags, extendedFlags, builder);
    }

    public RangeTombstoneMarker deserializeMarkerBody(DataInputPlus in, SerializationHeader header, ClusteringBoundOrBoundary bound) throws IOException {
        if (header.isForSSTable()) {
            in.readUnsignedVInt();
            in.readUnsignedVInt();
        }
        if (bound.isBoundary()) {
            return new RangeTombstoneBoundaryMarker((ClusteringBoundary)bound, header.readDeletionTime(in), header.readDeletionTime(in));
        }
        return new RangeTombstoneBoundMarker((ClusteringBound)bound, header.readDeletionTime(in));
    }

    public Row deserializeRowBody(DataInputPlus in, SerializationHeader header, SerializationHelper helper, int flags, int extendedFlags, Row.Builder builder) throws IOException {
        try {
            boolean isStatic = UnfilteredSerializer.isStatic(extendedFlags);
            boolean hasTimestamp = (flags & 4) != 0;
            boolean hasTTL = (flags & 8) != 0;
            boolean hasDeletion = (flags & 0x10) != 0;
            boolean deletionIsShadowable = (extendedFlags & 2) != 0;
            boolean hasComplexDeletion = (flags & 0x40) != 0;
            boolean hasAllColumns = (flags & 0x20) != 0;
            Columns headerColumns = header.columns(isStatic);
            if (header.isForSSTable()) {
                in.readUnsignedVInt();
                in.readUnsignedVInt();
            }
            LivenessInfo rowLiveness = LivenessInfo.EMPTY;
            if (hasTimestamp) {
                long timestamp = header.readTimestamp(in);
                int ttl = hasTTL ? header.readTTL(in) : 0;
                int localDeletionTime = hasTTL ? header.readLocalDeletionTime(in) : Integer.MAX_VALUE;
                rowLiveness = LivenessInfo.withExpirationTime(timestamp, ttl, localDeletionTime);
            }
            builder.addPrimaryKeyLivenessInfo(rowLiveness);
            builder.addRowDeletion(hasDeletion ? new Row.Deletion(header.readDeletionTime(in), deletionIsShadowable) : Row.Deletion.LIVE);
            Columns columns = hasAllColumns ? headerColumns : Columns.serializer.deserializeSubset(headerColumns, in);
            for (ColumnDefinition column : columns) {
                if (column.isSimple()) {
                    this.readSimpleColumn(column, in, header, helper, builder, rowLiveness);
                    continue;
                }
                this.readComplexColumn(column, in, header, helper, hasComplexDeletion, builder, rowLiveness);
            }
            return builder.build();
        }
        catch (AssertionError | RuntimeException e) {
            throw new IOException("Error building row with data deserialized from " + in, (Throwable)e);
        }
    }

    private void readSimpleColumn(ColumnDefinition column, DataInputPlus in, SerializationHeader header, SerializationHelper helper, Row.Builder builder, LivenessInfo rowLiveness) throws IOException {
        if (helper.includes(column)) {
            Cell cell = Cell.serializer.deserialize(in, rowLiveness, column, header, helper);
            if (helper.includes(cell, rowLiveness) && !helper.isDropped(cell, false)) {
                builder.addCell(cell);
            }
        } else {
            Cell.serializer.skip(in, column, header);
        }
    }

    private void readComplexColumn(ColumnDefinition column, DataInputPlus in, SerializationHeader header, SerializationHelper helper, boolean hasComplexDeletion, Row.Builder builder, LivenessInfo rowLiveness) throws IOException {
        if (helper.includes(column)) {
            DeletionTime complexDeletion;
            helper.startOfComplexColumn(column);
            if (hasComplexDeletion && !helper.isDroppedComplexDeletion(complexDeletion = header.readDeletionTime(in))) {
                builder.addComplexDeletion(column, complexDeletion);
            }
            int count = (int)in.readUnsignedVInt();
            while (--count >= 0) {
                Cell cell = Cell.serializer.deserialize(in, rowLiveness, column, header, helper);
                if (!helper.includes(cell, rowLiveness) || helper.isDropped(cell, true)) continue;
                builder.addCell(cell);
            }
            helper.endOfComplexColumn();
        } else {
            this.skipComplexColumn(in, column, header, hasComplexDeletion);
        }
    }

    public void skipRowBody(DataInputPlus in) throws IOException {
        int rowSize = (int)in.readUnsignedVInt();
        in.skipBytesFully(rowSize);
    }

    public void skipStaticRow(DataInputPlus in, SerializationHeader header, SerializationHelper helper) throws IOException {
        int flags = in.readUnsignedByte();
        assert (!UnfilteredSerializer.isEndOfPartition(flags) && UnfilteredSerializer.kind(flags) == Unfiltered.Kind.ROW && UnfilteredSerializer.isExtended(flags)) : "Flags is " + flags;
        int extendedFlags = in.readUnsignedByte();
        assert (UnfilteredSerializer.isStatic(extendedFlags));
        this.skipRowBody(in);
    }

    public void skipMarkerBody(DataInputPlus in) throws IOException {
        int markerSize = (int)in.readUnsignedVInt();
        in.skipBytesFully(markerSize);
    }

    private void skipComplexColumn(DataInputPlus in, ColumnDefinition column, SerializationHeader header, boolean hasComplexDeletion) throws IOException {
        if (hasComplexDeletion) {
            header.skipDeletionTime(in);
        }
        int count = (int)in.readUnsignedVInt();
        while (--count >= 0) {
            Cell.serializer.skip(in, column, header);
        }
    }

    public static boolean isEndOfPartition(int flags) {
        return (flags & 1) != 0;
    }

    public static Unfiltered.Kind kind(int flags) {
        return (flags & 2) != 0 ? Unfiltered.Kind.RANGE_TOMBSTONE_MARKER : Unfiltered.Kind.ROW;
    }

    public static boolean isStatic(int extendedFlags) {
        return (extendedFlags & 1) != 0;
    }

    private static boolean isExtended(int flags) {
        return (flags & 0x80) != 0;
    }

    public static int readExtendedFlags(DataInputPlus in, int flags) throws IOException {
        return UnfilteredSerializer.isExtended(flags) ? in.readUnsignedByte() : 0;
    }

    public static boolean hasExtendedFlags(Row row) {
        return row.isStatic() || row.deletion().isShadowable();
    }
}

