/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.compaction.DateTieredCompactionStrategy;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTieredCompactionStrategyOptions {
    private static final Logger logger = LoggerFactory.getLogger(DateTieredCompactionStrategy.class);
    protected static final TimeUnit DEFAULT_TIMESTAMP_RESOLUTION = TimeUnit.MICROSECONDS;
    @Deprecated
    protected static final double DEFAULT_MAX_SSTABLE_AGE_DAYS = 365000.0;
    protected static final long DEFAULT_BASE_TIME_SECONDS = 60L;
    protected static final long DEFAULT_MAX_WINDOW_SIZE_SECONDS = TimeUnit.SECONDS.convert(1L, TimeUnit.DAYS);
    protected static final int DEFAULT_EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS = 600;
    protected static final String TIMESTAMP_RESOLUTION_KEY = "timestamp_resolution";
    @Deprecated
    protected static final String MAX_SSTABLE_AGE_KEY = "max_sstable_age_days";
    protected static final String BASE_TIME_KEY = "base_time_seconds";
    protected static final String EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY = "expired_sstable_check_frequency_seconds";
    protected static final String MAX_WINDOW_SIZE_KEY = "max_window_size_seconds";
    @Deprecated
    protected final long maxSSTableAge;
    protected final TimeUnit timestampResolution;
    protected final long baseTime;
    protected final long expiredSSTableCheckFrequency;
    protected final long maxWindowSize;

    public DateTieredCompactionStrategyOptions(Map<String, String> options) {
        String optionValue = options.get(TIMESTAMP_RESOLUTION_KEY);
        TimeUnit timeUnit = this.timestampResolution = optionValue == null ? DEFAULT_TIMESTAMP_RESOLUTION : TimeUnit.valueOf(optionValue);
        if (this.timestampResolution != DEFAULT_TIMESTAMP_RESOLUTION) {
            logger.warn("Using a non-default timestamp_resolution {} - are you really doing inserts with USING TIMESTAMP <non_microsecond_timestamp> (or driver equivalent)?", (Object)this.timestampResolution.toString());
        }
        double fractionalDays = (optionValue = options.get(MAX_SSTABLE_AGE_KEY)) == null ? 365000.0 : Double.parseDouble(optionValue);
        this.maxSSTableAge = Math.round(fractionalDays * (double)this.timestampResolution.convert(1L, TimeUnit.DAYS));
        optionValue = options.get(BASE_TIME_KEY);
        this.baseTime = this.timestampResolution.convert(optionValue == null ? 60L : Long.parseLong(optionValue), TimeUnit.SECONDS);
        optionValue = options.get(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        this.expiredSSTableCheckFrequency = TimeUnit.MILLISECONDS.convert(optionValue == null ? 600L : Long.parseLong(optionValue), TimeUnit.SECONDS);
        optionValue = options.get(MAX_WINDOW_SIZE_KEY);
        this.maxWindowSize = this.timestampResolution.convert(optionValue == null ? DEFAULT_MAX_WINDOW_SIZE_SECONDS : Long.parseLong(optionValue), TimeUnit.SECONDS);
    }

    public DateTieredCompactionStrategyOptions() {
        this.maxSSTableAge = Math.round(365000.0 * (double)DEFAULT_TIMESTAMP_RESOLUTION.convert(365000L, TimeUnit.DAYS));
        this.timestampResolution = DEFAULT_TIMESTAMP_RESOLUTION;
        this.baseTime = this.timestampResolution.convert(60L, TimeUnit.SECONDS);
        this.expiredSSTableCheckFrequency = TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS);
        this.maxWindowSize = this.timestampResolution.convert(1L, TimeUnit.DAYS);
    }

    public static Map<String, String> validateOptions(Map<String, String> options, Map<String, String> uncheckedOptions) throws ConfigurationException {
        String optionValue = options.get(TIMESTAMP_RESOLUTION_KEY);
        try {
            if (optionValue != null) {
                TimeUnit.valueOf(optionValue);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("timestamp_resolution %s is not valid", optionValue));
        }
        optionValue = options.get(MAX_SSTABLE_AGE_KEY);
        try {
            double maxSStableAge;
            double d = maxSStableAge = optionValue == null ? 365000.0 : Double.parseDouble(optionValue);
            if (maxSStableAge < 0.0) {
                throw new ConfigurationException(String.format("%s must be non-negative: %.2f", MAX_SSTABLE_AGE_KEY, maxSStableAge));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, MAX_SSTABLE_AGE_KEY), e);
        }
        optionValue = options.get(BASE_TIME_KEY);
        try {
            long baseTime;
            long l = baseTime = optionValue == null ? 60L : Long.parseLong(optionValue);
            if (baseTime <= 0L) {
                throw new ConfigurationException(String.format("%s must be greater than 0, but was %d", BASE_TIME_KEY, baseTime));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, BASE_TIME_KEY), e);
        }
        optionValue = options.get(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        try {
            long expiredCheckFrequency;
            long l = expiredCheckFrequency = optionValue == null ? 600L : Long.parseLong(optionValue);
            if (expiredCheckFrequency < 0L) {
                throw new ConfigurationException(String.format("%s must not be negative, but was %d", EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY, expiredCheckFrequency));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY), e);
        }
        optionValue = options.get(MAX_WINDOW_SIZE_KEY);
        try {
            long maxWindowSize;
            long l = maxWindowSize = optionValue == null ? DEFAULT_MAX_WINDOW_SIZE_SECONDS : Long.parseLong(optionValue);
            if (maxWindowSize < 0L) {
                throw new ConfigurationException(String.format("%s must not be negative, but was %d", MAX_WINDOW_SIZE_KEY, maxWindowSize));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, MAX_WINDOW_SIZE_KEY), e);
        }
        uncheckedOptions.remove(MAX_SSTABLE_AGE_KEY);
        uncheckedOptions.remove(BASE_TIME_KEY);
        uncheckedOptions.remove(TIMESTAMP_RESOLUTION_KEY);
        uncheckedOptions.remove(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        uncheckedOptions.remove(MAX_WINDOW_SIZE_KEY);
        return uncheckedOptions;
    }
}

