/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnIndex {
    private DataOutputBuffer buffer;
    private int indexSamplesSerializedSize;
    public List<IndexInfo> indexSamples = new ArrayList<IndexInfo>();
    public int columnIndexCount;
    private int[] indexOffsets;
    private final SerializationHeader header;
    private final int version;
    private final SequentialWriter writer;
    private final long initialPosition;
    private final ISerializer<IndexInfo> idxSerializer;
    public long headerLength = -1L;
    private long startPosition = -1L;
    private int written;
    private long previousRowStart;
    private ClusteringPrefix firstClustering;
    private ClusteringPrefix lastClustering;
    private DeletionTime openMarker;
    private final Collection<SSTableFlushObserver> observers;

    public ColumnIndex(SerializationHeader header, SequentialWriter writer, Version version, Collection<SSTableFlushObserver> observers, ISerializer<IndexInfo> indexInfoSerializer) {
        this.header = header;
        this.idxSerializer = indexInfoSerializer;
        this.writer = writer;
        this.version = version.correspondingMessagingVersion();
        this.observers = observers;
        this.initialPosition = writer.position();
    }

    public void buildRowIndex(UnfilteredRowIterator iterator) throws IOException {
        this.writePartitionHeader(iterator);
        this.headerLength = this.writer.position() - this.initialPosition;
        while (iterator.hasNext()) {
            this.add((Unfiltered)iterator.next());
        }
        this.close();
    }

    private void writePartitionHeader(UnfilteredRowIterator iterator) throws IOException {
        ByteBufferUtil.writeWithShortLength(iterator.partitionKey().getKey(), this.writer);
        DeletionTime.serializer.serialize(iterator.partitionLevelDeletion(), (DataOutputPlus)this.writer);
        if (this.header.hasStatic()) {
            Row staticRow = iterator.staticRow();
            UnfilteredSerializer.serializer.serializeStaticRow(staticRow, this.header, this.writer, this.version);
            if (!this.observers.isEmpty()) {
                this.observers.forEach(o -> o.nextUnfilteredCluster(staticRow));
            }
        }
    }

    private long currentPosition() {
        return this.writer.position() - this.initialPosition;
    }

    public ByteBuffer buffer() {
        return this.buffer != null ? this.buffer.buffer() : null;
    }

    public int[] offsets() {
        return this.indexOffsets != null ? Arrays.copyOf(this.indexOffsets, this.columnIndexCount) : null;
    }

    private void addIndexBlock() throws IOException {
        IndexInfo cIndexInfo = new IndexInfo(this.firstClustering, this.lastClustering, this.startPosition, this.currentPosition() - this.startPosition, this.openMarker);
        if (this.indexOffsets == null) {
            this.indexOffsets = new int[10];
        } else {
            if (this.columnIndexCount >= this.indexOffsets.length) {
                this.indexOffsets = Arrays.copyOf(this.indexOffsets, this.indexOffsets.length + 10);
            }
            this.indexOffsets[this.columnIndexCount] = this.buffer != null ? Ints.checkedCast((long)this.buffer.position()) : this.indexSamplesSerializedSize;
        }
        ++this.columnIndexCount;
        if (this.buffer == null) {
            this.indexSamplesSerializedSize = (int)((long)this.indexSamplesSerializedSize + this.idxSerializer.serializedSize(cIndexInfo));
            if (this.indexSamplesSerializedSize + this.columnIndexCount * TypeSizes.sizeof(0) > DatabaseDescriptor.getColumnIndexCacheSize()) {
                this.buffer = new DataOutputBuffer(DatabaseDescriptor.getColumnIndexCacheSize() * 2);
                for (IndexInfo indexSample : this.indexSamples) {
                    this.idxSerializer.serialize(indexSample, this.buffer);
                }
                this.indexSamples = null;
            } else {
                this.indexSamples.add(cIndexInfo);
            }
        }
        if (this.buffer != null) {
            this.idxSerializer.serialize(cIndexInfo, this.buffer);
        }
        this.firstClustering = null;
    }

    private void add(Unfiltered unfiltered) throws IOException {
        long pos = this.currentPosition();
        if (this.firstClustering == null) {
            this.firstClustering = unfiltered.clustering();
            this.startPosition = pos;
        }
        UnfilteredSerializer.serializer.serialize(unfiltered, this.header, (DataOutputPlus)this.writer, pos - this.previousRowStart, this.version);
        if (!this.observers.isEmpty()) {
            this.observers.forEach(o -> o.nextUnfilteredCluster(unfiltered));
        }
        this.lastClustering = unfiltered.clustering();
        this.previousRowStart = pos;
        ++this.written;
        if (unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            RangeTombstoneMarker marker = (RangeTombstoneMarker)unfiltered;
            DeletionTime deletionTime = this.openMarker = marker.isOpen(false) ? marker.openDeletionTime(false) : null;
        }
        if (this.currentPosition() - this.startPosition >= (long)DatabaseDescriptor.getColumnIndexSize()) {
            this.addIndexBlock();
        }
    }

    private void close() throws IOException {
        UnfilteredSerializer.serializer.writeEndOfPartition(this.writer);
        if (this.written == 0) {
            return;
        }
        if (this.firstClustering != null) {
            this.addIndexBlock();
        }
        if (this.buffer != null) {
            RowIndexEntry.Serializer.serializeOffsets(this.buffer, this.indexOffsets, this.columnIndexCount);
        }
        assert (this.columnIndexCount > 0 && this.headerLength >= 0L);
    }

    public int indexInfoSerializedSize() {
        return this.buffer != null ? this.buffer.buffer().limit() : this.indexSamplesSerializedSize + this.columnIndexCount * TypeSizes.sizeof(0);
    }
}

