/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.sa;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import net.mintern.primitive.Primitive;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.disk.DynamicTokenTreeBuilder;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.disk.TokenTreeBuilder;
import org.apache.cassandra.index.sasi.sa.CharTerm;
import org.apache.cassandra.index.sasi.sa.SA;
import org.apache.cassandra.index.sasi.sa.Term;
import org.apache.cassandra.index.sasi.sa.TermIterator;
import org.apache.cassandra.utils.Pair;

public class SuffixSA
extends SA<CharBuffer> {
    public SuffixSA(AbstractType<?> comparator, OnDiskIndexBuilder.Mode mode) {
        super(comparator, mode);
    }

    @Override
    protected Term<CharBuffer> getTerm(ByteBuffer termValue, TokenTreeBuilder tokens) {
        return new CharTerm(this.charCount, Charsets.UTF_8.decode(termValue.duplicate()), tokens);
    }

    @Override
    public TermIterator finish() {
        return new SASuffixIterator();
    }

    private class SASuffixIterator
    extends TermIterator {
        private final long[] suffixes;
        private int current = 0;
        private ByteBuffer lastProcessedSuffix;
        private TokenTreeBuilder container;

        public SASuffixIterator() {
            this.suffixes = new long[SuffixSA.this.charCount];
            long termIndex = -1L;
            long currentTermLength = -1L;
            for (int i = 0; i < SuffixSA.this.charCount; ++i) {
                if ((long)i >= currentTermLength || currentTermLength == -1L) {
                    Term currentTerm = (Term)SuffixSA.this.terms.get((int)(++termIndex));
                    currentTermLength = currentTerm.getPosition() + currentTerm.length();
                }
                this.suffixes[i] = termIndex << 32 | (long)i;
            }
            Primitive.sort((long[])this.suffixes, (a, b) -> {
                Term aTerm = (Term)SuffixSA.this.terms.get((int)(a >>> 32));
                Term bTerm = (Term)SuffixSA.this.terms.get((int)(b >>> 32));
                return SuffixSA.this.comparator.compare(aTerm.getSuffix((int)a - aTerm.getPosition()), bTerm.getSuffix((int)b - bTerm.getPosition()));
            });
        }

        private Pair<ByteBuffer, TokenTreeBuilder> suffixAt(int position) {
            long index = this.suffixes[position];
            Term term = (Term)SuffixSA.this.terms.get((int)(index >>> 32));
            return Pair.create(term.getSuffix((int)index - term.getPosition()), term.getTokens());
        }

        @Override
        public ByteBuffer minTerm() {
            return (ByteBuffer)this.suffixAt((int)0).left;
        }

        @Override
        public ByteBuffer maxTerm() {
            return (ByteBuffer)this.suffixAt((int)(this.suffixes.length - 1)).left;
        }

        protected Pair<ByteBuffer, TokenTreeBuilder> computeNext() {
            Pair<ByteBuffer, TokenTreeBuilder> suffix;
            while (true) {
                if (this.current >= this.suffixes.length) {
                    if (this.lastProcessedSuffix == null) {
                        return (Pair)this.endOfData();
                    }
                    Pair<ByteBuffer, TokenTreeBuilder> result = this.finishSuffix();
                    this.lastProcessedSuffix = null;
                    return result;
                }
                suffix = this.suffixAt(this.current++);
                if (this.lastProcessedSuffix == null) {
                    this.lastProcessedSuffix = (ByteBuffer)suffix.left;
                    this.container = new DynamicTokenTreeBuilder((TokenTreeBuilder)suffix.right);
                    continue;
                }
                if (SuffixSA.this.comparator.compare(this.lastProcessedSuffix, (ByteBuffer)suffix.left) != 0) break;
                this.lastProcessedSuffix = (ByteBuffer)suffix.left;
                this.container.add((TokenTreeBuilder)suffix.right);
            }
            Pair<ByteBuffer, TokenTreeBuilder> result = this.finishSuffix();
            this.lastProcessedSuffix = (ByteBuffer)suffix.left;
            this.container = new DynamicTokenTreeBuilder((TokenTreeBuilder)suffix.right);
            return result;
        }

        private Pair<ByteBuffer, TokenTreeBuilder> finishSuffix() {
            return Pair.create(this.lastProcessedSuffix, this.container.finish());
        }
    }
}

