/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class AbstractFunction
implements Function {
    protected final FunctionName name;
    protected final List<AbstractType<?>> argTypes;
    protected final AbstractType<?> returnType;

    protected AbstractFunction(FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType) {
        this.name = name;
        this.argTypes = argTypes;
        this.returnType = returnType;
    }

    @Override
    public FunctionName name() {
        return this.name;
    }

    @Override
    public List<AbstractType<?>> argTypes() {
        return this.argTypes;
    }

    @Override
    public AbstractType<?> returnType() {
        return this.returnType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractFunction)) {
            return false;
        }
        AbstractFunction that = (AbstractFunction)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.argTypes, that.argTypes) && Objects.equal(this.returnType, that.returnType);
    }

    @Override
    public Iterable<Function> getFunctions() {
        return ImmutableSet.of((Object)this);
    }

    @Override
    public boolean hasReferenceTo(Function function) {
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.argTypes, this.returnType});
    }

    @Override
    public final AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        AbstractType<?> returnType = this.returnType();
        if (receiver.type.isFrozenCollection()) {
            returnType = returnType.freeze();
        }
        if (receiver.type.equals(returnType)) {
            return AssignmentTestable.TestResult.EXACT_MATCH;
        }
        if (receiver.type.isValueCompatibleWith(returnType)) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" : (");
        for (int i = 0; i < this.argTypes.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.argTypes.get(i).asCQL3Type());
        }
        sb.append(") -> ").append(this.returnType.asCQL3Type());
        return sb.toString();
    }

    @Override
    public String columnName(List<String> columnNames) {
        return new StrBuilder(this.name().toString()).append('(').appendWithSeparators(columnNames, ", ").append(')').toString();
    }
}

