/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.monitoring;

import org.apache.cassandra.db.monitoring.ApproximateTime;
import org.apache.cassandra.db.monitoring.ConstructionTime;
import org.apache.cassandra.db.monitoring.Monitorable;
import org.apache.cassandra.db.monitoring.MonitoringState;
import org.apache.cassandra.db.monitoring.MonitoringTask;

public abstract class MonitorableImpl
implements Monitorable {
    private MonitoringState state = MonitoringState.IN_PROGRESS;
    private ConstructionTime constructionTime;
    private long timeout;

    protected MonitorableImpl() {
    }

    public void setMonitoringTime(ConstructionTime constructionTime, long timeout) {
        this.constructionTime = constructionTime;
        this.timeout = timeout;
    }

    @Override
    public ConstructionTime constructionTime() {
        return this.constructionTime;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public boolean isInProgress() {
        this.check();
        return this.state == MonitoringState.IN_PROGRESS;
    }

    @Override
    public boolean isAborted() {
        this.check();
        return this.state == MonitoringState.ABORTED;
    }

    @Override
    public boolean isCompleted() {
        this.check();
        return this.state == MonitoringState.COMPLETED;
    }

    @Override
    public boolean abort() {
        if (this.state == MonitoringState.IN_PROGRESS) {
            if (this.constructionTime != null) {
                MonitoringTask.addFailedOperation(this, ApproximateTime.currentTimeMillis());
            }
            this.state = MonitoringState.ABORTED;
            return true;
        }
        return this.state == MonitoringState.ABORTED;
    }

    @Override
    public boolean complete() {
        if (this.state == MonitoringState.IN_PROGRESS) {
            this.state = MonitoringState.COMPLETED;
            return true;
        }
        return this.state == MonitoringState.COMPLETED;
    }

    private void check() {
        if (this.constructionTime == null || this.state != MonitoringState.IN_PROGRESS) {
            return;
        }
        long elapsed = ApproximateTime.currentTimeMillis() - this.constructionTime.timestamp;
        if (elapsed >= this.timeout) {
            this.abort();
        }
    }
}

