/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableDeletingNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.notifications.SSTableRepairStatusChanged;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionStrategyManager
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CompactionStrategyManager.class);
    private final ColumnFamilyStore cfs;
    private volatile List<AbstractCompactionStrategy> repaired = new ArrayList<AbstractCompactionStrategy>();
    private volatile List<AbstractCompactionStrategy> unrepaired = new ArrayList<AbstractCompactionStrategy>();
    private volatile boolean enabled = true;
    public boolean isActive = true;
    private volatile CompactionParams params;
    private CompactionParams schemaCompactionParams;
    private Directories.DataDirectory[] locations;

    public CompactionStrategyManager(ColumnFamilyStore cfs) {
        cfs.getTracker().subscribe(this);
        logger.trace("{} subscribed to the data tracker.", (Object)this);
        this.cfs = cfs;
        this.reload(cfs.metadata);
        this.params = cfs.metadata.params.compaction;
        this.locations = this.getDirectories().getWriteableLocations();
        this.enabled = this.params.isEnabled();
    }

    public synchronized AbstractCompactionTask getNextBackgroundTask(int gcBefore) {
        if (!this.isEnabled()) {
            return null;
        }
        this.maybeReload(this.cfs.metadata);
        ArrayList<AbstractCompactionStrategy> strategies = new ArrayList<AbstractCompactionStrategy>(this.repaired.size() + this.unrepaired.size());
        strategies.addAll(this.repaired);
        strategies.addAll(this.unrepaired);
        Collections.sort(strategies, (o1, o2) -> Ints.compare((int)o2.getEstimatedRemainingTasks(), (int)o1.getEstimatedRemainingTasks()));
        for (AbstractCompactionStrategy strategy : strategies) {
            AbstractCompactionTask task = strategy.getNextBackgroundTask(gcBefore);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled && this.isActive;
    }

    public synchronized void resume() {
        this.isActive = true;
    }

    public synchronized void pause() {
        this.isActive = false;
    }

    private void startup() {
        for (SSTableReader sstable : this.cfs.getSSTables(SSTableSet.CANONICAL)) {
            if (sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
            this.getCompactionStrategyFor(sstable).addSSTable(sstable);
        }
        this.repaired.forEach(AbstractCompactionStrategy::startup);
        this.unrepaired.forEach(AbstractCompactionStrategy::startup);
    }

    private AbstractCompactionStrategy getCompactionStrategyFor(SSTableReader sstable) {
        int index = CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), sstable);
        if (sstable.isRepaired()) {
            return this.repaired.get(index);
        }
        return this.unrepaired.get(index);
    }

    public static int getCompactionStrategyIndex(ColumnFamilyStore cfs, Directories locations, SSTableReader sstable) {
        if (!cfs.getPartitioner().splitter().isPresent()) {
            return 0;
        }
        Directories.DataDirectory[] directories = locations.getWriteableLocations();
        List<PartitionPosition> boundaries = StorageService.getDiskBoundaries(cfs, locations.getWriteableLocations());
        if (boundaries == null) {
            for (int i = 0; i < directories.length; ++i) {
                Directories.DataDirectory directory = directories[i];
                if (!sstable.descriptor.directory.getAbsolutePath().startsWith(directory.location.getAbsolutePath())) continue;
                return i;
            }
            return 0;
        }
        int pos = Collections.binarySearch(boundaries, sstable.first);
        assert (pos < 0);
        return -pos - 1;
    }

    public void shutdown() {
        this.isActive = false;
        this.repaired.forEach(AbstractCompactionStrategy::shutdown);
        this.unrepaired.forEach(AbstractCompactionStrategy::shutdown);
    }

    public synchronized void maybeReload(CFMetaData metadata) {
        if (metadata.params.compaction.equals(this.schemaCompactionParams) && Arrays.equals(this.locations, this.cfs.getDirectories().getWriteableLocations())) {
            return;
        }
        this.reload(metadata);
    }

    public synchronized void reload(CFMetaData metadata) {
        boolean disabledWithJMX;
        boolean bl = disabledWithJMX = !this.enabled && this.shouldBeEnabled();
        if (!metadata.params.compaction.equals(this.schemaCompactionParams)) {
            logger.trace("Recreating compaction strategy - compaction parameters changed for {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.getTableName());
        } else if (!Arrays.equals(this.locations, this.cfs.getDirectories().getWriteableLocations())) {
            logger.trace("Recreating compaction strategy - writeable locations changed for {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.getTableName());
        }
        this.setStrategy(metadata.params.compaction);
        this.schemaCompactionParams = metadata.params.compaction;
        if (disabledWithJMX || !this.shouldBeEnabled()) {
            this.disable();
        } else {
            this.enable();
        }
        this.startup();
    }

    public void replaceFlushed(Memtable memtable, Collection<SSTableReader> sstables) {
        this.cfs.getTracker().replaceFlushed(memtable, sstables);
        if (sstables != null && !sstables.isEmpty()) {
            CompactionManager.instance.submitBackground(this.cfs);
        }
    }

    public int getUnleveledSSTables() {
        if (this.repaired.get(0) instanceof LeveledCompactionStrategy && this.unrepaired.get(0) instanceof LeveledCompactionStrategy) {
            int count = 0;
            for (AbstractCompactionStrategy strategy : this.repaired) {
                count += ((LeveledCompactionStrategy)strategy).getLevelSize(0);
            }
            for (AbstractCompactionStrategy strategy : this.unrepaired) {
                count += ((LeveledCompactionStrategy)strategy).getLevelSize(0);
            }
            return count;
        }
        return 0;
    }

    public synchronized int[] getSSTableCountPerLevel() {
        if (this.repaired.get(0) instanceof LeveledCompactionStrategy && this.unrepaired.get(0) instanceof LeveledCompactionStrategy) {
            int[] res = new int[LeveledManifest.MAX_LEVEL_COUNT];
            for (AbstractCompactionStrategy strategy : this.repaired) {
                int[] repairedCountPerLevel = ((LeveledCompactionStrategy)strategy).getAllLevelSize();
                res = CompactionStrategyManager.sumArrays(res, repairedCountPerLevel);
            }
            for (AbstractCompactionStrategy strategy : this.unrepaired) {
                int[] unrepairedCountPerLevel = ((LeveledCompactionStrategy)strategy).getAllLevelSize();
                res = CompactionStrategyManager.sumArrays(res, unrepairedCountPerLevel);
            }
            return res;
        }
        return null;
    }

    private static int[] sumArrays(int[] a, int[] b) {
        int[] res = new int[Math.max(a.length, b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < a.length && i < b.length ? a[i] + b[i] : (i < a.length ? a[i] : b[i]);
        }
        return res;
    }

    public boolean shouldDefragment() {
        assert (this.repaired.get(0).getClass().equals(this.unrepaired.get(0).getClass()));
        return this.repaired.get(0).shouldDefragment();
    }

    public Directories getDirectories() {
        assert (this.repaired.get(0).getClass().equals(this.unrepaired.get(0).getClass()));
        return this.repaired.get(0).getDirectories();
    }

    @Override
    public synchronized void handleNotification(INotification notification, Object sender) {
        this.maybeReload(this.cfs.metadata);
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification flushedNotification = (SSTableAddedNotification)notification;
            for (SSTableReader sstable : flushedNotification.added) {
                this.getCompactionStrategyFor(sstable).addSSTable(sstable);
            }
        } else if (notification instanceof SSTableListChangedNotification) {
            int i;
            SSTableListChangedNotification listChangedNotification = (SSTableListChangedNotification)notification;
            Directories.DataDirectory[] locations = this.cfs.getDirectories().getWriteableLocations();
            int locationSize = this.cfs.getPartitioner().splitter().isPresent() ? locations.length : 1;
            ArrayList repairedRemoved = new ArrayList(locationSize);
            ArrayList repairedAdded = new ArrayList(locationSize);
            ArrayList unrepairedRemoved = new ArrayList(locationSize);
            ArrayList unrepairedAdded = new ArrayList(locationSize);
            for (int i2 = 0; i2 < locationSize; ++i2) {
                repairedRemoved.add(new HashSet());
                repairedAdded.add(new HashSet());
                unrepairedRemoved.add(new HashSet());
                unrepairedAdded.add(new HashSet());
            }
            for (SSTableReader sstable : listChangedNotification.removed) {
                i = CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), sstable);
                if (sstable.isRepaired()) {
                    ((Set)repairedRemoved.get(i)).add(sstable);
                    continue;
                }
                ((Set)unrepairedRemoved.get(i)).add(sstable);
            }
            for (SSTableReader sstable : listChangedNotification.added) {
                i = CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), sstable);
                if (sstable.isRepaired()) {
                    ((Set)repairedAdded.get(i)).add(sstable);
                    continue;
                }
                ((Set)unrepairedAdded.get(i)).add(sstable);
            }
            for (int i3 = 0; i3 < locationSize; ++i3) {
                if (!((Set)repairedRemoved.get(i3)).isEmpty()) {
                    this.repaired.get(i3).replaceSSTables((Collection)repairedRemoved.get(i3), (Collection)repairedAdded.get(i3));
                } else {
                    for (SSTableReader sstable : (Set)repairedAdded.get(i3)) {
                        this.repaired.get(i3).addSSTable(sstable);
                    }
                }
                if (!((Set)unrepairedRemoved.get(i3)).isEmpty()) {
                    this.unrepaired.get(i3).replaceSSTables((Collection)unrepairedRemoved.get(i3), (Collection)unrepairedAdded.get(i3));
                    continue;
                }
                for (SSTableReader sstable : (Set)unrepairedAdded.get(i3)) {
                    this.unrepaired.get(i3).addSSTable(sstable);
                }
            }
        } else if (notification instanceof SSTableRepairStatusChanged) {
            for (SSTableReader sstable : ((SSTableRepairStatusChanged)notification).sstable) {
                int index = CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), sstable);
                if (sstable.isRepaired()) {
                    this.unrepaired.get(index).removeSSTable(sstable);
                    this.repaired.get(index).addSSTable(sstable);
                    continue;
                }
                this.repaired.get(index).removeSSTable(sstable);
                this.unrepaired.get(index).addSSTable(sstable);
            }
        } else if (notification instanceof SSTableDeletingNotification) {
            SSTableReader sstable = ((SSTableDeletingNotification)notification).deleting;
            this.getCompactionStrategyFor(sstable).removeSSTable(sstable);
        }
    }

    public void enable() {
        if (this.repaired != null) {
            this.repaired.forEach(AbstractCompactionStrategy::enable);
        }
        if (this.unrepaired != null) {
            this.unrepaired.forEach(AbstractCompactionStrategy::enable);
        }
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
        if (this.repaired != null) {
            this.repaired.forEach(AbstractCompactionStrategy::disable);
        }
        if (this.unrepaired != null) {
            this.unrepaired.forEach(AbstractCompactionStrategy::disable);
        }
    }

    public synchronized AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables, Collection<Range<Token>> ranges) {
        assert (this.repaired.size() == this.unrepaired.size());
        ArrayList repairedSSTables = new ArrayList();
        ArrayList unrepairedSSTables = new ArrayList();
        for (int i = 0; i < this.repaired.size(); ++i) {
            repairedSSTables.add(new HashSet());
            unrepairedSSTables.add(new HashSet());
        }
        for (SSTableReader sstable : sstables) {
            if (sstable.isRepaired()) {
                ((Set)repairedSSTables.get(CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), sstable))).add(sstable);
                continue;
            }
            ((Set)unrepairedSSTables.get(CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), sstable))).add(sstable);
        }
        ArrayList<ISSTableScanner> scanners = new ArrayList<ISSTableScanner>(sstables.size());
        for (Range<Token> range : ranges) {
            int i;
            ArrayList<ISSTableScanner> repairedScanners = new ArrayList<ISSTableScanner>();
            ArrayList unrepairedScanners = new ArrayList();
            for (i = 0; i < repairedSSTables.size(); ++i) {
                if (((Set)repairedSSTables.get(i)).isEmpty()) continue;
                repairedScanners.addAll(this.repaired.get((int)i).getScanners((Collection<SSTableReader>)((Collection)repairedSSTables.get((int)i)), range).scanners);
            }
            for (i = 0; i < unrepairedSSTables.size(); ++i) {
                if (((Set)unrepairedSSTables.get(i)).isEmpty()) continue;
                scanners.addAll(this.unrepaired.get((int)i).getScanners((Collection<SSTableReader>)((Collection)unrepairedSSTables.get((int)i)), range).scanners);
            }
            for (ISSTableScanner scanner : Iterables.concat(repairedScanners, unrepairedScanners)) {
                if (scanners.add(scanner)) continue;
                scanner.close();
            }
        }
        return new AbstractCompactionStrategy.ScannerList(scanners);
    }

    public synchronized AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables) {
        return this.getScanners(sstables, Collections.singleton(null));
    }

    public Collection<Collection<SSTableReader>> groupSSTablesForAntiCompaction(Collection<SSTableReader> sstablesToGroup) {
        Map<Integer, List<SSTableReader>> groups = sstablesToGroup.stream().collect(Collectors.groupingBy(s -> CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), s)));
        ArrayList<Collection<SSTableReader>> anticompactionGroups = new ArrayList<Collection<SSTableReader>>();
        for (Map.Entry<Integer, List<SSTableReader>> group : groups.entrySet()) {
            anticompactionGroups.addAll(this.unrepaired.get(group.getKey()).groupSSTablesForAntiCompaction((Collection<SSTableReader>)group.getValue()));
        }
        return anticompactionGroups;
    }

    public long getMaxSSTableBytes() {
        return this.unrepaired.get(0).getMaxSSTableBytes();
    }

    public AbstractCompactionTask getCompactionTask(LifecycleTransaction txn, int gcBefore, long maxSSTableBytes) {
        this.maybeReload(this.cfs.metadata);
        this.validateForCompaction(txn.originals());
        return this.getCompactionStrategyFor(txn.originals().iterator().next()).getCompactionTask(txn, gcBefore, maxSSTableBytes);
    }

    private void validateForCompaction(Iterable<SSTableReader> input) {
        SSTableReader firstSSTable = (SSTableReader)Iterables.getFirst(input, null);
        assert (firstSSTable != null);
        boolean repaired = firstSSTable.isRepaired();
        int firstIndex = CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), firstSSTable);
        for (SSTableReader sstable : input) {
            if (sstable.isRepaired() != repaired) {
                throw new UnsupportedOperationException("You can't mix repaired and unrepaired data in a compaction");
            }
            if (firstIndex == CompactionStrategyManager.getCompactionStrategyIndex(this.cfs, this.getDirectories(), sstable)) continue;
            throw new UnsupportedOperationException("You can't mix sstables from different directories in a compaction");
        }
    }

    public Collection<AbstractCompactionTask> getMaximalTasks(final int gcBefore, final boolean splitOutput) {
        this.maybeReload(this.cfs.metadata);
        return this.cfs.runWithCompactionsDisabled(new Callable<Collection<AbstractCompactionTask>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<AbstractCompactionTask> call() throws Exception {
                CompactionStrategyManager compactionStrategyManager = CompactionStrategyManager.this;
                synchronized (compactionStrategyManager) {
                    Collection<AbstractCompactionTask> task;
                    ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>();
                    for (AbstractCompactionStrategy strategy : CompactionStrategyManager.this.repaired) {
                        task = strategy.getMaximalTask(gcBefore, splitOutput);
                        if (task == null) continue;
                        tasks.addAll(task);
                    }
                    for (AbstractCompactionStrategy strategy : CompactionStrategyManager.this.unrepaired) {
                        task = strategy.getMaximalTask(gcBefore, splitOutput);
                        if (task == null) continue;
                        tasks.addAll(task);
                    }
                    if (tasks.isEmpty()) {
                        return null;
                    }
                    return tasks;
                }
            }
        }, false, false);
    }

    public AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        this.maybeReload(this.cfs.metadata);
        this.validateForCompaction(sstables);
        return this.getCompactionStrategyFor(sstables.iterator().next()).getUserDefinedTask(sstables, gcBefore);
    }

    public int getEstimatedRemainingTasks() {
        int tasks = 0;
        for (AbstractCompactionStrategy strategy : this.repaired) {
            tasks += strategy.getEstimatedRemainingTasks();
        }
        for (AbstractCompactionStrategy strategy : this.unrepaired) {
            tasks += strategy.getEstimatedRemainingTasks();
        }
        return tasks;
    }

    public boolean shouldBeEnabled() {
        return this.params.isEnabled();
    }

    public String getName() {
        return this.unrepaired.get(0).getName();
    }

    public List<List<AbstractCompactionStrategy>> getStrategies() {
        return Arrays.asList(this.repaired, this.unrepaired);
    }

    public synchronized void setNewLocalCompactionStrategy(CompactionParams params) {
        logger.info("Switching local compaction strategy from {} to {}}", (Object)this.params, (Object)params);
        this.setStrategy(params);
        if (this.shouldBeEnabled()) {
            this.enable();
        } else {
            this.disable();
        }
        this.startup();
    }

    private void setStrategy(CompactionParams params) {
        this.repaired.forEach(AbstractCompactionStrategy::shutdown);
        this.unrepaired.forEach(AbstractCompactionStrategy::shutdown);
        this.repaired.clear();
        this.unrepaired.clear();
        if (this.cfs.getPartitioner().splitter().isPresent()) {
            this.locations = this.cfs.getDirectories().getWriteableLocations();
            for (int i = 0; i < this.locations.length; ++i) {
                this.repaired.add(CFMetaData.createCompactionStrategyInstance(this.cfs, params));
                this.unrepaired.add(CFMetaData.createCompactionStrategyInstance(this.cfs, params));
            }
        } else {
            this.repaired.add(CFMetaData.createCompactionStrategyInstance(this.cfs, params));
            this.unrepaired.add(CFMetaData.createCompactionStrategyInstance(this.cfs, params));
        }
        this.params = params;
    }

    public CompactionParams getCompactionParams() {
        return this.params;
    }

    public boolean onlyPurgeRepairedTombstones() {
        return Boolean.parseBoolean(this.params.options().get("only_purge_repaired_tombstones"));
    }

    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, MetadataCollector collector, SerializationHeader header, Collection<Index> indexes, LifecycleTransaction txn) {
        if (repairedAt == 0L) {
            return this.unrepaired.get(0).createSSTableMultiWriter(descriptor, keyCount, repairedAt, collector, header, indexes, txn);
        }
        return this.repaired.get(0).createSSTableMultiWriter(descriptor, keyCount, repairedAt, collector, header, indexes, txn);
    }
}

